/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.client.Client;
import noppes.npcs.client.ClientCacheHandler;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.MessageAchievement;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.RenderChatMessages;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.ScriptClientSound;
import noppes.npcs.client.controllers.ScriptSoundController;
import noppes.npcs.client.gui.GuiNpcMobSpawnerAdd;
import noppes.npcs.client.gui.OverlayQuestTracking;
import noppes.npcs.client.gui.customoverlay.OverlayCustom;
import noppes.npcs.client.gui.player.GuiBook;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IPartyData;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.config.ConfigClient;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Animation;
import noppes.npcs.controllers.data.AnimationData;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBuf buffer = event.packet.payload();
        try {
            this.client(buffer, (EntityPlayer)player, EnumPacketClient.values()[buffer.readInt()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void client(ByteBuf buffer, EntityPlayer player, EnumPacketClient type) throws IOException {
        if (type == EnumPacketClient.CHATBUBBLE) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.messages == null) {
                npc.messages = new RenderChatMessages();
            }
            String text = NoppesStringUtils.formatText(Server.readString(buffer), new Object[]{player, npc});
            npc.messages.addMessage(text, npc);
            if (buffer.readBoolean()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(npc.func_70005_c_() + ": " + text, new Object[0]));
            }
        } else if (type == EnumPacketClient.CHAT) {
            String str;
            if (!ConfigClient.ChatAlerts) {
                return;
            }
            String message = "";
            while ((str = Server.readString(buffer)) != null && !str.isEmpty()) {
                message = message + StatCollector.func_74838_a((String)str);
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
        } else if (type == EnumPacketClient.MESSAGE || type == EnumPacketClient.PARTY_MESSAGE) {
            if (!ConfigClient.BannerAlerts) {
                return;
            }
            String description = StatCollector.func_74838_a((String)Server.readString(buffer));
            String message = Server.readString(buffer);
            MessageAchievement ach = type == EnumPacketClient.MESSAGE ? new MessageAchievement(message, description) : new MessageAchievement(CustomItems.bag == null ? Items.field_151121_aF : CustomItems.bag, message, description);
            Minecraft.func_71410_x().field_71458_u.func_146256_a((Achievement)ach);
            ObfuscationReflectionHelper.setPrivateValue(GuiAchievement.class, (Object)Minecraft.func_71410_x().field_71458_u, (Object)ach.func_75989_e(), (int)4);
        } else if (type == EnumPacketClient.SYNCRECIPES_ADD) {
            NBTTagList list = Server.readNBT(buffer).func_150295_c("recipes", 10);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                RecipeCarpentry recipe = RecipeCarpentry.read(list.func_150305_b(i));
                RecipeController.syncRecipes.put(recipe.id, recipe);
            }
        } else if (type == EnumPacketClient.SYNCRECIPES_WORKBENCH) {
            RecipeController.reloadGlobalRecipes(RecipeController.syncRecipes);
            RecipeController.syncRecipes = new HashMap();
        } else if (type == EnumPacketClient.SYNCRECIPES_CARPENTRYBENCH) {
            RecipeController.Instance.anvilRecipes = RecipeController.syncRecipes;
            RecipeController.syncRecipes = new HashMap();
        } else if (type == EnumPacketClient.SYNC_ADD || type == EnumPacketClient.SYNC_END) {
            int synctype = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            SyncController.clientSync(synctype, compound, type == EnumPacketClient.SYNC_END);
            if (synctype == 6) {
                ClientCacheHandler.playerData.setNBT(compound);
            }
        } else if (type == EnumPacketClient.SYNC_UPDATE) {
            int synctype = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            SyncController.clientSyncUpdate(synctype, compound, buffer);
        } else if (type == EnumPacketClient.SYNC_REMOVE) {
            int synctype = buffer.readInt();
            int id = buffer.readInt();
            SyncController.clientSyncRemove(synctype, id);
        } else if (type == EnumPacketClient.MARK_DATA) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity instanceof EntityNPCInterface)) {
                return;
            }
            MarkData data = MarkData.get((EntityNPCInterface)entity);
            data.setNBT(Server.readNBT(buffer));
        } else if (type == EnumPacketClient.DIALOG) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.openDialog(Server.readNBT(buffer), (EntityNPCInterface)entity, player);
        } else if (type == EnumPacketClient.DIALOG_DUMMY) {
            EntityDialogNpc npc = new EntityDialogNpc(player.field_70170_p);
            npc.display.name = Server.readString(buffer);
            EntityUtil.Copy((EntityLivingBase)player, (EntityLivingBase)npc);
            NoppesUtil.openDialog(Server.readNBT(buffer), npc, player);
        } else if (type == EnumPacketClient.QUEST_COMPLETION) {
            NoppesUtil.guiQuestCompletion(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.EDIT_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.PLAY_MUSIC) {
            MusicController.Instance.playMusic(Server.readString(buffer), (Entity)player);
        } else if (type == EnumPacketClient.PLAY_SOUND) {
            MusicController.Instance.playSound(Server.readString(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        } else if (type == EnumPacketClient.UPDATE_NPC) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).readSpawnData(compound);
        } else if (type == EnumPacketClient.ROLE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).advanced.setRole(compound.func_74762_e("Role"));
            ((EntityNPCInterface)entity).roleInterface.readFromNBT(compound);
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.GUI) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            CustomNpcs.proxy.openGui(NoppesUtil.getLastNpc(), gui, buffer.readInt(), buffer.readInt(), buffer.readInt());
        } else if (type == EnumPacketClient.SCRIPTED_PARTICLE) {
            NoppesUtil.spawnScriptedParticle(player, buffer);
        } else if (type == EnumPacketClient.PARTICLE) {
            NoppesUtil.spawnParticle(buffer);
        } else if (type == EnumPacketClient.DELETE_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).delete();
        } else if (type == EnumPacketClient.SCROLL_LIST) {
            NoppesUtil.setScrollList(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA) {
            NoppesUtil.setScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA_PART) {
            NoppesUtil.addScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_GROUP) {
            NoppesUtil.setScrollGroup(buffer);
        } else if (type == EnumPacketClient.SCROLL_GROUP_PART) {
            NoppesUtil.addScrollGroup(buffer);
        } else if (type == EnumPacketClient.SCROLL_SELECTED) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IScrollData)) {
                return;
            }
            String selected = Server.readString(buffer);
            ((IScrollData)gui).setSelected(selected);
        } else if (type == EnumPacketClient.GUI_REDSTONE) {
            NoppesUtil.saveRedstoneBlock(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.GUI_WAYPOINT) {
            NoppesUtil.saveWayPointBlock(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.CLONE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            NoppesUtil.openGUI(player, new GuiNpcMobSpawnerAdd(compound));
        } else if (type == EnumPacketClient.CLONER) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            CustomNpcs.proxy.openGui(x, y, z, EnumGuiType.MobSpawner, player);
        } else if (type == EnumPacketClient.TELEPORTER) {
            CustomNpcs.proxy.openGui((EntityNPCInterface)null, EnumGuiType.NpcDimensions);
        } else if (type == EnumPacketClient.GUI_DATA) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
                gui = ((GuiNPCInterface)gui).getSubGui();
            } else if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
                gui = ((GuiContainerNPCInterface)gui).getSubGui();
            }
            if (gui instanceof IGuiData) {
                ((IGuiData)gui).setGuiData(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketClient.GUI_ERROR) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IGuiError)) {
                return;
            }
            int i = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            ((IGuiError)gui).setError(i, compound);
        } else if (type == EnumPacketClient.GUI_CLOSE) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof IGuiClose) {
                int i = buffer.readInt();
                NBTTagCompound compound = Server.readNBT(buffer);
                ((IGuiClose)gui).setClose(i, compound);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a(null);
            mc.func_71381_h();
        } else if (type == EnumPacketClient.VILLAGER_LIST) {
            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ServerEventsHandler.Merchant.func_70930_a(merchantrecipelist);
        } else if (type == EnumPacketClient.OPEN_BOOK) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            NoppesUtil.openGUI(player, (Object)new GuiBook(player, ItemStack.func_77949_a((NBTTagCompound)Server.readNBT(buffer)), x, y, z));
        } else if (type == EnumPacketClient.CONFIG) {
            int config = buffer.readInt();
            if (config == 0) {
                String font = Server.readString(buffer);
                int size = buffer.readInt();
                if (!font.isEmpty()) {
                    ConfigClient.FontType = font;
                    ConfigClient.FontSize = size;
                    ClientProxy.Font = new ClientProxy.FontContainer(ConfigClient.FontType, ConfigClient.FontSize);
                    ConfigClient.FontTypeProperty.set(ConfigClient.FontType);
                    ConfigClient.FontSizeProperty.set(ConfigClient.FontSize);
                    if (ConfigClient.config.hasChanged()) {
                        ConfigClient.config.save();
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("Font set to %s", new Object[]{ClientProxy.Font.getName()}));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("Current font is %s", new Object[]{ClientProxy.Font.getName()}));
                }
            }
        } else if (type == EnumPacketClient.ISGUIOPEN) {
            boolean isGUIOpen = Minecraft.func_71410_x().field_71462_r != null;
            NoppesUtil.isGUIOpen(isGUIOpen);
        } else if (type == EnumPacketClient.SCRIPT_OVERLAY_DATA) {
            OverlayCustom overlayCustom = new OverlayCustom(Minecraft.func_71410_x());
            overlayCustom.setOverlayData(Server.readNBT(buffer));
            ClientCacheHandler.customOverlays.put(overlayCustom.overlay.getID(), overlayCustom);
        } else if (type == EnumPacketClient.SCRIPT_OVERLAY_CLOSE) {
            int id = buffer.readInt();
            ClientCacheHandler.customOverlays.remove(id);
        } else if (type == EnumPacketClient.OVERLAY_QUEST_TRACKING) {
            try {
                NBTTagCompound compound = Server.readNBT(buffer);
                ClientCacheHandler.questTrackingOverlay = new OverlayQuestTracking(Minecraft.func_71410_x());
                ClientCacheHandler.questTrackingOverlay.setOverlayData(compound);
            }
            catch (IOException e) {
                ClientCacheHandler.questTrackingOverlay = null;
            }
        } else if (type == EnumPacketClient.SWING_PLAYER_ARM) {
            Minecraft.func_71410_x().field_71439_g.func_71038_i();
        } else if (type == EnumPacketClient.PLAYER_UPDATE_SKIN_OVERLAYS) {
            EntityPlayer sendingPlayer = Minecraft.func_71410_x().field_71441_e.func_72924_a(Server.readString(buffer));
            NBTTagCompound compound = Server.readNBT(buffer);
            if (sendingPlayer != null) {
                NoppesUtil.updateSkinOverlayData(sendingPlayer, compound);
            }
        } else if (type == EnumPacketClient.UPDATE_ANIMATIONS) {
            NBTTagCompound compound = Server.readNBT(buffer);
            AnimationData animationData = null;
            if (compound.func_74764_b("EntityId")) {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
                if (entity instanceof EntityNPCInterface) {
                    animationData = ((EntityNPCInterface)entity).display.animationData;
                }
            } else {
                EntityPlayer sendingPlayer = Minecraft.func_71410_x().field_71441_e.func_72924_a(Server.readString(buffer));
                if (sendingPlayer != null) {
                    if (!ClientCacheHandler.playerAnimations.containsKey(sendingPlayer.func_110124_au())) {
                        ClientCacheHandler.playerAnimations.put(sendingPlayer.func_110124_au(), new AnimationData(sendingPlayer));
                    }
                    animationData = ClientCacheHandler.playerAnimations.get(sendingPlayer.func_110124_au());
                    animationData.parent = sendingPlayer;
                }
            }
            if (animationData != null) {
                int animationId;
                if (compound.func_74764_b("AnimationID")) {
                    animationId = compound.func_74762_e("AnimationID");
                } else {
                    Animation animation = new Animation();
                    animation.readFromNBT(compound.func_74775_l("Animation"));
                    ClientCacheHandler.animationCache.put(animation.getID(), animation);
                    animationId = animation.getID();
                }
                animationData.setAnimation(ClientCacheHandler.animationCache.get(animationId));
                animationData.readFromNBT(compound);
                Client.sendData(EnumPacketServer.CacheAnimation, animationId);
            }
        } else if (type == EnumPacketClient.DISABLE_MOUSE_INPUT) {
            long length = buffer.readLong();
            try {
                String[] splitIds;
                String parsedButtons = Server.readString(buffer);
                if (parsedButtons == null || parsedButtons.isEmpty()) {
                    ClientEventHandler.disabledButtonTimes.put(-1, length);
                    return;
                }
                for (String s : splitIds = parsedButtons.split(";")) {
                    ClientEventHandler.disabledButtonTimes.put(Integer.parseInt(s), length);
                }
            }
            catch (Exception parsedButtons) {}
        } else if (type == EnumPacketClient.PLAY_SOUND_TO) {
            int id = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            ScriptClientSound sound = ScriptClientSound.fromScriptSound(compound, player.field_70170_p);
            ScriptSoundController.Instance.playSound(id, sound);
        } else if (type == EnumPacketClient.PLAY_SOUND_TO_NO_ID) {
            NBTTagCompound compound = Server.readNBT(buffer);
            ScriptClientSound sound = ScriptClientSound.fromScriptSound(compound, player.field_70170_p);
            ScriptSoundController.Instance.playSound(sound);
        } else if (type == EnumPacketClient.STOP_SOUND_FOR) {
            int id = buffer.readInt();
            ScriptSoundController.Instance.stopSound(id);
        } else if (type == EnumPacketClient.PAUSE_SOUNDS) {
            ScriptSoundController.Instance.pauseAllSounds();
        } else if (type == EnumPacketClient.CONTINUE_SOUNDS) {
            ScriptSoundController.Instance.continueAllSounds();
        } else if (type == EnumPacketClient.STOP_SOUNDS) {
            ScriptSoundController.Instance.stopAllSounds();
        } else if (type == EnumPacketClient.SYNC_WEAPON) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            int weaponSlotIndex = buffer.readInt();
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)Server.readNBT(buffer));
            npc.inventory.weapons.put(weaponSlotIndex, stack);
        } else if (type == EnumPacketClient.PARTY_DATA) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
                gui = ((GuiNPCInterface)gui).getSubGui();
            } else if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
                gui = ((GuiContainerNPCInterface)gui).getSubGui();
            }
            if (gui instanceof IPartyData) {
                ((IPartyData)gui).setPartyData(Server.readNBT(buffer));
            }
        }
    }
}

