/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.script;

import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.script.GuiScriptInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.PlayerDataScript;

public class GuiScriptPlayers
extends GuiScriptInterface {
    private PlayerDataScript script = new PlayerDataScript(null);

    public GuiScriptPlayers() {
        this.hookList.add("init");
        this.hookList.add("tick");
        this.hookList.add("interact");
        this.hookList.add("attack");
        this.hookList.add("attacked");
        this.hookList.add("damagedEntity");
        this.hookList.add("damaged");
        this.hookList.add("kills");
        this.hookList.add("killed");
        this.hookList.add("drop");
        this.hookList.add("respawn");
        this.hookList.add("breakBlock");
        this.hookList.add("chat");
        this.hookList.add("login");
        this.hookList.add("logout");
        this.hookList.add("keyPressed");
        this.hookList.add("mouseClicked");
        this.hookList.add("toss");
        this.hookList.add("pickUp");
        this.hookList.add("pickupXP");
        this.hookList.add("rangedCharge");
        this.hookList.add("rangedLaunched");
        this.hookList.add("timer");
        this.hookList.add("startItem");
        this.hookList.add("usingItem");
        this.hookList.add("stopItem");
        this.hookList.add("finishItem");
        this.hookList.add("containerOpen");
        this.hookList.add("useHoe");
        this.hookList.add("bonemeal");
        this.hookList.add("fillBucket");
        this.hookList.add("jump");
        this.hookList.add("fall");
        this.hookList.add("wakeUp");
        this.hookList.add("sleep");
        this.hookList.add("playSound");
        this.hookList.add("lightning");
        this.hookList.add("changedDim");
        this.hookList.add("questStart");
        this.hookList.add("questCompleted");
        this.hookList.add("questTurnIn");
        this.hookList.add("factionPoints");
        this.hookList.add("dialogOpen");
        this.hookList.add("dialogOption");
        this.hookList.add("dialogClose");
        this.hookList.add("customGuiClosed");
        this.hookList.add("customGuiButton");
        this.hookList.add("customGuiSlot");
        this.hookList.add("customGuiSlotClicked");
        this.hookList.add("customGuiScroll");
        this.hookList.add("customGuiTextfield");
        this.hookList.add("partyQuestCompleted");
        this.hookList.add("partyQuestSet");
        this.hookList.add("partyQuestTurnedIn");
        this.hookList.add("partyInvite");
        this.hookList.add("partyKick");
        this.hookList.add("partyLeave");
        this.hookList.add("partyDisband");
        this.handler = this.script;
        Client.sendData(EnumPacketServer.ScriptPlayerGet, new Object[0]);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (!compound.func_74764_b("Tab")) {
            this.script.setLanguage(compound.func_74779_i("ScriptLanguage"));
            this.script.setEnabled(compound.func_74767_n("ScriptEnabled"));
            super.setGuiData(compound);
        } else {
            int tab = compound.func_74762_e("Tab");
            ScriptContainer container = new ScriptContainer(this.script);
            container.readFromNBT(compound.func_74775_l("Script"));
            if (this.script.getScripts().isEmpty()) {
                for (int i = 0; i < compound.func_74762_e("TotalScripts"); ++i) {
                    this.script.getScripts().add(new ScriptContainer(this.script));
                }
            }
            this.script.getScripts().set(tab, container);
            this.func_73866_w_();
        }
    }

    @Override
    public void save() {
        super.save();
        List<ScriptContainer> containers = this.script.getScripts();
        for (int i = 0; i < containers.size(); ++i) {
            ScriptContainer container = containers.get(i);
            Client.sendData(EnumPacketServer.ScriptPlayerSave, i, containers.size(), container.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound scriptData = new NBTTagCompound();
        scriptData.func_74778_a("ScriptLanguage", this.script.getLanguage());
        scriptData.func_74757_a("ScriptEnabled", this.script.getEnabled());
        scriptData.func_74782_a("ScriptConsole", (NBTBase)NBTTags.NBTLongStringMap(this.script.getConsoleText()));
        Client.sendData(EnumPacketServer.ScriptPlayerSave, -1, containers.size(), scriptData);
    }
}

