/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.api.bossbar;

import io.github.cruciblemc.necrotempus.api.bossbar.BossBarColor;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarType;
import io.github.cruciblemc.necrotempus.api.bossbar.TimedElement;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;

public abstract class BossBarComponent
extends TimedElement {
    private final UUID uuid;
    private ChatComponentText text;
    private BossBarColor color;
    private BossBarType type;
    private float percentage;
    private boolean isVisible;
    private int lazyColor = -1;

    protected BossBarComponent(NBTTagCompound nbtTagCompound) {
        this.uuid = UUID.fromString(nbtTagCompound.func_74779_i("uuid"));
        this.text = new ChatComponentText(nbtTagCompound.func_74779_i("text"));
        this.type = BossBarType.valueOfString(nbtTagCompound.func_74779_i("type"));
        this.color = BossBarColor.valueOfString(nbtTagCompound.func_74779_i("color"));
        this.isVisible = nbtTagCompound.func_74767_n("isVisible");
        this.percentage = nbtTagCompound.func_74760_g("percentage");
    }

    protected BossBarComponent(UUID uuid) {
        this(uuid, new ChatComponentText(""), BossBarColor.PINK, BossBarType.FLAT, Float.valueOf(1.0f), true);
    }

    protected BossBarComponent() {
        this(UUID.randomUUID());
    }

    protected BossBarComponent(UUID uuid, ChatComponentText text, BossBarColor color, BossBarType type, Float percent, boolean isVisible) {
        this.uuid = uuid;
        this.text = text;
        this.type = type;
        this.color = color;
        this.setPercentage(percent.floatValue());
        this.isVisible = isVisible;
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a("text", this.text.func_150265_g());
        nbtTagCompound.func_74778_a("type", this.type.getType());
        nbtTagCompound.func_74776_a("percentage", this.percentage);
        nbtTagCompound.func_74757_a("isVisible", this.isVisible);
        nbtTagCompound.func_74778_a("uuid", this.uuid.toString());
        if (this.color == BossBarColor.LAZY) {
            nbtTagCompound.func_74778_a("color", "$" + this.color.intValue());
        } else {
            nbtTagCompound.func_74778_a("color", this.color.getIdentifier());
        }
        return nbtTagCompound;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BossBarComponent)) {
            return false;
        }
        BossBarComponent other = (BossBarComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Float.compare(this.getPercentage(), other.getPercentage()) != 0) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.getLazyColor() != other.getLazyColor()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        ChatComponentText this$text = this.getText();
        ChatComponentText other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        BossBarColor this$color = this.getColor();
        BossBarColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        BossBarType this$type = this.getType();
        BossBarType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BossBarComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Float.floatToIntBits(this.getPercentage());
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + this.getLazyColor();
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        ChatComponentText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        BossBarColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        BossBarType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ChatComponentText getText() {
        return this.text;
    }

    public BossBarColor getColor() {
        return this.color;
    }

    public BossBarType getType() {
        return this.type;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getLazyColor() {
        return this.lazyColor;
    }

    public void setText(ChatComponentText text) {
        this.text = text;
    }

    public void setColor(BossBarColor color) {
        this.color = color;
    }

    public void setType(BossBarType type) {
        this.type = type;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setLazyColor(int lazyColor) {
        this.lazyColor = lazyColor;
    }

    @Override
    public String toString() {
        return "BossBarComponent(uuid=" + this.getUuid() + ", text=" + this.getText() + ", color=" + (Object)((Object)this.getColor()) + ", type=" + (Object)((Object)this.getType()) + ", percentage=" + this.getPercentage() + ", isVisible=" + this.isVisible() + ", lazyColor=" + this.getLazyColor() + ")";
    }
}

