/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.network;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ServerModelPartsStorage {
    private static final Map<Integer, int[]> modelPartsMap = new ConcurrentHashMap<Integer, int[]>();

    public static void setModelParts(EntityPlayerMP player, int[] parts) {
        modelPartsMap.put(player.func_145782_y(), parts);
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound modelTag = new NBTTagCompound();
        for (int i = 0; i < parts.length; ++i) {
            modelTag.func_74768_a("part" + i, parts[i]);
        }
        modelTag.func_74768_a("count", parts.length);
        tag.func_74782_a("ModelParts", (NBTBase)modelTag);
    }

    public static int[] getModelParts(EntityPlayerMP player) {
        if (modelPartsMap.containsKey(player.func_145782_y())) {
            return modelPartsMap.get(player.func_145782_y());
        }
        NBTTagCompound tag = player.getEntityData();
        if (tag.func_74764_b("ModelParts")) {
            NBTBase base = tag.func_74781_a("ModelParts");
            if (base instanceof NBTTagCompound) {
                NBTTagCompound modelTag = (NBTTagCompound)base;
                int count = modelTag.func_74762_e("count");
                int[] parts = new int[count];
                for (int i = 0; i < count; ++i) {
                    parts[i] = modelTag.func_74762_e("part" + i);
                }
                modelPartsMap.put(player.func_145782_y(), parts);
                return parts;
            }
            tag.func_82580_o("ModelParts");
            return new int[0];
        }
        return new int[0];
    }

    public static void removePlayer(EntityPlayerMP player) {
        modelPartsMap.remove(player.func_145782_y());
    }

    public static void clearAll() {
        modelPartsMap.clear();
    }
}

