/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.glyphs;

import io.github.cruciblemc.necrotempus.modules.features.glyphs.CustomGlyphs;
import io.github.cruciblemc.necrotempus.modules.features.modernfonts.ModernFontEntry;
import io.github.cruciblemc.necrotempus.utils.MathUtils;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import org.lwjgl.opengl.GL11;

public class GlyphsRender {
    public static float renderGlyph(TextureManager textureManager, ModernFontEntry entry, float posX, float posY, boolean shadow) {
        textureManager.func_110577_a(entry.location);
        GlyphsRender.drawGlyphAtlas(posX, posY, entry, shadow);
        return entry.width + 1;
    }

    public static float renderGlyph(TextureManager textureManager, CustomGlyphs customGlyphs, float posX, float posY, boolean shadow, float alpha) {
        if (!shadow) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            textureManager.func_110577_a(customGlyphs.getResource());
            float realX = posX + (float)(customGlyphs.getHorizontalPadding() * -1);
            float realY = posY + (float)(customGlyphs.getVerticalPadding() * -1);
            if (customGlyphs.getFitMode() != CustomGlyphs.FitMode.NONE) {
                GlyphsRender.drawGlyphContains(realX, realY, customGlyphs);
            } else {
                GlyphsRender.drawGlyph(realX, realY, customGlyphs.getWidth(), customGlyphs.getHeight());
            }
        }
        return customGlyphs.getFinalCharacterWidth();
    }

    private static void drawGlyph(float x, float y, int width, int height) {
        Tessellator ts = Tessellator.field_78398_a;
        ts.func_78382_b();
        GlyphsRender.add(ts, x, y + (float)height, 0.0f, 1.0f);
        GlyphsRender.add(ts, x + (float)width, y + (float)height, 1.0f, 1.0f);
        GlyphsRender.add(ts, x + (float)width, y, 1.0f, 0.0f);
        GlyphsRender.add(ts, x, y, 0.0f, 0.0f);
        ts.func_78381_a();
    }

    private static void drawGlyphAtlas(float x, float y, ModernFontEntry entry, boolean shadow) {
        float glyphPixelX = entry.atlasX * entry.frameWidth;
        float glyphPixelY = entry.atlasY * entry.frameHeight;
        float u0 = glyphPixelX / (float)entry.totalWidth;
        float v0 = glyphPixelY / (float)entry.totalHeight;
        float u1 = (glyphPixelX + (float)entry.width) / (float)entry.totalWidth;
        float v1 = (glyphPixelY + (float)entry.height) / (float)entry.totalHeight;
        float offset = shadow ? 1.0f : 0.0f;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)u0, (float)v1);
        GL11.glVertex3f((float)(x - offset), (float)((y += 7.0f - (float)entry.ascent) + (float)entry.height), (float)0.0f);
        GL11.glTexCoord2f((float)u1, (float)v1);
        GL11.glVertex3f((float)(x + (float)entry.width - offset), (float)(y + (float)entry.height), (float)0.0f);
        GL11.glTexCoord2f((float)u1, (float)v0);
        GL11.glVertex3f((float)(x + (float)entry.width - offset), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)u0, (float)v0);
        GL11.glVertex3f((float)(x - offset), (float)y, (float)0.0f);
        GL11.glEnd();
    }

    private static void drawGlyphContains(float x, float y, CustomGlyphs customGlyphs) {
        CustomGlyphs.FitMode fitMode = customGlyphs.getFitMode();
        y -= 1.0f;
        float height = 9.0f;
        float width = fitMode == CustomGlyphs.FitMode.CONTAINS ? 9.0f : MathUtils.calculateWidth(customGlyphs.getWidth(), customGlyphs.getHeight(), 9.0f);
        float nW = 1.0f / width;
        float nH = 1.0f / height;
        Tessellator ts = Tessellator.field_78398_a;
        ts.func_78382_b();
        GlyphsRender.add(ts, x, y + height, 0.0f, height * nH);
        GlyphsRender.add(ts, x + width, y + height, width * nW, height * nH);
        GlyphsRender.add(ts, x + width, y, width * nW, 0.0f);
        GlyphsRender.add(ts, x, y, 0.0f, 0.0f);
        ts.func_78381_a();
    }

    private static void add(Tessellator tessellator, float x, float y, float textureX, float textureY) {
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)textureX, (double)textureY);
    }
}

