/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.mixin.mixins.minecraft;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.github.cruciblemc.necrotempus.NecroTempusConfig;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiIngame.class})
public class GuiIngameMixin
extends Gui {
    @Inject(method={"Lnet/minecraft/client/gui/GuiIngame;func_96136_a(Lnet/minecraft/scoreboard/ScoreObjective;IILnet/minecraft/client/gui/FontRenderer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void func_96136_a(ScoreObjective scoreObjective, int y, int x, FontRenderer fontRenderer, CallbackInfo callbackInfo) {
        Scoreboard scoreboard = scoreObjective.func_96682_a();
        Collection scores = scoreboard.func_96534_i(scoreObjective);
        if (scores.size() > 15) {
            scores = Lists.newArrayList((Iterable)Iterables.skip((Iterable)scores, (int)(scores.size() - 15)));
        }
        int leftPadding = 1;
        int rightPadding = 1;
        int marginRight = 2;
        int scoreSpacing = 2;
        int titleVerticalPadding = 2;
        int maxNameWidth = fontRenderer.func_78256_a(scoreObjective.func_96678_d());
        int maxScoreWidth = 0;
        for (Score score : scores) {
            int sWidth;
            int nameWidth;
            ScorePlayerTeam team = scoreboard.func_96509_i(score.func_96653_e());
            String formattedName = ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e());
            String scoreText = EnumChatFormatting.RED + String.valueOf(score.func_96652_c());
            if (formattedName.contains("||")) {
                String[] parts = formattedName.split("\\|\\|", 2);
                nameWidth = fontRenderer.func_78256_a(parts[0]) + fontRenderer.func_78256_a(parts[1]);
            } else {
                nameWidth = fontRenderer.func_78256_a(formattedName);
            }
            if (nameWidth > maxNameWidth) {
                maxNameWidth = nameWidth;
            }
            if (NecroTempusConfig.hideScores || (sWidth = fontRenderer.func_78256_a(scoreText)) <= maxScoreWidth) continue;
            maxScoreWidth = sWidth;
        }
        int contentWidth = maxNameWidth;
        if (!NecroTempusConfig.hideScores) {
            contentWidth += scoreSpacing + maxScoreWidth;
        }
        int totalWidth = contentWidth + leftPadding + rightPadding;
        int boxRight = x - marginRight;
        int boxLeft = boxRight - totalWidth;
        int innerRight = boxRight - rightPadding;
        int lineHeight = fontRenderer.field_78288_b;
        int totalHeight = scores.size() * lineHeight;
        int baseY = y / 2 + totalHeight / 3;
        Iterator scoreIterator = scores.iterator();
        int index = 0;
        int scoresSize = scores.size();
        int lastLineY = 0;
        while (scoreIterator.hasNext()) {
            int currentY;
            Score score = (Score)scoreIterator.next();
            ScorePlayerTeam team = scoreboard.func_96509_i(score.func_96653_e());
            String formattedName = ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e());
            String scoreText = EnumChatFormatting.RED + String.valueOf(score.func_96652_c());
            lastLineY = currentY = baseY - ++index * lineHeight;
            GL11.glPushMatrix();
            GuiIngameMixin.func_73734_a((int)(boxLeft - 2), (int)currentY, (int)boxRight, (int)(currentY + lineHeight), (int)0x50000000);
            GL11.glPopMatrix();
            int currentScoreWidth = !NecroTempusConfig.hideScores ? fontRenderer.func_78256_a(scoreText) : 0;
            int scoreX = innerRight - currentScoreWidth;
            if (formattedName.contains("||")) {
                String[] parts = formattedName.split("\\|\\|", 2);
                String leftText = parts[0];
                String rightText = parts[1];
                fontRenderer.func_78276_b(leftText, boxLeft, currentY, -1);
                int rightBoundary = !NecroTempusConfig.hideScores ? scoreX - scoreSpacing : innerRight;
                int rightTextWidth = fontRenderer.func_78256_a(rightText);
                int rightTextX = rightBoundary - rightTextWidth;
                fontRenderer.func_78276_b(rightText, rightTextX, currentY, -1);
            } else {
                fontRenderer.func_78276_b(formattedName, boxLeft, currentY, -1);
            }
            if (NecroTempusConfig.hideScores) continue;
            fontRenderer.func_78276_b(scoreText, scoreX, currentY, -1);
        }
        if (lastLineY != 0) {
            String title = scoreObjective.func_96678_d();
            int titleTop = lastLineY - lineHeight + titleVerticalPadding;
            GL11.glPushMatrix();
            GuiIngameMixin.func_73734_a((int)(boxLeft - 2), (int)(titleTop - 1), (int)boxRight, (int)titleTop, (int)(NecroTempusConfig.titleBackground ? 0x60000000 : 0x50000000));
            GuiIngameMixin.func_73734_a((int)(boxLeft - 2), (int)titleTop, (int)boxRight, (int)lastLineY, (int)0x50000000);
            GL11.glPopMatrix();
            int titleWidth = fontRenderer.func_78256_a(title);
            int titleX = boxLeft + (totalWidth - titleWidth) / 2;
            fontRenderer.func_78276_b(title, titleX, titleTop, -1);
        }
        callbackInfo.cancel();
    }
}

