/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc;

import JinRyuu.JRMCore.entity.EntityCusPar;
import JinRyuu.JRMCore.server.config.dbc.JGConfigDBCFormMastery;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Iterator;
import java.util.Random;
import kamkeel.npcdbc.combat.Dodge;
import kamkeel.npcdbc.config.ConfigDBCEffects;
import kamkeel.npcdbc.config.ConfigDBCGameplay;
import kamkeel.npcdbc.constants.DBCRace;
import kamkeel.npcdbc.controllers.DBCEffectController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.controllers.FusionHandler;
import kamkeel.npcdbc.controllers.TransformController;
import kamkeel.npcdbc.data.IAuraData;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.npc.DBCDisplay;
import kamkeel.npcdbc.entity.EntityAura;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import kamkeel.npcdbc.mixins.late.IPlayerDBCInfo;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.packets.get.CapsuleInfo;
import kamkeel.npcdbc.network.packets.get.DBCInfoSyncPacket;
import kamkeel.npcdbc.network.packets.player.LoginInfo;
import kamkeel.npcdbc.util.DBCUtils;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import kamkeel.npcs.network.enums.EnumSyncAction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class ServerEventHandler {
    @SubscribeEvent
    public void loginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player == null || event.player.field_70170_p == null || event.player.field_70170_p.field_72995_K || event.player instanceof FakePlayer) {
            return;
        }
        DBCData dbcData = DBCData.get(event.player);
        dbcData.loadNBTData(true);
        DBCPacketHandler.Instance.sendToPlayer(new CapsuleInfo(CapsuleInfo.InfoType.COOLDOWN), (EntityPlayerMP)event.player);
        DBCPacketHandler.Instance.sendToPlayer(new CapsuleInfo(CapsuleInfo.InfoType.STRENGTH), (EntityPlayerMP)event.player);
        DBCPacketHandler.Instance.sendToPlayer(new CapsuleInfo(CapsuleInfo.InfoType.EFFECT_TIME), (EntityPlayerMP)event.player);
        DBCPacketHandler.Instance.sendToPlayer(new LoginInfo(), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        Entity e = event.entity;
        if (e instanceof EntityPlayer || e instanceof EntityCustomNpc) {
            IAuraData auraData = PlayerDataUtil.getAuraData(e);
            EntityAura aura = auraData.getAuraEntity();
            if (aura != null) {
                aura.func_70106_y();
                for (EntityAura child : aura.children.values()) {
                    child.func_70106_y();
                }
            }
            Iterator<EntityCusPar> iter = auraData.getParticles().iterator();
            while (iter.hasNext()) {
                iter.next().func_70106_y();
                iter.remove();
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null || event.player.field_70170_p == null || event.player.field_70170_p.field_72995_K || event.player instanceof FakePlayer) {
            return;
        }
        EntityPlayer player = event.player;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            PlayerData playerData;
            if (PlayerDataController.Instance != null && ((IPlayerDBCInfo)(playerData = PlayerDataController.Instance.getPlayerData(player))).getDBCInfoUpdate()) {
                NBTTagCompound formCompound = new NBTTagCompound();
                playerData.getDBCSync(formCompound);
                DBCPacketHandler.Instance.sendToPlayer(new DBCInfoSyncPacket(0, EnumSyncAction.RELOAD, -1, formCompound), (EntityPlayerMP)player);
                ((IPlayerDBCInfo)playerData).endDBCInfo();
            }
            if (ConfigDBCEffects.AUTO_BLOATED && player.field_70173_aa % ConfigDBCEffects.DECREASE_TIME == 0) {
                DBCEffectController.Instance.decreaseSenzuConsumption(player);
            }
            if (ConfigDBCGameplay.WearableEarrings && player.field_70173_aa % 60 == 0) {
                FusionHandler.checkNearbyPlayers(player);
            }
            if (player.field_70173_aa % 10 == 0) {
                DBCData dbcData = DBCData.get(player);
                if (ConfigDBCGameplay.EnableNamekianRegen && dbcData.Race == 3) {
                    dbcData.stats.applyNamekianRegen();
                }
                if (ConfigDBCGameplay.EnableHumanSpirit && dbcData.Race == 0) {
                    DBCEffectController.Instance.checkHumanSpirit(player);
                }
                dbcData.syncTracking();
            }
            this.handleFormProcesses(player);
            if (ConfigDBCGameplay.RevampKiCharging) {
                this.chargeKi(player);
            }
        }
    }

    public void chargeKi(EntityPlayer player) {
        DBCData dbcData = DBCData.getData(player);
        dbcData.loadCharging();
        if (!dbcData.isChargingKi()) {
            return;
        }
        int chargeTick = 16 - (ConfigDBCGameplay.KiPotentialUnlock ? (int)dbcData.stats.getPotentialUnlockLevel() : 6);
        if (player.field_70173_aa % chargeTick != 0) {
            return;
        }
        int releaseFactor = ConfigDBCGameplay.KiChargeRate;
        boolean powerDown = dbcData.isFnPressed;
        byte release = dbcData.Release;
        byte maxRelease = (byte)((byte)(50 + dbcData.stats.getPotentialUnlockLevel() * 5) + (byte)(DBCEffectController.Instance.hasEffect(player, 8) ? ConfigDBCEffects.OVERPOWER_AMOUNT : 0));
        int newRelease = ValueUtil.clamp((int)(!powerDown ? release + releaseFactor : release - releaseFactor), (int)((byte)releaseFactor), (int)maxRelease);
        dbcData.getRawCompound().func_74774_a("jrmcRelease", (byte)newRelease);
    }

    @SubscribeEvent
    public void playerDeathEvent(LivingDeathEvent event) {
        if (event.entityLiving == null || event.entityLiving.field_70170_p == null || event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (event.entityLiving.field_70170_p instanceof WorldServer && event.entityLiving instanceof EntityPlayer) {
            PlayerDBCInfo dbcInfo = PlayerDataUtil.getDBCInfo((EntityPlayer)event.entityLiving);
            DBCData dbcData = DBCData.get((EntityPlayer)event.entityLiving);
            dbcData.addonFormID = -1;
            dbcInfo.currentForm = -1;
            dbcInfo.updateClient();
        }
    }

    public void handleFormProcesses(EntityPlayer player) {
        DBCData dbcData = DBCData.get(player);
        Form form = dbcData.getForm();
        if (form == null) {
            return;
        }
        if (dbcData.lastTicked == player.field_70173_aa) {
            return;
        }
        dbcData.lastTicked = player.field_70173_aa;
        boolean isInSurvival = !player.field_71075_bZ.field_75098_d;
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(player);
        if (dbcData.Release <= 0 || dbcData.Ki <= 0) {
            formData.currentForm = -1;
            formData.updateClient();
            dbcData.loadNBTData(true);
        }
        if (!form.stackable.godStackable && dbcData.isForm(24)) {
            dbcData.setForm(24, false);
        }
        if (!form.stackable.mysticStackable && dbcData.isForm(21)) {
            dbcData.setForm(21, false);
        }
        if (!form.stackable.uiStackable && dbcData.isForm(41)) {
            dbcData.setForm(41, false);
        }
        if (!form.stackable.kaiokenStackable && dbcData.isForm(31)) {
            dbcData.setForm(31, false);
        }
        if (formData.hasTimer(form.id)) {
            formData.decrementTimer(form.id);
            if (player.field_70173_aa % 20 == 0) {
                formData.updateClient();
            }
        }
        if (form.mastery.hasKiDrain() && isInSurvival && player.field_70173_aa % 10 == 0) {
            double might = DBCUtils.calculateKiDrainMight(dbcData, player);
            double cost = might * (double)form.mastery.getKiDrain();
            if (JGConfigDBCFormMastery.FM_Enabled) {
                cost *= (double)form.mastery.calculateMulti("kiDrain", formData.getCurrentLevel());
            }
            int actualCost = (int)Math.floor(-cost / (double)form.mastery.kiDrainTimer * 10.0);
            dbcData.stats.restoreKiFlat(actualCost);
        }
        if (form.mastery.hasHeat() && player.field_70173_aa % 20 == 0) {
            float heatToAdd = form.mastery.calculateMulti("heat", formData.getCurrentLevel());
            float newHeat = ValueUtil.clamp((float)(dbcData.addonCurrentHeat + heatToAdd), (float)0.0f, (float)form.mastery.maxHeat);
            if (newHeat == (float)form.mastery.maxHeat) {
                int painTime = (int)((float)form.mastery.painTime * 60.0f / 5.0f * form.mastery.calculateMulti("pain", formData.getCurrentLevel()));
                dbcData.getRawCompound().func_74768_a("jrmcGyJ7dp", painTime);
                newHeat = 0.0f;
                TransformController.handleFormDescend(player, -10);
            }
            dbcData.getRawCompound().func_74776_a("addonCurrentHeat", newHeat);
        }
        if ((form.display.hairType.equals("ssj4") || form.display.hairType.equals("oozaru")) && DBCRace.isSaiyan(dbcData.Race) && !dbcData.hasTail()) {
            TransformController.handleFormDescend(player, -10);
        }
    }

    @SubscribeEvent
    public void NPCAscend(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityCustomNpc && Utility.isServer(event.entity)) {
            EntityCustomNpc npc = (EntityCustomNpc)event.entity;
            DBCDisplay display = ((INPCDisplay)npc.display).getDBCDisplay();
            if (!display.enabled) {
                return;
            }
            if (display.isTransforming && display.selectedForm != -1 && display.selectedForm != display.formID) {
                TransformController.npcAscend((EntityNPCInterface)npc, (Form)FormController.Instance.get(display.selectedForm));
            } else {
                TransformController.npcDecrementRage((EntityNPCInterface)npc, display);
            }
        }
    }

    @SubscribeEvent
    public void attackEvent(LivingAttackEvent event) {
        Entity attacker;
        Random rand;
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean isNPC = event.entity instanceof EntityNPCInterface;
        float dodgeChance = 0.0f;
        if (event.entity instanceof EntityPlayer || isNPC) {
            Form form = PlayerDataUtil.getForm(event.entity);
            if (form != null) {
                float formLevel = PlayerDataUtil.getFormLevel(event.entity);
                if (form.mastery.hasDodge()) {
                    dodgeChance = form.mastery.dodgeChance * form.mastery.calculateMulti("dodge", formLevel);
                }
            } else if (isNPC) {
                dodgeChance = PlayerDataUtil.getDBCData((EntityNPCInterface)event.entity).getDodgeChance();
            }
        }
        if (dodgeChance > 0.0f && dodgeChance >= (float)(rand = new Random()).nextInt(100) && Dodge.dodge(event.entity, attacker = event.source.func_76346_g())) {
            event.setCanceled(true);
        }
    }
}

