/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import kamkeel.npcdbc.client.gui.GuiModelDBC;
import kamkeel.npcdbc.data.npc.DBCDisplay;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.data.ModelData;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.opengl.GL11;

public class GuiDBCDisplayColor
extends SubGuiInterface
implements ITextfieldListener,
ISliderListener {
    private GuiModelDBC parent;
    private ModelData modelData;
    private static final ResourceLocation color = new ResourceLocation("customnpcs:textures/gui/color.png");
    private int colorX;
    private int colorY;
    private GuiNpcTextField textfield;
    private final DBCDisplay data;
    private int type = 0;
    public int selectedColor = -1;
    public float defaultAlpha = -1.0f;
    public float selectedAlpha = -1.0f;
    public GuiNpcSlider alphaSlider;
    public int buttonID;
    public int xOffset;
    public int yOffset;
    public MutableInt col;

    public GuiDBCDisplayColor(GuiModelDBC parent, ModelData modelData, DBCDisplay data, EntityCustomNpc npc, int type, int buttonID) {
        this.parent = parent;
        this.modelData = modelData;
        this.data = data;
        this.ySize = 200;
        this.xOffset = 40;
        this.type = type;
        this.buttonID = buttonID;
        this.drawDefaultBackground = false;
        this.closeOnEsc = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.colorX = this.guiLeft + this.xOffset + 4;
        this.colorY = this.guiTop + this.yOffset + 50;
        if (this.defaultAlpha != -1.0f) {
            this.selectedAlpha = this.defaultAlpha;
            this.alphaSlider = new GuiNpcSlider((GuiScreen)this, 1, this.colorX - 1, this.colorY + 120, this.selectedAlpha);
            this.addSlider(this.alphaSlider);
            this.alphaSlider.field_146120_f = 118;
        }
        int color = this.selectedColor = this.getColor();
        this.textfield = new GuiNpcTextField(0, (GuiScreen)this, this.guiLeft + this.xOffset + 25, this.guiTop + this.yOffset + 20, 70, 20, this.getColor(color));
        this.addTextField(this.textfield);
        this.textfield.func_146193_g(color);
        this.addButton(new GuiNpcButton(66, this.guiLeft + this.ySize - 25, this.guiTop + 5, 20, 20, "X"));
    }

    public GuiDBCDisplayColor setColor(MutableInt col) {
        this.col = col;
        return this;
    }

    public GuiDBCDisplayColor hasAlphaSlider(float defaultAlpha) {
        this.defaultAlpha = defaultAlpha;
        return this;
    }

    public void func_73869_a(char c, int i) {
        String prev = this.textfield.func_146179_b();
        super.func_73869_a(c, i);
        String newText = this.textfield.func_146179_b();
        if (!newText.equals(prev)) {
            try {
                int color = Integer.parseInt(this.textfield.func_146179_b(), 16);
                this.setColor(color);
            }
            catch (NumberFormatException var6) {
                this.textfield.func_146180_a(prev);
            }
        }
    }

    public int getColor() {
        int color = -1;
        if (this.type == 0) {
            color = this.data.bodyCM;
        } else if (this.type == 1) {
            color = this.data.bodyC1;
        } else if (this.type == 2) {
            color = this.data.bodyC2;
        } else if (this.type == 3) {
            color = this.data.bodyC3;
        } else if (this.type == 4) {
            color = this.data.hairColor;
        } else if (this.type == 5) {
            color = this.data.eyeColor;
        } else if (this.type == 6) {
            color = this.data.furColor;
        } else if (this.type == 7) {
            color = this.data.kiWeaponLeft.color.color;
        } else if (this.type == 8) {
            color = this.data.kiWeaponRight.color.color;
        }
        return color;
    }

    public void setColor(int color) {
        switch (this.type) {
            case 0: {
                this.data.bodyCM = color;
                break;
            }
            case 1: {
                this.data.bodyC1 = color;
                break;
            }
            case 2: {
                this.data.bodyC2 = color;
                break;
            }
            case 3: {
                this.data.bodyC3 = color;
                break;
            }
            case 4: {
                this.data.hairColor = color;
                break;
            }
            case 5: {
                this.data.eyeColor = color;
                break;
            }
            case 6: {
                this.data.furColor = color;
                break;
            }
            case 7: {
                this.data.kiWeaponLeft.color.color = color;
                break;
            }
            case 8: {
                this.data.kiWeaponRight.color.color = color;
            }
        }
        this.textfield.func_146193_g(color);
        this.textfield.func_146193_g(color);
        this.textfield.func_146180_a(this.getColor(color));
        this.selectedColor = color;
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn instanceof GuiNpcButton && ((GuiNpcButton)btn).field_146127_k == 66) {
            this.close();
        }
    }

    public void close() {
        super.close();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_73733_a(this.guiLeft, this.guiTop, this.guiLeft + this.xSize, this.guiTop + this.ySize, -250605552, -250605552);
        super.func_73863_a(par1, par2, par3);
        this.field_146297_k.func_110434_K().func_110577_a(color);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.selectedAlpha > -1.0f ? this.selectedAlpha : 1.0f));
        this.func_73729_b(this.colorX, this.colorY, 0, 0, 120, 120);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        if (i >= this.colorX && i <= this.colorX + 120 && j >= this.colorY && j <= this.colorY + 120) {
            InputStream stream = null;
            try {
                IResource resource = this.field_146297_k.func_110442_L().func_110536_a(color);
                stream = resource.func_110527_b();
                BufferedImage bufferedimage = ImageIO.read(stream);
                int color = bufferedimage.getRGB((i - this.guiLeft - this.xOffset - 4) * 4, (j - this.guiTop - this.yOffset - 50) * 4) & 0xFFFFFF;
                if (color != 0) {
                    this.setColor(color);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void unFocused(GuiNpcTextField textfield) {
        int color = -1;
        try {
            color = Integer.parseInt(textfield.func_146179_b(), 16);
        }
        catch (NumberFormatException var4) {
            color = -1;
        }
        this.setColor(color);
    }

    public String getColor(int input) {
        String str = Integer.toHexString(input);
        while (str.length() < 6) {
            str = "0" + str;
        }
        return str;
    }

    public void mouseDragged(GuiNpcSlider slider) {
        int percent = (int)(slider.sliderValue * 255.0f);
        slider.setString(percent + "");
        if (slider.field_146127_k == 1) {
            this.selectedAlpha = slider.sliderValue;
        }
        if (this.type == 7) {
            this.data.kiWeaponLeft.color.alpha = this.selectedAlpha;
        } else if (this.type == 8) {
            this.data.kiWeaponRight.color.alpha = this.selectedAlpha;
        }
    }

    public void mousePressed(GuiNpcSlider slider) {
    }

    public void mouseReleased(GuiNpcSlider slider) {
    }
}

