/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.constants.enums;

import java.util.ArrayList;
import java.util.List;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes3D;
import kamkeel.npcdbc.data.IAuraData;

public enum EnumAuraTypes2D {
    None("none"),
    Default("default"),
    Base("base"),
    SaiyanGod("ssgod"),
    SaiyanBlue("ssb"),
    SaiyanBlueEvo("shinka"),
    SaiyanRose("ssrose"),
    SaiyanRoseEvo("ssroseevo"),
    UltimateArco("ultimate"),
    UI("ui"),
    MasteredUI("mui"),
    GoD("godofdestruction"),
    GoDToppo("godofdestructiontoppo"),
    Jiren("jiren"),
    KettleMode("kettle");

    public final String name;

    private EnumAuraTypes2D(String name) {
        this.name = name;
    }

    public static EnumAuraTypes2D getEnumFromName(String name) {
        for (EnumAuraTypes2D auraType : EnumAuraTypes2D.values()) {
            if (!auraType.name.equalsIgnoreCase(name)) continue;
            return auraType;
        }
        return null;
    }

    public static List<String> getAllNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (EnumAuraTypes2D auraType : EnumAuraTypes2D.values()) {
            names.add(auraType.name);
        }
        return names;
    }

    public static EnumAuraTypes2D getType(IAuraData data) {
        byte race = data.getRace();
        byte state = data.getState();
        boolean divine = data.isForm(26);
        boolean ui = data.isForm(41);
        boolean god = data.isForm(24);
        if (ui) {
            return UI;
        }
        if (god) {
            return GoD;
        }
        if (DBCForm.isGod(race, state)) {
            return SaiyanGod;
        }
        if (race == 1 || race == 2) {
            if (state == 10) {
                if (divine) {
                    return SaiyanRose;
                }
                return SaiyanBlue;
            }
            if (state == 15) {
                if (divine) {
                    return SaiyanRoseEvo;
                }
                return SaiyanBlueEvo;
            }
        }
        return Base;
    }

    public static EnumAuraTypes2D getFrom3D(EnumAuraTypes3D type) {
        if (type == EnumAuraTypes3D.Base) {
            return Default;
        }
        if (type == EnumAuraTypes3D.SaiyanGod) {
            return SaiyanGod;
        }
        if (type == EnumAuraTypes3D.SaiyanBlue) {
            return SaiyanBlue;
        }
        if (type == EnumAuraTypes3D.SaiyanBlueEvo) {
            return SaiyanBlueEvo;
        }
        if (type == EnumAuraTypes3D.SaiyanRose) {
            return SaiyanRose;
        }
        if (type == EnumAuraTypes3D.SaiyanRoseEvo) {
            return SaiyanRoseEvo;
        }
        if (type == EnumAuraTypes3D.UI) {
            return UI;
        }
        if (type == EnumAuraTypes3D.GoD) {
            return GoD;
        }
        if (type == EnumAuraTypes3D.UltimateArco) {
            return UltimateArco;
        }
        return None;
    }

    public static int getParticleWidth(IAuraData data) {
        byte race = data.getRace();
        byte state = data.getState();
        if (race == 1 || race == 2) {
            if (state > 0 && state < 5) {
                return 7;
            }
            if (state == 5) {
                return 10;
            }
            if (state == 6) {
                return 15;
            }
            if (state == 14) {
                return 20;
            }
            if (state == 15) {
                return 5;
            }
            if (state == 10) {
                return 5;
            }
            if (state == 15) {
                return 5;
            }
        }
        return 5;
    }

    public String getName() {
        return this.name;
    }
}

