/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.UUID;
import kamkeel.npcdbc.config.ConfigCapsules;
import kamkeel.npcdbc.constants.enums.EnumHealthCapsules;
import kamkeel.npcdbc.constants.enums.EnumKiCapsules;
import kamkeel.npcdbc.constants.enums.EnumMiscCapsules;
import kamkeel.npcdbc.constants.enums.EnumRegenCapsules;
import kamkeel.npcdbc.constants.enums.EnumStaminaCapsules;

public class CapsuleController {
    public static CapsuleController Instance = new CapsuleController();
    public HashMap<UUID, HashMap<Integer, Long>> miscCapsuleCooldown = new HashMap();
    public HashMap<UUID, Long> lastUsedKiCapsule = new HashMap();
    public HashMap<UUID, Long> lastUsedHealthCapsule = new HashMap();
    public HashMap<UUID, Long> lastUsedStaminaCapsule = new HashMap();
    public HashMap<UUID, Long> lastUsedRegenCapsule = new HashMap();
    public HashMap<UUID, HashMap<Integer, Long>> lastIndividualKiCapsule = new HashMap();
    public HashMap<UUID, HashMap<Integer, Long>> lastIndividualHealthCapsule = new HashMap();
    public HashMap<UUID, HashMap<Integer, Long>> lastIndividualStaminaCapsule = new HashMap();
    public HashMap<UUID, HashMap<Integer, Long>> lastIndividualRegenCapsule = new HashMap();
    public HashMap<UUID, HashMap<Integer, Long>> lastRegenTypeCapsule = new HashMap();
    public HashMap<Integer, HashMap<Integer, Integer>> capsuleStrength = new HashMap();
    public HashMap<Integer, HashMap<Integer, Integer>> capsuleCooldowns = new HashMap();
    public HashMap<Integer, HashMap<Integer, Integer>> capsuleEffectTimes = new HashMap();

    public static void setMiscCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            if (type < 0 || type > EnumMiscCapsules.count()) {
                type = 0;
            }
            EnumMiscCapsules miscCapsules = EnumMiscCapsules.values()[type];
            long freedomTime = System.currentTimeMillis() + (long)miscCapsules.getCooldown() * 1000L;
            if (!CapsuleController.Instance.miscCapsuleCooldown.containsKey(playerUUID)) {
                CapsuleController.Instance.miscCapsuleCooldown.put(playerUUID, new HashMap());
            }
            HashMap<Integer, Long> tierTime = CapsuleController.Instance.miscCapsuleCooldown.get(playerUUID);
            tierTime.put(type, freedomTime);
            CapsuleController.Instance.miscCapsuleCooldown.put(playerUUID, tierTime);
        }
    }

    public static long canUseMiscCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            HashMap<Integer, Long> tierTime;
            if (type < 0 || type > EnumMiscCapsules.count()) {
                type = 0;
            }
            long currentTime = System.currentTimeMillis();
            long freedomTime = 0L;
            if (!CapsuleController.Instance.miscCapsuleCooldown.containsKey(playerUUID)) {
                CapsuleController.Instance.miscCapsuleCooldown.put(playerUUID, new HashMap());
            }
            if ((tierTime = CapsuleController.Instance.miscCapsuleCooldown.get(playerUUID)).containsKey(type)) {
                freedomTime = tierTime.get(type);
            }
            long remainingTimeMillis = freedomTime - currentTime;
            return (remainingTimeMillis + 999L) / 1000L;
        }
        return 0L;
    }

    public static void setKiCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            if (type < 0 || type > EnumKiCapsules.count()) {
                type = 0;
            }
            EnumKiCapsules kiCapsules = EnumKiCapsules.values()[type];
            long freedomTime = System.currentTimeMillis() + (long)kiCapsules.getCooldown() * 1000L;
            if (ConfigCapsules.KiCapsuleCooldownType == 0) {
                CapsuleController.Instance.lastUsedKiCapsule.put(playerUUID, freedomTime);
            } else {
                if (!CapsuleController.Instance.lastIndividualKiCapsule.containsKey(playerUUID)) {
                    CapsuleController.Instance.lastIndividualKiCapsule.put(playerUUID, new HashMap());
                }
                HashMap<Integer, Long> tierTime = CapsuleController.Instance.lastIndividualKiCapsule.get(playerUUID);
                tierTime.put(type, freedomTime);
                CapsuleController.Instance.lastIndividualKiCapsule.put(playerUUID, tierTime);
            }
        }
    }

    public static long canUseKiCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            HashMap<Integer, Long> tierTime;
            if (type < 0 || type > EnumKiCapsules.count()) {
                type = 0;
            }
            long currentTime = System.currentTimeMillis();
            long freedomTime = 0L;
            if (ConfigCapsules.KiCapsuleCooldownType == 0) {
                if (CapsuleController.Instance.lastUsedKiCapsule.containsKey(playerUUID)) {
                    freedomTime = CapsuleController.Instance.lastUsedKiCapsule.get(playerUUID);
                }
                long remainingTimeMillis = freedomTime - currentTime;
                return (remainingTimeMillis + 999L) / 1000L;
            }
            if (!CapsuleController.Instance.lastIndividualKiCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastIndividualKiCapsule.put(playerUUID, new HashMap());
            }
            if ((tierTime = CapsuleController.Instance.lastIndividualKiCapsule.get(playerUUID)).containsKey(type)) {
                freedomTime = tierTime.get(type);
            }
            long remainingTimeMillis = freedomTime - currentTime;
            return (remainingTimeMillis + 999L) / 1000L;
        }
        return 0L;
    }

    public static void setHealthCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            if (type < 0 || type > EnumHealthCapsules.count()) {
                type = 0;
            }
            EnumHealthCapsules kiCapsules = EnumHealthCapsules.values()[type];
            long freedomTime = System.currentTimeMillis() + (long)kiCapsules.getCooldown() * 1000L;
            if (ConfigCapsules.HealthCapsuleCooldownType == 0) {
                CapsuleController.Instance.lastUsedHealthCapsule.put(playerUUID, freedomTime);
            } else {
                if (!CapsuleController.Instance.lastIndividualHealthCapsule.containsKey(playerUUID)) {
                    CapsuleController.Instance.lastIndividualHealthCapsule.put(playerUUID, new HashMap());
                }
                HashMap<Integer, Long> tierTime = CapsuleController.Instance.lastIndividualHealthCapsule.get(playerUUID);
                tierTime.put(type, freedomTime);
                CapsuleController.Instance.lastIndividualHealthCapsule.put(playerUUID, tierTime);
            }
        }
    }

    public static long canUseHealthCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            HashMap<Integer, Long> tierTime;
            if (type < 0 || type > EnumHealthCapsules.count()) {
                type = 0;
            }
            long currentTime = System.currentTimeMillis();
            long freedomTime = 0L;
            if (ConfigCapsules.HealthCapsuleCooldownType == 0) {
                if (CapsuleController.Instance.lastUsedHealthCapsule.containsKey(playerUUID)) {
                    freedomTime = CapsuleController.Instance.lastUsedHealthCapsule.get(playerUUID);
                }
                long remainingTimeMillis = freedomTime - currentTime;
                return (remainingTimeMillis + 999L) / 1000L;
            }
            if (!CapsuleController.Instance.lastIndividualHealthCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastIndividualHealthCapsule.put(playerUUID, new HashMap());
            }
            if ((tierTime = CapsuleController.Instance.lastIndividualHealthCapsule.get(playerUUID)).containsKey(type)) {
                freedomTime = tierTime.get(type);
            }
            long remainingTimeMillis = freedomTime - currentTime;
            return (remainingTimeMillis + 999L) / 1000L;
        }
        return 0L;
    }

    public static void setStaminaCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            if (type < 0 || type > EnumStaminaCapsules.count()) {
                type = 0;
            }
            EnumStaminaCapsules kiCapsules = EnumStaminaCapsules.values()[type];
            long freedomTime = System.currentTimeMillis() + (long)kiCapsules.getCooldown() * 1000L;
            if (ConfigCapsules.StaminaCapsuleCooldownType == 0) {
                CapsuleController.Instance.lastUsedStaminaCapsule.put(playerUUID, freedomTime);
            } else {
                if (!CapsuleController.Instance.lastIndividualStaminaCapsule.containsKey(playerUUID)) {
                    CapsuleController.Instance.lastIndividualStaminaCapsule.put(playerUUID, new HashMap());
                }
                HashMap<Integer, Long> tierTime = CapsuleController.Instance.lastIndividualStaminaCapsule.get(playerUUID);
                tierTime.put(type, freedomTime);
                CapsuleController.Instance.lastIndividualStaminaCapsule.put(playerUUID, tierTime);
            }
        }
    }

    public static long canUseStaminaCapsule(UUID playerUUID, int type) {
        if (ConfigCapsules.EnableCapsuleCooldowns) {
            HashMap<Integer, Long> tierTime;
            if (type < 0 || type > EnumStaminaCapsules.count()) {
                type = 0;
            }
            long currentTime = System.currentTimeMillis();
            long freedomTime = 0L;
            if (ConfigCapsules.StaminaCapsuleCooldownType == 0) {
                if (CapsuleController.Instance.lastUsedStaminaCapsule.containsKey(playerUUID)) {
                    freedomTime = CapsuleController.Instance.lastUsedStaminaCapsule.get(playerUUID);
                }
                long remainingTimeMillis = freedomTime - currentTime;
                return (remainingTimeMillis + 999L) / 1000L;
            }
            if (!CapsuleController.Instance.lastIndividualStaminaCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastIndividualStaminaCapsule.put(playerUUID, new HashMap());
            }
            if ((tierTime = CapsuleController.Instance.lastIndividualStaminaCapsule.get(playerUUID)).containsKey(type)) {
                freedomTime = tierTime.get(type);
            }
            long remainingTimeMillis = freedomTime - currentTime;
            return (remainingTimeMillis + 999L) / 1000L;
        }
        return 0L;
    }

    public static void setRegenCapsule(UUID playerUUID, int type) {
        if (!ConfigCapsules.EnableCapsuleCooldowns) {
            return;
        }
        if (type < 0 || type >= EnumRegenCapsules.count()) {
            type = 0;
        }
        EnumRegenCapsules regenCapsules = EnumRegenCapsules.values()[type];
        long freedomTime = System.currentTimeMillis() + (long)regenCapsules.getCooldown() * 1000L;
        if (ConfigCapsules.RegenCapsuleCooldownType == 0) {
            CapsuleController.Instance.lastUsedRegenCapsule.put(playerUUID, freedomTime);
        } else if (ConfigCapsules.RegenCapsuleCooldownType == 1) {
            if (!CapsuleController.Instance.lastIndividualRegenCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastIndividualRegenCapsule.put(playerUUID, new HashMap());
            }
            HashMap<Integer, Long> tierTime = CapsuleController.Instance.lastIndividualRegenCapsule.get(playerUUID);
            tierTime.put(type, freedomTime);
            CapsuleController.Instance.lastIndividualRegenCapsule.put(playerUUID, tierTime);
        } else if (ConfigCapsules.RegenCapsuleCooldownType == 2) {
            if (!CapsuleController.Instance.lastRegenTypeCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastRegenTypeCapsule.put(playerUUID, new HashMap());
            }
            HashMap<Integer, Long> typeTime = CapsuleController.Instance.lastRegenTypeCapsule.get(playerUUID);
            typeTime.put(regenCapsules.getStatusEffectId(), freedomTime);
            CapsuleController.Instance.lastRegenTypeCapsule.put(playerUUID, typeTime);
        }
    }

    public static long canUseRegenCapsule(UUID playerUUID, int type) {
        if (!ConfigCapsules.EnableCapsuleCooldowns) {
            return 0L;
        }
        if (type < 0 || type >= EnumRegenCapsules.count()) {
            type = 0;
        }
        EnumRegenCapsules regenCapsules = EnumRegenCapsules.values()[type];
        long currentTime = System.currentTimeMillis();
        long freedomTime = 0L;
        if (ConfigCapsules.RegenCapsuleCooldownType == 0) {
            if (CapsuleController.Instance.lastUsedRegenCapsule.containsKey(playerUUID)) {
                freedomTime = CapsuleController.Instance.lastUsedRegenCapsule.get(playerUUID);
            }
        } else if (ConfigCapsules.RegenCapsuleCooldownType == 1) {
            HashMap<Integer, Long> tierTime;
            if (!CapsuleController.Instance.lastIndividualRegenCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastIndividualRegenCapsule.put(playerUUID, new HashMap());
            }
            if ((tierTime = CapsuleController.Instance.lastIndividualRegenCapsule.get(playerUUID)).containsKey(type)) {
                freedomTime = tierTime.get(type);
            }
        } else if (ConfigCapsules.RegenCapsuleCooldownType == 2) {
            HashMap<Integer, Long> typeTime;
            if (!CapsuleController.Instance.lastRegenTypeCapsule.containsKey(playerUUID)) {
                CapsuleController.Instance.lastRegenTypeCapsule.put(playerUUID, new HashMap());
            }
            if ((typeTime = CapsuleController.Instance.lastRegenTypeCapsule.get(playerUUID)).containsKey(regenCapsules.getStatusEffectId())) {
                freedomTime = typeTime.get(regenCapsules.getStatusEffectId());
            }
        }
        long remainingTimeMillis = freedomTime - currentTime;
        return (remainingTimeMillis + 999L) / 1000L;
    }

    public void load() {
        this.lastUsedKiCapsule.clear();
        this.lastIndividualKiCapsule.clear();
        this.lastUsedHealthCapsule.clear();
        this.lastIndividualHealthCapsule.clear();
        this.lastUsedStaminaCapsule.clear();
        this.lastIndividualStaminaCapsule.clear();
        this.lastIndividualRegenCapsule.clear();
        this.miscCapsuleCooldown.clear();
        this.capsuleStrength.clear();
        this.capsuleCooldowns.clear();
        this.capsuleEffectTimes.clear();
        this.capsuleStrength.put(1, new HashMap());
        this.capsuleStrength.put(2, new HashMap());
        this.capsuleStrength.put(3, new HashMap());
        this.capsuleStrength.put(4, new HashMap());
        this.capsuleCooldowns.put(0, new HashMap());
        this.capsuleCooldowns.put(1, new HashMap());
        this.capsuleCooldowns.put(2, new HashMap());
        this.capsuleCooldowns.put(3, new HashMap());
        this.capsuleCooldowns.put(4, new HashMap());
        this.capsuleEffectTimes.put(4, new HashMap());
        HashMap<Integer, Integer> miscCooldown = this.capsuleCooldowns.get(0);
        HashMap<Integer, Integer> hpCooldown = this.capsuleCooldowns.get(1);
        HashMap<Integer, Integer> kiCooldown = this.capsuleCooldowns.get(2);
        HashMap<Integer, Integer> staminaCooldown = this.capsuleCooldowns.get(3);
        HashMap<Integer, Integer> regenCooldown = this.capsuleCooldowns.get(4);
        HashMap<Integer, Integer> hpStrength = this.capsuleStrength.get(1);
        HashMap<Integer, Integer> kiStrength = this.capsuleStrength.get(2);
        HashMap<Integer, Integer> staminaStrength = this.capsuleStrength.get(3);
        HashMap<Integer, Integer> regenStrength = this.capsuleStrength.get(4);
        HashMap<Integer, Integer> regenEffectTime = this.capsuleEffectTimes.get(4);
        for (EnumMiscCapsules enumMiscCapsules : EnumMiscCapsules.values()) {
            miscCooldown.put(enumMiscCapsules.getMeta(), enumMiscCapsules.getCooldown());
        }
        for (Enum enum_ : EnumHealthCapsules.values()) {
            hpCooldown.put(((EnumHealthCapsules)enum_).getMeta(), ((EnumHealthCapsules)enum_).getCooldown());
            hpStrength.put(((EnumHealthCapsules)enum_).getMeta(), ((EnumHealthCapsules)enum_).getStrength());
        }
        for (Enum enum_ : EnumKiCapsules.values()) {
            kiCooldown.put(((EnumKiCapsules)enum_).getMeta(), ((EnumKiCapsules)enum_).getCooldown());
            kiStrength.put(((EnumKiCapsules)enum_).getMeta(), ((EnumKiCapsules)enum_).getStrength());
        }
        for (Enum enum_ : EnumStaminaCapsules.values()) {
            staminaCooldown.put(((EnumStaminaCapsules)enum_).getMeta(), ((EnumStaminaCapsules)enum_).getCooldown());
            staminaStrength.put(((EnumStaminaCapsules)enum_).getMeta(), ((EnumStaminaCapsules)enum_).getStrength());
        }
        for (Enum enum_ : EnumRegenCapsules.values()) {
            regenCooldown.put(((EnumRegenCapsules)enum_).getMeta(), ((EnumRegenCapsules)enum_).getCooldown());
            regenStrength.put(((EnumRegenCapsules)enum_).getMeta(), ((EnumRegenCapsules)enum_).getStrength());
            regenEffectTime.put(((EnumRegenCapsules)enum_).getMeta(), ((EnumRegenCapsules)enum_).getEffectTime());
        }
    }

    public static byte[] serializeHashMap(HashMap<Integer, HashMap<Integer, Integer>> map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(map);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static HashMap<Integer, HashMap<Integer, Integer>> deserializeHashMap(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return (HashMap)objectInputStream.readObject();
    }

    public static CapsuleController getInstance() {
        return Instance;
    }
}

