/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data;

import JinRyuu.JRMCore.JRMCoreH;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kamkeel.npcdbc.config.ConfigDBCGeneral;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.controllers.DBCEffectController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.controllers.TransformController;
import kamkeel.npcdbc.data.FormWheelData;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormDisplay;
import kamkeel.npcdbc.data.form.FormMastery;
import kamkeel.npcdbc.data.form.FormMasteryLinkData;
import kamkeel.npcdbc.mixins.late.IPlayerDBCInfo;
import kamkeel.npcdbc.util.NBTHelper;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.util.ValueUtil;

public class PlayerDBCInfo {
    public PlayerData parent;
    public int currentForm = -1;
    public int selectedForm = -1;
    public int selectedDBCForm = -1;
    public int tempSelectedDBCForm = -1;
    public int currentAura = -1;
    public int selectedAura = -1;
    public HashSet<Integer> unlockedAuras = new HashSet();
    public HashSet<Integer> unlockedForms = new HashSet();
    public HashMap<Integer, Float> formLevels = new HashMap();
    public HashMap<Integer, Integer> formTimers = new HashMap();
    public HashMap<Integer, FormDisplay.BodyColor> configuredFormColors = new HashMap();
    public FormWheelData[] formWheel = new FormWheelData[6];

    public PlayerDBCInfo(PlayerData parent) {
        this.parent = parent;
        for (int i = 0; i < this.formWheel.length; ++i) {
            this.formWheel[i] = new FormWheelData(i);
        }
    }

    public void addForm(Form form) {
        if (form == null) {
            return;
        }
        this.unlockedForms.add(form.id);
        if (!this.formLevels.containsKey(form.id)) {
            this.formLevels.put(form.id, Float.valueOf(0.0f));
        }
    }

    public void addFormWheel(int wheelSlot, FormWheelData data) {
        if (wheelSlot > 5) {
            return;
        }
        this.formWheel[wheelSlot].readFromNBT(data.writeToNBT(new NBTTagCompound()));
    }

    public boolean hasFormUnlocked(int id) {
        return this.unlockedForms.contains(id);
    }

    public boolean removeForm(Form form) {
        return this.removeForm(form, ConfigDBCGeneral.FORM_MASTERIES_CLEAR_ON_REMOVE);
    }

    public boolean removeForm(int id) {
        return this.removeForm(id, ConfigDBCGeneral.FORM_MASTERIES_CLEAR_ON_REMOVE);
    }

    public boolean removeForm(Form form, boolean removesMastery) {
        if (form == null) {
            return false;
        }
        if (removesMastery) {
            this.formLevels.remove(form.id);
        }
        return this.unlockedForms.remove(form.id);
    }

    public boolean removeForm(int id, boolean removesMastery) {
        if (removesMastery) {
            this.formLevels.remove(id);
        }
        return this.unlockedForms.remove(id);
    }

    public void removeFormWheel(int wheelSlot) {
        if (wheelSlot <= 5 && wheelSlot >= 0) {
            this.formWheel[wheelSlot].reset();
        }
    }

    public Form getForm(int id) {
        if (this.unlockedForms.contains(id)) {
            return (Form)FormController.getInstance().get(id);
        }
        return null;
    }

    public boolean hasSelectedForm() {
        return this.selectedForm > -1 && this.getSelectedForm() != null;
    }

    public boolean hasForm(Form form) {
        if (form == null) {
            return false;
        }
        return this.unlockedForms.contains(form.id);
    }

    public boolean isInCustomForm() {
        return this.currentForm > -1 && this.getCurrentForm() != null;
    }

    public String getFormColorCode(Form f) {
        if (f != null && f.getMenuName().contains("\u00a7")) {
            String s = f.getMenuName();
            int i = s.indexOf("\u00a7");
            return s.substring(i, 2);
        }
        return "";
    }

    public String getColoredName(Form f) {
        if (f == null) {
            return "";
        }
        return this.getFormColorCode(f) + f.getName();
    }

    public boolean isInForm(String formName) {
        Form form = this.getCurrentForm();
        if (form == null) {
            return false;
        }
        return form.getName().equals(formName);
    }

    public boolean isInForm(int formID) {
        return formID == this.currentForm;
    }

    public Form getCurrentForm() {
        if (this.currentForm > 0) {
            return (Form)FormController.Instance.get(this.currentForm);
        }
        return null;
    }

    public Form getUnlockedForm(int id) {
        if (this.unlockedForms.contains(id)) {
            return (Form)FormController.Instance.get(id);
        }
        return null;
    }

    public Form getSelectedForm() {
        return (Form)FormController.Instance.get(this.selectedForm);
    }

    public void clearAllForms() {
        this.resetFormData(true, true);
    }

    public void resetFormData(boolean removeForms, boolean removeMasteries) {
        TransformController.handleFormDescend(this.parent.player, -10);
        this.currentForm = -1;
        this.selectedForm = -1;
        if (removeForms) {
            this.unlockedForms.clear();
        }
        if (removeMasteries) {
            this.formLevels.clear();
        }
        for (FormWheelData formWheelData : this.formWheel) {
            formWheelData.reset();
        }
    }

    public void updateCurrentFormMastery(String gainType) {
        this.updateFormMastery(this.currentForm, gainType);
    }

    public void updateFormMastery(int formID, String gainType) {
        Form f = FormController.getInstance().customForms.get(formID);
        if (f == null || !this.isInCustomForm() || this.parent.player == null) {
            return;
        }
        DBCData data = DBCData.get(this.parent.player);
        if (data == null) {
            return;
        }
        FormMastery fm = (FormMastery)f.getMastery();
        if (!this.formLevels.containsKey(f.id)) {
            this.formLevels.put(f.id, Float.valueOf(0.0f));
        }
        float playerLevel = this.formLevels.get(f.id).floatValue();
        float fullGain = fm.calculateFullGain(gainType, playerLevel, data.MND);
        playerLevel = ValueUtil.clamp((float)(playerLevel + fullGain), (float)0.0f, (float)fm.maxLevel);
        this.formLevels.replace(f.id, Float.valueOf(playerLevel));
        this.updateClient();
    }

    public void addFormLevel(int formID, float amount) {
        Form form = FormController.getInstance().customForms.get(formID);
        if (form != null) {
            float current = this.formLevels.get(formID).floatValue();
            float updated = ValueUtil.clamp((float)(current + amount), (float)0.0f, (float)((FormMastery)form.getMastery()).maxLevel);
            this.formLevels.put(formID, Float.valueOf(updated));
            this.updateClient();
        }
    }

    public void setFormLevel(int formID, float amount) {
        this.setFormLevel(formID, amount, true);
    }

    public void setFormLevel(int formID, float amount, boolean updateClient) {
        Form form = FormController.getInstance().customForms.get(formID);
        if (form != null) {
            float updated = ValueUtil.clamp((float)amount, (float)0.0f, (float)((FormMastery)form.getMastery()).maxLevel);
            this.formLevels.put(formID, Float.valueOf(updated));
            if (updateClient) {
                this.updateClient();
            }
        }
    }

    public void removeFormMastery(int formID) {
        Form form = FormController.getInstance().customForms.get(formID);
        if (form != null) {
            this.formLevels.remove(formID);
            this.updateClient();
        }
    }

    public float getFormLevel(int formID) {
        return this.getFormLevel(formID, true);
    }

    public float getFormLevel(int formID, boolean checkFusion) {
        EntityPlayer fusedPlayer;
        if (formID == -1) {
            return 0.0f;
        }
        float mastery = this.formLevels.getOrDefault(formID, Float.valueOf(0.0f)).floatValue();
        if (!checkFusion || this.parent.player == null) {
            return mastery;
        }
        NBTTagCompound compound = this.parent.player.getEntityData().func_74775_l("PlayerPersisted");
        if (this.isFused(compound) && (fusedPlayer = this.getSpectatorEntity(compound)) != null) {
            float otherPlayerMastery = PlayerDataUtil.getDBCInfo((EntityPlayer)fusedPlayer).formLevels.getOrDefault(formID, Float.valueOf(0.0f)).floatValue();
            mastery += otherPlayerMastery;
        }
        return mastery;
    }

    public float getCurrentLevel() {
        return this.getFormLevel(this.currentForm);
    }

    public void addTimer(int formid, int timeInTicks) {
        if (!this.formTimers.containsKey(formid)) {
            this.formTimers.put(formid, timeInTicks);
        }
        this.formTimers.replace(formid, timeInTicks);
    }

    public void decrementTimer(int formid) {
        if (this.formTimers.containsKey(formid)) {
            int currentTime = this.formTimers.get(formid);
            if (currentTime > 0) {
                this.formTimers.replace(formid, currentTime - 1);
            } else if (currentTime == 0) {
                TransformController.handleFormDescend(this.parent.player, 0);
                this.formTimers.remove(formid);
            }
        }
    }

    public int getTimer(int formid) {
        if (this.formTimers.containsKey(formid)) {
            return this.formTimers.get(formid);
        }
        return -1;
    }

    public boolean hasTimer(int formid) {
        if (this.formTimers.containsKey(formid)) {
            return this.formTimers.get(formid) > -1;
        }
        return false;
    }

    public void addAura(Aura aura) {
        if (aura == null) {
            return;
        }
        this.unlockedAuras.add(aura.id);
    }

    public boolean hasAuraUnlocked(int id) {
        return this.unlockedAuras.contains(id);
    }

    public boolean removeAura(Aura aura) {
        if (aura == null) {
            return false;
        }
        return this.unlockedAuras.remove(aura.id);
    }

    public boolean removeAura(int id) {
        return this.unlockedAuras.remove(id);
    }

    public Aura getAura(int id) {
        if (this.unlockedAuras.contains(id)) {
            return (Aura)AuraController.getInstance().get(id);
        }
        return null;
    }

    public boolean hasSelectedAura() {
        return this.selectedAura > -1 && this.getSelectedAura() != null;
    }

    public boolean hasAura(Aura aura) {
        if (aura == null) {
            return false;
        }
        return this.unlockedAuras.contains(aura.id);
    }

    public boolean isInCustomAura() {
        return this.currentAura > -1 && this.getCurrentAura() != null;
    }

    public boolean isInAura(String AuraName) {
        Aura aura = this.getCurrentAura();
        if (aura == null) {
            return false;
        }
        return aura.getName().equals(AuraName);
    }

    public Aura getCurrentAura() {
        Form form = this.getCurrentForm();
        if (form != null && form.display.hasAura()) {
            return form.display.getAur();
        }
        if (this.currentAura > -1) {
            return (Aura)AuraController.Instance.get(this.currentAura);
        }
        return null;
    }

    public Aura getUnlockedAura(int id) {
        if (this.unlockedAuras.contains(id)) {
            return (Aura)AuraController.Instance.get(id);
        }
        return null;
    }

    public Aura getSelectedAura() {
        return (Aura)AuraController.Instance.get(this.selectedAura);
    }

    public void clearAllAuras() {
        this.unlockedAuras.clear();
        this.currentAura = -1;
        this.selectedAura = -1;
    }

    public void resetChar() {
        this.resetChar(ConfigDBCGeneral.FORMS_CLEAR_ON_RESET, ConfigDBCGeneral.FORM_MASTERIES_CLEAR_ON_RESET);
    }

    public void resetChar(boolean removeForms, boolean removeMasteries) {
        this.resetFormData(removeForms, removeMasteries);
        if (ConfigDBCGeneral.AURAS_CLEAR_ON_RESET) {
            this.clearAllAuras();
        }
        this.configuredFormColors.clear();
        DBCEffectController.getInstance().clearDBCEffects(this.parent.player);
        BonusController.getInstance().clearBonuses((Entity)this.parent.player);
        this.updateClient();
    }

    public void updateClient() {
        this.handleLinkedFormMastery();
        ((IPlayerDBCInfo)this.parent).updateDBCInfo();
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound dbcCompound = new NBTTagCompound();
        dbcCompound.func_74768_a("CurrentForm", this.currentForm);
        dbcCompound.func_74768_a("SelectedForm", this.selectedForm);
        dbcCompound.func_74768_a("SelectedDBCForm", this.selectedDBCForm);
        dbcCompound.func_74782_a("UnlockedForms", (NBTBase)NBTTags.nbtIntegerSet(this.unlockedForms));
        dbcCompound.func_74782_a("FormMastery", (NBTBase)NBTTags.nbtIntegerFloatMap(this.formLevels));
        dbcCompound.func_74782_a("FormTimers", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.formTimers));
        dbcCompound.func_74782_a("ConfigurableFormColors", (NBTBase)NBTHelper.nbtIntegerObjectMap(this.configuredFormColors, bodyColor -> bodyColor.writeToNBT(new NBTTagCompound()), (ignored, colors) -> !colors.isEmpty()));
        for (int i = 0; i < this.formWheel.length; ++i) {
            this.formWheel[i].writeToNBT(dbcCompound);
        }
        dbcCompound.func_74768_a("CurrentAura", this.currentAura);
        dbcCompound.func_74768_a("SelectedAura", this.selectedAura);
        dbcCompound.func_74782_a("UnlockedAuras", (NBTBase)NBTTags.nbtIntegerSet(this.unlockedAuras));
        this.saveBonuses(dbcCompound);
        compound.func_74782_a("DBCInfo", (NBTBase)dbcCompound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound dbcCompound = compound.func_74775_l("DBCInfo");
        this.currentForm = dbcCompound.func_74762_e("CurrentForm");
        this.selectedForm = dbcCompound.func_74764_b("SelectedForm") ? dbcCompound.func_74762_e("SelectedForm") : -1;
        this.selectedDBCForm = dbcCompound.func_74764_b("SelectedDBCForm") ? dbcCompound.func_74762_e("SelectedDBCForm") : -1;
        this.unlockedForms = NBTTags.getIntegerSet((NBTTagList)dbcCompound.func_150295_c("UnlockedForms", 10));
        this.formLevels = NBTTags.getIntegerFloatMap((NBTTagList)dbcCompound.func_150295_c("FormMastery", 10));
        this.formTimers = NBTTags.getIntegerIntegerMap((NBTTagList)dbcCompound.func_150295_c("FormTimers", 10));
        for (int i = 0; i < this.formWheel.length; ++i) {
            this.formWheel[i].readFromNBT(dbcCompound.func_74775_l("FormWheel" + i));
        }
        this.currentAura = dbcCompound.func_74762_e("CurrentAura");
        this.selectedAura = dbcCompound.func_74762_e("SelectedAura");
        this.unlockedAuras = NBTTags.getIntegerSet((NBTTagList)dbcCompound.func_150295_c("UnlockedAuras", 10));
        if (dbcCompound.func_74764_b("ConfigurableFormColors")) {
            this.configuredFormColors = NBTHelper.javaIntegerObjectMap(dbcCompound.func_150295_c("ConfigurableFormColors", 10), colorCompound -> {
                FormDisplay.BodyColor color = new FormDisplay.BodyColor();
                color.readFromNBT((NBTTagCompound)colorCompound);
                return color;
            }, (slot, color) -> FormController.getInstance().has((int)slot) && !color.isEmpty());
        }
        this.loadBonuses(dbcCompound);
    }

    private void loadBonuses(NBTTagCompound dbcCompound) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || this.parent.player == null) {
            return;
        }
        ConcurrentHashMap<String, PlayerBonus> currentBonuses = new ConcurrentHashMap<String, PlayerBonus>();
        if (dbcCompound.func_150297_b("addonBonus", 9)) {
            NBTTagList nbttaglist = dbcCompound.func_150295_c("addonBonus", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                PlayerBonus bonus = PlayerBonus.readBonusData(nbttagcompound1);
                currentBonuses.put(bonus.name, bonus);
            }
        }
        BonusController.getInstance().playerBonus.put(Utility.getUUID((Entity)this.parent.player), currentBonuses);
    }

    private void saveBonuses(NBTTagCompound dbcCompound) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT || this.parent.player == null) {
            return;
        }
        Map<String, PlayerBonus> test = BonusController.getInstance().getPlayerBonus(this.parent.player);
        if (test == null || test.isEmpty()) {
            return;
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (PlayerBonus bonus : test.values()) {
            nbttaglist.func_74742_a((NBTBase)bonus.writeBonusData(new NBTTagCompound()));
        }
        dbcCompound.func_74782_a("addonBonus", (NBTBase)nbttaglist);
    }

    private void handleLinkedFormMastery() {
        Form form = this.getCurrentForm();
        if (form == null) {
            return;
        }
        DBCData data = DBCData.get(this.parent.player);
        if (!form.mastery.masteryLink.hasLinkData(data.getRace())) {
            return;
        }
        FormMasteryLinkData.LinkData linkData = form.mastery.masteryLink.masteryLinks.get(data.Race);
        if (linkData.isCustomLink) {
            this.handleCustomLinking(data, form, linkData.formID);
        } else {
            this.handleDBCLinking(data, form, linkData.formID);
        }
    }

    private void handleCustomLinking(DBCData data, Form form, int formID) {
        Form otherForm = (Form)FormController.getInstance().get(formID);
        if (otherForm == null) {
            return;
        }
        float currentFormMastery = this.formLevels.getOrDefault(form.id, Float.valueOf(0.0f)).floatValue();
        float otherFormMastery = this.formLevels.getOrDefault(otherForm.id, Float.valueOf(0.0f)).floatValue();
        float highest = Math.max(currentFormMastery, otherFormMastery);
        this.setFormLevel(form.id, highest, false);
        this.setFormLevel(otherForm.id, highest, false);
    }

    private void handleDBCLinking(DBCData data, Form form, int dbcForm) {
        int jrmcFormID = DBCForm.getJRMCFormID(dbcForm, data.Race);
        if (jrmcFormID == -1) {
            return;
        }
        double currentDBCFormLevel = data.stats.getDBCMastery(jrmcFormID);
        float currentCustomMastery = this.formLevels.getOrDefault(form.id, Float.valueOf(0.0f)).floatValue();
        double highest = Math.max((double)currentCustomMastery, currentDBCFormLevel);
        data.stats.setDBCMastery(jrmcFormID, highest);
        this.setFormLevel(form.id, (float)highest, false);
    }

    private boolean isFused(NBTTagCompound compound) {
        String statusEffects = compound.func_74779_i("jrmcStatusEff");
        String fusionString = compound.func_74779_i("jrmcFuzion");
        if (JRMCoreH.StusEfcts((int)10, (String)statusEffects) || JRMCoreH.StusEfcts((int)11, (String)statusEffects)) {
            return true;
        }
        if (fusionString.contains(",")) {
            String[] fusionMembers = fusionString.split(",");
            return fusionMembers.length == 3;
        }
        return false;
    }

    private String getSpectatorName(NBTTagCompound compound) {
        String[] fusionMembers;
        String fusionString = compound.func_74779_i("jrmcFuzion");
        if (fusionString.contains(",") && (fusionMembers = fusionString.split(",")).length == 3) {
            return fusionMembers[1];
        }
        return "";
    }

    private boolean isFusionSpectator(NBTTagCompound compound) {
        String[] fusionMembers;
        String statusEffects = compound.func_74779_i("jrmcStatusEff");
        if (JRMCoreH.StusEfcts((int)11, (String)statusEffects)) {
            return true;
        }
        String fusionString = compound.func_74779_i("jrmcFuzion");
        if (fusionString.contains(",") && (fusionMembers = fusionString.split(",")).length == 3) {
            return fusionMembers[1].equalsIgnoreCase(this.parent.player.func_70005_c_());
        }
        return false;
    }

    private EntityPlayer getSpectatorEntity(NBTTagCompound compound) {
        String spectator;
        if (this.isFused(compound) && !this.isFusionSpectator(compound) && !(spectator = this.getSpectatorName(compound)).isEmpty()) {
            EntityPlayer specEntity = null;
            specEntity = this.parent.player.field_70170_p.field_72995_K ? this.parent.player.field_70170_p.func_72924_a(spectator) : NoppesUtilServer.getPlayerByName((String)spectator);
            return specEntity;
        }
        return null;
    }

    public void setFormColorConfig(Form form, FormDisplay.BodyColor colors) {
        if (colors.isEmpty()) {
            this.configuredFormColors.remove(form.id);
        } else {
            this.configuredFormColors.put(form.id, colors);
        }
    }
}

