/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.effects;

import java.util.HashMap;
import java.util.UUID;
import kamkeel.npcdbc.config.ConfigDBCGameplay;

public class DamageTracker {
    private final UUID playerId;
    private final HashMap<Long, Double> damageRecords;
    private long lastCleanTime;

    public DamageTracker(UUID playerId) {
        this.playerId = playerId;
        this.damageRecords = new HashMap();
        this.lastCleanTime = System.currentTimeMillis();
    }

    public void recordDamage(double damage) {
        long currentTime = System.currentTimeMillis();
        this.damageRecords.put(currentTime, damage);
    }

    public boolean checkForHumanSpirit(int maxHealth) {
        long currentTime = System.currentTimeMillis();
        this.cleanOldEntries(currentTime);
        double totalDamage = this.damageRecords.values().stream().mapToDouble(Double::doubleValue).sum();
        double damageThreshold = (double)(maxHealth * ConfigDBCGameplay.PercentDamageRequired) / 100.0;
        return totalDamage >= damageThreshold && currentTime - this.lastCleanTime <= (long)ConfigDBCGameplay.DamageRequiredSeconds * 1000L;
    }

    public void cleanOldEntries(long currentTime) {
        this.damageRecords.entrySet().removeIf(entry -> currentTime - (Long)entry.getKey() > (long)ConfigDBCGameplay.DamageRequiredSeconds * 1000L);
        this.lastCleanTime = currentTime;
    }
}

