/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public final class PingPacket
extends AbstractPacket {
    public static final String packetName = "NPC|Ping";
    private DBCData data;
    private NBTTagCompound clientData;

    public PingPacket() {
    }

    public PingPacket(DBCData dbcData, NBTTagCompound dataNeededOnClient) {
        this.data = dbcData;
        this.clientData = dataNeededOnClient;
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.PingPacket;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)this.data.player.func_70005_c_());
        ByteBufUtils.writeNBT((ByteBuf)out, (NBTTagCompound)this.data.saveFromNBT(new NBTTagCompound()));
        ByteBufUtils.writeNBT((ByteBuf)out, (NBTTagCompound)this.clientData);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        String playerName = ByteBufUtils.readUTF8String((ByteBuf)in);
        EntityPlayer sendingPlayer = Minecraft.func_71410_x().field_71441_e.func_72924_a(playerName);
        if (sendingPlayer != null) {
            DBCData dbcData = DBCData.get(sendingPlayer);
            dbcData.loadFromNBT(ByteBufUtils.readNBT((ByteBuf)in));
            dbcData.loadClientSideData(ByteBufUtils.readNBT((ByteBuf)in));
        }
    }
}

