/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormDisplay;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class SaveFormCustomization
extends AbstractPacket {
    public static final String packetName = "DBC|SaveFormCustomization";
    private int formID;
    private NBTTagCompound bodyColorsCompound;

    public SaveFormCustomization() {
    }

    public SaveFormCustomization(Form form, FormDisplay.BodyColor colors) {
        this.formID = form.id;
        this.bodyColorsCompound = colors.writeToNBT(new NBTTagCompound());
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.FormSaveCustiomization;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.formID);
        ByteBufUtils.writeNBT((ByteBuf)out, (NBTTagCompound)this.bodyColorsCompound);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        int formID = in.readInt();
        FormDisplay.BodyColor colors = new FormDisplay.BodyColor();
        colors.readFromNBT(ByteBufUtils.readNBT((ByteBuf)in));
        Form form = (Form)FormController.Instance.get(formID);
        if (form == null) {
            return;
        }
        DBCData dbcData = DBCData.get(player);
        PlayerDBCInfo dbcInfo = dbcData.getDBCInfo();
        if (form == dbcInfo.getCurrentForm() || dbcInfo.hasForm(form)) {
            dbcInfo.setFormColorConfig(form, colors);
        }
    }
}

