/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data.action;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import noppes.npcs.api.handler.data.IAction;
import noppes.npcs.scripted.ScriptedActionManager;

public class Action
implements IAction {
    protected final ScriptedActionManager manager;
    protected final String name;
    protected int startAfterTicks;
    protected int count;
    protected int duration;
    protected int maxDuration = -1;
    protected int updateEveryXTick = 5;
    protected Consumer<IAction> task;
    private boolean done;
    private final Map<String, Object> dataStore = new HashMap<String, Object>();

    public Action(ScriptedActionManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    public Action(ScriptedActionManager manager, Consumer<IAction> task) {
        this(manager, task.toString(), task);
    }

    public Action(ScriptedActionManager manager, String name, int maxDuration, int startAfterTicks, Consumer<IAction> task) {
        this.manager = manager;
        this.name = name;
        this.maxDuration = maxDuration;
        this.startAfterTicks = startAfterTicks;
        this.task = task;
    }

    public Action(ScriptedActionManager manager, String name, int startAfterTicks, Consumer<IAction> task) {
        this(manager, name, task);
        this.startAfterTicks = startAfterTicks;
    }

    public Action(ScriptedActionManager manager, String name, Consumer<IAction> task) {
        this(manager, name);
        this.task = task;
    }

    public Action(ScriptedActionManager manager, int startAfterTicks, Consumer<IAction> task) {
        this(manager, task);
        this.startAfterTicks = startAfterTicks;
    }

    @Override
    public IAction setTask(Consumer<IAction> task) {
        this.task = task;
        return this;
    }

    public void tick(int ticksExisted) {
        if (this.done) {
            return;
        }
        if (this.startAfterTicks > 0) {
            --this.startAfterTicks;
            return;
        }
        if (this.maxDuration != -1 && this.duration >= this.maxDuration) {
            this.markDone();
            return;
        }
        if (ticksExisted % this.updateEveryXTick == 0 && this.task != null) {
            try {
                this.task.accept(this);
                ++this.count;
            }
            catch (Throwable t) {
                System.err.println("Scripted action '" + this.name + "' threw an exception:");
                t.printStackTrace();
                this.markDone();
            }
        }
        ++this.duration;
    }

    @Override
    public ScriptedActionManager getManager() {
        return this.manager;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    public IAction setMaxDuration(int x) {
        this.maxDuration = x;
        return this;
    }

    @Override
    public void markDone() {
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Object getData(String key) {
        return this.dataStore.get(key);
    }

    @Override
    public IAction setData(String key, Object v) {
        this.dataStore.put(key, v);
        return this;
    }

    @Override
    public IAction removeData(String key) {
        this.dataStore.remove(key);
        return this;
    }

    @Override
    public boolean hasData(String key) {
        return this.dataStore.containsKey(key);
    }

    @Override
    public int getUpdateEveryXTick() {
        return this.updateEveryXTick;
    }

    @Override
    public IAction setUpdateEveryXTick(int x) {
        this.updateEveryXTick = x;
        return this;
    }

    @Override
    public int getStartAfterTicks() {
        return this.startAfterTicks;
    }

    @Override
    public IAction pauseFor(int ticks) {
        this.startAfterTicks = ticks;
        return this;
    }

    @Override
    public IAction getNext() {
        boolean seenMe = false;
        for (IAction a : this.manager.getActionQueue()) {
            if (seenMe) {
                return a;
            }
            if (a != this) continue;
            seenMe = true;
        }
        return null;
    }

    @Override
    public IAction getPrevious() {
        IAction prev = null;
        for (IAction a : this.manager.getActionQueue()) {
            if (a == this) {
                return prev;
            }
            prev = a;
        }
        return null;
    }

    @Override
    public IAction after(IAction after) {
        int idx = this.manager.getIndex(this);
        if (idx >= 0) {
            this.manager.scheduleActionAt(idx + 1, after);
        }
        return after;
    }

    @Override
    public IAction after(String name, int maxDuration, int delay, Consumer<IAction> t) {
        return this.after(this.manager.create(name, maxDuration, delay, t));
    }

    @Override
    public IAction after(String name, int delay, Consumer<IAction> t) {
        return this.after(this.manager.create(name, delay, t));
    }

    @Override
    public IAction after(int delay, Consumer<IAction> t) {
        return this.after(this.manager.create(delay, t));
    }

    @Override
    public IAction after(String name, Consumer<IAction> t) {
        return this.after(this.manager.create(name, t));
    }

    @Override
    public IAction after(Consumer<IAction> t) {
        return this.after(this.manager.create(t));
    }

    @Override
    public IAction before(IAction before) {
        int idx = this.manager.getIndex(this);
        if (idx >= 0) {
            this.manager.scheduleActionAt(Math.max(0, idx), before);
        }
        return before;
    }

    @Override
    public IAction before(String name, int maxDuration, int delay, Consumer<IAction> t) {
        return this.before(this.manager.create(name, maxDuration, delay, t));
    }

    @Override
    public IAction before(String name, int delay, Consumer<IAction> t) {
        return this.before(this.manager.create(name, delay, t));
    }

    @Override
    public IAction before(int delay, Consumer<IAction> t) {
        return this.before(this.manager.create(delay, t));
    }

    @Override
    public IAction before(String name, Consumer<IAction> t) {
        return this.before(this.manager.create(name, t));
    }

    @Override
    public IAction before(Consumer<IAction> t) {
        return this.before(this.manager.create(t));
    }
}

