/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.handler.data.IMagic;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.data.Magic;

public class MagicController {
    public HashMap<Integer, Magic> magicSync = new HashMap();
    public HashMap<Integer, Magic> magics;
    private static MagicController instance = new MagicController();
    private int lastUsedID = 0;

    public MagicController() {
        instance = this;
        this.magics = new HashMap();
    }

    public static MagicController getInstance() {
        return instance;
    }

    public Magic getMagic(int magic) {
        return this.magics.get(magic);
    }

    public void load() {
        this.magics = new HashMap();
        this.lastUsedID = 0;
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir == null) {
            return;
        }
        try {
            File file = new File(saveDir, "magic.dat");
            if (file.exists()) {
                this.loadMagicFile(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(saveDir, "magic.dat_old");
                if (file.exists()) {
                    this.loadMagicFile(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.magics.isEmpty()) {
            this.magics.put(0, new Magic(0, "Nature", 56576));
            this.magics.put(1, new Magic(1, "Arcane", 15916288));
            this.magics.put(2, new Magic(2, "Ice", 0xDD0000));
            this.magics.put(3, new Magic(3, "Fire", 0xDD0000));
            this.magics.put(4, new Magic(4, "Dark", 0xDD0000));
            this.magics.put(5, new Magic(5, "Holy", 0xDD0000));
        }
    }

    private void loadMagicFile(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        this.loadMagic(var1);
        var1.close();
    }

    public void loadMagic(DataInputStream stream) throws IOException {
        HashMap<Integer, Magic> magic = new HashMap<Integer, Magic>();
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        this.lastUsedID = nbttagcompound1.func_74762_e("lastID");
        NBTTagList list = nbttagcompound1.func_150295_c("NPCMagic", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                Magic loadMagic = new Magic();
                loadMagic.readNBT(nbttagcompound);
                magic.put(loadMagic.id, loadMagic);
            }
        }
        this.magics = magic;
    }

    public NBTTagCompound getNBT() {
        NBTTagList list = new NBTTagList();
        for (int slot : this.magics.keySet()) {
            Magic mag = this.magics.get(slot);
            NBTTagCompound nbtfactions = new NBTTagCompound();
            mag.writeNBT(nbtfactions);
            list.func_74742_a((NBTBase)nbtfactions);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("lastID", this.lastUsedID);
        nbttagcompound.func_74782_a("NPCFactions", (NBTBase)list);
        return nbttagcompound;
    }

    public void saveFactions() {
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            File file = new File(saveDir, "magic.dat_new");
            File file1 = new File(saveDir, "magic.dat_old");
            File file2 = new File(saveDir, "magic.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
    }

    public Magic get(int magicID) {
        return this.magics.get(magicID);
    }

    public List<IMagic> list() {
        return new ArrayList<IMagic>(this.magics.values());
    }

    public void saveMagic(Magic mag) {
        if (mag.id < 0) {
            mag.id = this.getUnusedId();
            while (this.hasName(mag.name)) {
                mag.name = mag.name + "_";
            }
        } else {
            Magic existing = this.magics.get(mag.id);
            if (existing != null && !existing.name.equals(mag.name)) {
                while (this.hasName(mag.name)) {
                    mag.name = mag.name + "_";
                }
            }
        }
        this.magics.remove(mag.id);
        this.magics.put(mag.id, mag);
        NBTTagCompound facCompound = new NBTTagCompound();
        mag.writeNBT(facCompound);
        Server.sendToAll(EnumPacketClient.SYNC_UPDATE, 7, facCompound);
        this.saveFactions();
    }

    public int getUnusedId() {
        if (this.lastUsedID == 0) {
            for (int catid : this.magics.keySet()) {
                if (catid <= this.lastUsedID) continue;
                this.lastUsedID = catid;
            }
        }
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    public boolean hasName(String newName) {
        if (newName.trim().isEmpty()) {
            return true;
        }
        for (Magic mag : this.magics.values()) {
            if (!mag.name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    public Magic getMagicFromName(String magicName) {
        for (Map.Entry<Integer, Magic> entryMag : MagicController.getInstance().magics.entrySet()) {
            if (!entryMag.getValue().name.equalsIgnoreCase(magicName)) continue;
            return entryMag.getValue();
        }
        return null;
    }

    public String[] getNames() {
        String[] names = new String[this.magics.size()];
        int i = 0;
        for (Magic mag : this.magics.values()) {
            names[i] = mag.name.toLowerCase();
            ++i;
        }
        return names;
    }
}

