/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jmodelloader.client;

import com.driga.jmodelloader.client.handlers.PlayerRenderHandler;
import com.driga.jmodelloader.common.CommonProxy;
import com.driga.jmodelloader.items.armor.LoadItemArmor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    private static final HashMap<String, Integer> hash = new HashMap();

    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void Init() {
        super.Init();
        this.renderIcons();
        this.renderEquip();
        this.renderModels();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    public void renderEquip() {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRenderHandler());
    }

    public void renderIcons() {
    }

    public void renderModels() {
        String[] folder = null;
        try {
            folder = ClientProxy.getResourceListing(LoadItemArmor.class, "assets/jmodelloader/models/33/files");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String fileEntry : folder) {
            String model = fileEntry.replaceAll(".obj", "");
            for (int j = 1; j <= 8; ++j) {
                String part = "";
                switch (j) {
                    case 1: {
                        part = "head";
                        break;
                    }
                    case 2: {
                        part = "body";
                        break;
                    }
                    case 3: {
                        part = "bodyHandLeft";
                        break;
                    }
                    case 4: {
                        part = "bodyHandRight";
                        break;
                    }
                    case 5: {
                        part = "legLeft";
                        break;
                    }
                    case 6: {
                        part = "legRight";
                        break;
                    }
                    case 7: {
                        part = "bootLeft";
                        break;
                    }
                    case 8: {
                        part = "bootRight";
                        break;
                    }
                }
                GL11.glCallList((int)ClientProxy.getRenderPart(model, part));
            }
        }
    }

    public static int getRenderPart(String model, String partName) {
        model = model.replaceAll("item.", "");
        model = model.replaceAll("_head", "");
        model = model.replaceAll("_body", "");
        model = model.replaceAll("_pants", "");
        model = model.replaceAll("_boots", "");
        if (hash.containsKey((model = model.replaceAll(".name", "")) + "_" + partName)) {
            return hash.get(model + "_" + partName);
        }
        int displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("jmodelloader", "models/33/files/" + model + ".obj")).renderPart(partName);
        GL11.glEndList();
        hash.put(model + "_" + partName, displayList);
        return displayList;
    }

    static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String entry;
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || (entry = name.replace(path + "/", "")).equals("")) continue;
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }
}

