/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.bossbar.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBar;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarComponent;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarType;
import io.github.cruciblemc.necrotempus.modules.features.bossbar.client.ClientBossBarManager;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class BossBarGui
extends Gui {
    private static final ResourceLocation BARS_TEXTURES = new ResourceLocation("necrotempus", "textures/gui/bars.png");
    private final int BAR_SIZE = 182;
    private final int BAR_SEGMENT_HEIGHT = 5;
    private final int DECORATION_GAP = 20;
    private final int BAR_MARGIN = 20;
    private final Minecraft minecraft;
    private static BossBarGui instance;

    public static BossBarGui getInstance() {
        return instance != null ? instance : new BossBarGui();
    }

    private BossBarGui() {
        instance = this;
        this.minecraft = Minecraft.func_71410_x();
    }

    private void render(ScaledResolution scaledResolution) {
        TextureManager textureManager = this.minecraft.func_110434_K();
        if (!ClientBossBarManager.isEmpty()) {
            int width = scaledResolution.func_78326_a();
            int y = 12;
            Iterator<BossBar> iterator = ClientBossBarManager.iterator();
            while (iterator.hasNext()) {
                BossBar bar = iterator.next();
                if (bar.getCreationTime() != 0L && bar.getCreationTime() + 2000L < System.currentTimeMillis()) {
                    iterator.remove();
                    continue;
                }
                if (!bar.isVisible()) continue;
                int x = width / 2 - 91;
                GL11.glPushMatrix();
                this.drawBossBar(textureManager, x, y, bar);
                String t = bar.getText().func_150254_d();
                int textWidth = this.minecraft.field_71466_p.func_78256_a(t);
                int textX = width / 2 - textWidth / 2;
                int textY = y - 9;
                this.minecraft.field_71466_p.func_78261_a(t, textX, textY, 0xFFFFFF);
                GL11.glPopMatrix();
                if ((y += 20) < scaledResolution.func_78328_b() / 3) continue;
                break;
            }
        }
    }

    private void drawBossBar(TextureManager textureManager, int x, int y, BossBarComponent bar) {
        int percentage;
        this.minecraft.field_71424_I.func_76320_a("necroTimeBossBar");
        GL11.glPushMatrix();
        int color = bar.getColor().intValue();
        if (bar.getLazyColor() != -1) {
            color = bar.getLazyColor();
        }
        float RED = (float)(color >> 16 & 0xFF) / 255.0f;
        float GREEN = (float)(color >> 8 & 0xFF) / 255.0f;
        float BLUE = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)RED, (float)GREEN, (float)BLUE, (float)1.0f);
        textureManager.func_110577_a(BARS_TEXTURES);
        this.func_73729_b(x, y, 0, 0, 182, 5);
        if (bar.getType() != BossBarType.FLAT) {
            this.func_73729_b(x, y, 0, 20 + (bar.getType().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((percentage = (int)(bar.getPercentage() * 182.0f)) > 0) {
            this.func_73729_b(x, y, 0, 5, percentage, 5);
            if (bar.getType() != BossBarType.FLAT) {
                this.func_73729_b(x, y, 0, 20 + (bar.getType().ordinal() - 1) * 5 * 2 + 5, percentage, 5);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        this.minecraft.field_71424_I.func_76319_b();
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            instance.render(event.resolution);
        }
    }
}

