/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.network;

import com.DarknessCrow.events.ClientEvents;
import com.DarknessCrow.events.ItemRenderConfig;
import com.DarknessCrow.items.CrowItem;
import com.DarknessCrow.modelsParts.ModelCustomObjPart;
import com.DarknessCrow.network.ModelRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GenericEntityRenderHandler {
    private static final double RENDER_RANGE = 48.0;
    public static float offsetX = 0.4f;
    public static float offsetY = 0.7f;
    public static float offsetZ = -0.5f;
    public static float rotationX = 240.0f;
    public static float rotationY = -45.0f;
    public static float rotationZ = 180.0f;
    public static float scalef = 0.5f;

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        float partialTicks = event.partialTicks;
        double camX = RenderManager.field_78725_b;
        double camY = RenderManager.field_78726_c;
        double camZ = RenderManager.field_78723_d;
        for (Object o : mc.field_71441_e.field_72996_f) {
            int[] parts;
            EntityLivingBase entity;
            if (!(o instanceof EntityLivingBase) || (entity = (EntityLivingBase)o).func_82150_aj() || mc.field_71439_g.func_70068_e((Entity)entity) > 2304.0 || (parts = this.getPartsFromNBT(entity)).length == 0) continue;
            double x = this.interpolate(entity.field_70142_S, entity.field_70165_t, partialTicks) - camX;
            double y = this.interpolate(entity.field_70137_T, entity.field_70163_u, partialTicks) - camY + (double)entity.field_70131_O * 0.9;
            double z = this.interpolate(entity.field_70136_U, entity.field_70161_v, partialTicks) - camZ;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            float yaw = this.interpolate(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
            GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            Render renderer = RenderManager.field_78727_a.func_78713_a((Entity)entity);
            if (!(renderer instanceof RenderLiving)) {
                GL11.glPopMatrix();
                continue;
            }
            RenderLiving renderLiving = (RenderLiving)renderer;
            ModelBiped model = this.getMainModel(renderLiving);
            if (model == null) {
                GL11.glPopMatrix();
                continue;
            }
            boolean isBiped = model instanceof ModelBiped;
            ModelBiped biped = isBiped ? model : null;
            for (int id : parts) {
                List<ModelCustomObjPart> modelList = ModelRegistry.get(id);
                if (modelList == null) continue;
                for (ModelCustomObjPart part : modelList) {
                    if (part == null || part.alpha >= 1.0f) continue;
                    GL11.glPushMatrix();
                    if (isBiped && !"none".equals(part.bodyPart)) {
                        this.applyRefinedTransform(biped, part.bodyPart, entity.field_70125_A, entity.func_70093_af());
                    } else if (part.modelOffset.length >= 3) {
                        GL11.glTranslatef((float)part.modelOffset[0], (float)part.modelOffset[1], (float)part.modelOffset[2]);
                    }
                    part.func_78785_a(0.0625f);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (!event.renderer.getClass().getName().equals("noppes.npcs.client.renderer.RenderCustomNpc")) {
            return;
        }
        EntityLivingBase entity = event.entity;
        if (entity == null) {
            return;
        }
        int[] parts = this.getPartsFromNBT(entity);
        int sheathId = this.getSheathItemIdFromBoots(entity);
        if (parts.length == 0 && sheathId == -1) {
            return;
        }
        RenderLiving renderLiving = (RenderLiving)event.renderer;
        ModelBiped biped = this.getMainModel(renderLiving);
        if (biped == null) {
            return;
        }
        float partialTicks = ClientEvents.partialRenderTick;
        double x = this.interpolate(entity.field_70169_q, entity.field_70165_t, partialTicks) - RenderManager.field_78725_b;
        double y = this.interpolate(entity.field_70167_r, entity.field_70163_u, partialTicks) - RenderManager.field_78726_c;
        double z = this.interpolate(entity.field_70166_s, entity.field_70161_v, partialTicks) - RenderManager.field_78723_d;
        float yaw = this.interpolate(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        for (int id : parts) {
            List<ModelCustomObjPart> modelList = ModelRegistry.get(id);
            if (modelList == null) continue;
            for (ModelCustomObjPart model : modelList) {
                if (model == null || model.alpha < 1.0f) continue;
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-1.4f, (float)0.0f);
                if (!"none".equals(model.bodyPart)) {
                    ModelRenderer part = this.getBodyPartRenderer(biped, model.bodyPart);
                    if (part != null) {
                        part.func_78794_c(0.0625f);
                    }
                } else if (model.modelOffset.length >= 3) {
                    GL11.glTranslatef((float)model.modelOffset[0], (float)model.modelOffset[1], (float)model.modelOffset[2]);
                }
                model.func_78785_a(1.0f);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
        if (sheathId > 0) {
            this.renderItemOnNpc(entity, biped, sheathId, x, y, z, yaw);
        }
    }

    private ModelBiped getMainModel(RenderLiving renderer) {
        try {
            if (renderer.getClass().getName().equals("noppes.npcs.client.renderer.RenderCustomNpc")) {
                Field field = renderer.getClass().getSuperclass().getDeclaredField("originalBipedMain");
                field.setAccessible(true);
                return (ModelBiped)field.get(renderer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void renderItemOnNpc(EntityLivingBase entity, ModelBiped biped, int itemId, double x, double y, double z, float yaw) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack hotbarItem = new ItemStack(Item.func_150899_d((int)itemId));
        if (hotbarItem == null) {
            return;
        }
        if (!(hotbarItem.func_77973_b() instanceof CrowItem)) {
            return;
        }
        String itemName = hotbarItem.func_77977_a();
        ItemRenderConfig.Transform t = ItemRenderConfig.getTransformForItemName(itemName);
        if (t == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.4f, (float)0.0f);
        biped.field_78115_e.func_78794_c(0.0625f);
        if (t == null) {
            GL11.glScalef((float)scalef, (float)scalef, (float)scalef);
            GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
            GL11.glRotatef((float)rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GL11.glScalef((float)t.scale, (float)t.scale, (float)t.scale);
            GL11.glTranslatef((float)t.offsetX, (float)t.offsetY, (float)t.offsetZ);
            GL11.glRotatef((float)t.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)t.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)t.rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer itemRenderer = mc.field_71460_t.field_78516_c;
        itemRenderer.func_78443_a(entity, hotbarItem, 0);
        GL11.glPopMatrix();
    }

    private ModelRenderer getBodyPartRenderer(ModelBiped biped, String partName) {
        switch (partName) {
            case "bipedHead": {
                return biped.field_78116_c;
            }
            case "bipedBody": {
                return biped.field_78115_e;
            }
            case "bipedRightArm": {
                return biped.field_78112_f;
            }
            case "bipedLeftArm": {
                return biped.field_78113_g;
            }
            case "bipedRightLeg": {
                return biped.field_78123_h;
            }
            case "bipedLeftLeg": {
                return biped.field_78124_i;
            }
            case "none": {
                return null;
            }
        }
        return null;
    }

    private int[] getPartsFromNBT(EntityLivingBase entity) {
        if (entity == null) {
            return new int[0];
        }
        try {
            NBTTagCompound tag;
            ItemStack boots = entity.func_71124_b(1);
            if (boots != null && boots.func_77942_o() && (tag = boots.func_77978_p()).func_74764_b("ModelParts")) {
                NBTTagCompound modelTag = tag.func_74775_l("ModelParts");
                int count = modelTag.func_74762_e("count");
                int[] parts = new int[count];
                for (int i = 0; i < count; ++i) {
                    parts[i] = modelTag.func_74762_e("part" + i);
                }
                return parts;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new int[0];
    }

    private int getSheathItemIdFromBoots(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        try {
            NBTTagCompound tag;
            ItemStack boots = entity.func_71124_b(1);
            if (boots != null && boots.func_77942_o() && (tag = boots.func_77978_p()).func_74764_b("SheathItemID")) {
                return tag.func_74762_e("SheathItemID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    private double interpolate(double prev, double current, float partialTicks) {
        return prev + (current - prev) * (double)partialTicks;
    }

    private float interpolate(float prev, float current, float partialTicks) {
        return prev + (current - prev) * partialTicks;
    }

    private void applyRefinedTransform(ModelBiped biped, String partName, float pitch, boolean sneaking) {
        if (biped == null) {
            return;
        }
        ModelRenderer part = null;
        switch (partName) {
            case "bipedHead": {
                part = biped.field_78116_c;
                break;
            }
            case "bipedBody": {
                part = biped.field_78115_e;
                break;
            }
            case "bipedRightArm": {
                part = biped.field_78112_f;
                break;
            }
            case "bipedLeftArm": {
                part = biped.field_78113_g;
                break;
            }
            case "bipedRightLeg": {
                part = biped.field_78123_h;
                break;
            }
            case "bipedLeftLeg": {
                part = biped.field_78124_i;
            }
        }
        if (part == null) {
            return;
        }
        GL11.glTranslatef((float)(biped.field_78115_e.field_78800_c / 16.0f), (float)(biped.field_78115_e.field_78797_d / 16.0f), (float)(biped.field_78115_e.field_78798_e / 16.0f));
        GL11.glRotatef((float)(biped.field_78115_e.field_78808_h * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(biped.field_78115_e.field_78796_g * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-biped.field_78115_e.field_78795_f * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(part.field_78800_c / 16.0f), (float)(part.field_78797_d / 16.0f), (float)(part.field_78798_e / 16.0f));
        GL11.glRotatef((float)(part.field_78808_h * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        if ("bipedRightArm".equals(partName)) {
            GL11.glRotatef((float)(-part.field_78795_f * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-part.field_78796_g * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(part.field_78795_f * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(part.field_78796_g * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (sneaking) {
            GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
        }
    }
}

