/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.script;

import java.util.ArrayList;
import java.util.List;
import kamkeel.npcs.network.packets.request.script.EventScriptPacket;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.client.gui.script.GuiScriptInterface;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.DataScript;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNPCEventScripts
extends GuiScriptInterface {
    private final DataScript script;

    public GuiNPCEventScripts(EntityNPCInterface npc) {
        this.hookList = new ArrayList();
        this.hookList.add("init");
        this.hookList.add("tick");
        this.hookList.add("interact");
        this.hookList.add("dialog");
        this.hookList.add("damaged");
        this.hookList.add("killed");
        this.hookList.add("meleeAttack");
        this.hookList.add("meleeSwing");
        this.hookList.add("rangedLaunched");
        this.hookList.add("target");
        this.hookList.add("collide");
        this.hookList.add("kills");
        this.hookList.add("dialogClose");
        this.hookList.add("timer");
        this.hookList.add("targetLost");
        this.hookList.add("projectileTick");
        this.hookList.add("projectileImpact");
        this.script = new DataScript(npc);
        this.handler = this.script;
        EventScriptPacket.Get();
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_74764_b("LoadComplete")) {
            this.loaded = true;
            return;
        }
        if (!compound.func_74764_b("Tab")) {
            this.script.setLanguage(compound.func_74779_i("ScriptLanguage"));
            this.script.setEnabled(compound.func_74767_n("ScriptEnabled"));
            super.setGuiData(compound);
        } else {
            int tab = compound.func_74762_e("Tab");
            ScriptContainer container = new ScriptContainer(this.script);
            container.readFromNBT(compound.func_74775_l("Script"));
            if (this.script.getScripts().isEmpty()) {
                for (int i = 0; i < compound.func_74762_e("TotalScripts"); ++i) {
                    this.script.getScripts().add(new ScriptContainer(this.script));
                }
            }
            this.script.getScripts().set(tab, container);
            this.func_73866_w_();
        }
    }

    @Override
    public void save() {
        if (this.loaded) {
            super.save();
            List<ScriptContainer> containers = this.script.getScripts();
            for (int i = 0; i < containers.size(); ++i) {
                ScriptContainer container = containers.get(i);
                EventScriptPacket.Save(i, containers.size(), container.writeToNBT(new NBTTagCompound()));
            }
            NBTTagCompound scriptData = new NBTTagCompound();
            scriptData.func_74778_a("ScriptLanguage", this.script.getLanguage());
            scriptData.func_74757_a("ScriptEnabled", this.script.getEnabled());
            scriptData.func_74782_a("ScriptConsole", (NBTBase)NBTTags.NBTLongStringMap(this.script.getConsoleText()));
            EventScriptPacket.Save(-1, containers.size(), scriptData);
        }
    }
}

