/*
 * Decompiled with CFR 0.152.
 */
package com.rnoverlays.client;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class OverlayClient {
    private static final int MAX_GIF_FRAMES = 100;
    private static final int MAX_GIF_SIZE = 2048;
    private static final List<OverlayEntry> OVERLAYS = new ArrayList<OverlayEntry>();
    private static final Queue<Runnable> MAIN_THREAD_TASKS = new ConcurrentLinkedQueue<Runnable>();
    private static boolean wasInWorld = false;

    public static void runOnClient(Runnable r) {
        MAIN_THREAD_TASKS.add(r);
    }

    public static void bootstrap() {
        OverlayClient instance = new OverlayClient();
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        System.out.println("[RN Overlays] OverlayClient bootstrap conclu\u00eddo (GIF animado seguro).");
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        Runnable job;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        OverlayClient.handleWorldChange(mc);
        while ((job = MAIN_THREAD_TASKS.poll()) != null) {
            try {
                job.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (mc.field_71441_e == null) {
            return;
        }
    }

    private static void handleWorldChange(Minecraft mc) {
        boolean inWorld = mc.field_71441_e != null;
        boolean bl = inWorld;
        if (!inWorld && wasInWorld) {
            OverlayClient.clearAllNow();
        }
        wasInWorld = inWorld;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null) {
            return;
        }
        if (OVERLAYS.isEmpty()) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        if (e.type == RenderGameOverlayEvent.ElementType.TEXT) {
            this.renderLayer(mc, sr, 0, false);
        } else if (e.type == RenderGameOverlayEvent.ElementType.ALL) {
            this.renderLayer(mc, sr, 1, false);
            if (mc.field_71462_r == null) {
                this.renderLayer(mc, sr, 2, false);
            }
        }
    }

    @SubscribeEvent
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null) {
            return;
        }
        if (OVERLAYS.isEmpty()) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        this.renderLayer(mc, sr, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLayer(Minecraft mc, ScaledResolution sr, int wantedLayer, boolean ignoreLayerCheck) {
        List<OverlayEntry> list;
        int scaleFactor;
        int sw = sr.func_78326_a();
        int sh = sr.func_78328_b();
        try {
            scaleFactor = sr.func_78325_e();
        }
        catch (Throwable t) {
            scaleFactor = 2;
        }
        float guiScaleFactor = (float)scaleFactor / 2.0f;
        if (guiScaleFactor < 0.5f) {
            guiScaleFactor = 0.5f;
        }
        if (guiScaleFactor > 2.0f) {
            guiScaleFactor = 2.0f;
        }
        List<OverlayEntry> list2 = list = OVERLAYS;
        synchronized (list2) {
            for (OverlayEntry ov : OVERLAYS) {
                ResourceLocation tex;
                if (ov == null || !ignoreLayerCheck && ov.layer != wantedLayer || (tex = OverlayClient.getCurrentTextureFor(ov)) == null) continue;
                float baseWFrac = OverlayClient.clampRange(ov.wFrac, 0.05f, 1.0f);
                float xFrac = OverlayClient.clampRange(ov.xFrac, 0.0f, 1.0f);
                float yFrac = OverlayClient.clampRange(ov.yFrac, 0.0f, 1.0f);
                int drawW = Math.max(8, (int)((float)sw * baseWFrac * guiScaleFactor));
                int drawH = ov.imgW > 0 && ov.imgH > 0 ? Math.max(8, (int)Math.round((double)drawW * (double)ov.imgH / (double)ov.imgW)) : drawW;
                int x = (int)((float)sw * xFrac);
                int y = (int)((float)sh * yFrac);
                x = Math.max(0, Math.min(x, sw - drawW));
                y = Math.max(0, Math.min(y, sh - drawH));
                mc.func_110434_K().func_110577_a(tex);
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)OverlayClient.clampRange(ov.alpha, 0.0f, 1.0f));
                Tessellator t = Tessellator.field_78398_a;
                t.func_78382_b();
                t.func_78374_a((double)x, (double)(y + drawH), 0.0, 0.0, 1.0);
                t.func_78374_a((double)(x + drawW), (double)(y + drawH), 0.0, 1.0, 1.0);
                t.func_78374_a((double)(x + drawW), (double)y, 0.0, 1.0, 0.0);
                t.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
                t.func_78381_a();
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
            }
        }
    }

    private static ResourceLocation getCurrentTextureFor(OverlayEntry ov) {
        if (!ov.animated || ov.frames == null || ov.frames.isEmpty() || ov.frameDurationsMs == null || ov.frameDurationsMs.length == 0 || ov.totalDurationMs <= 0) {
            return ov.texture;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - ov.animStartTimeMs;
        if (elapsed < 0L) {
            elapsed = 0L;
        }
        long t = elapsed % (long)ov.totalDurationMs;
        int idx = 0;
        long acc = 0L;
        for (int i = 0; i < ov.frameDurationsMs.length; ++i) {
            if (t >= (acc += (long)ov.frameDurationsMs[i])) continue;
            idx = i;
            break;
        }
        if (idx < 0 || idx >= ov.frames.size()) {
            idx = 0;
        }
        return ov.frames.get(idx);
    }

    public static void clearAll() {
        OverlayClient.runOnClient(new Runnable(){

            @Override
            public void run() {
                OverlayClient.clearAllNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearAllNow() {
        List<OverlayEntry> list;
        List<OverlayEntry> list2 = list = OVERLAYS;
        synchronized (list2) {
            OVERLAYS.clear();
        }
    }

    public static void addOverlay(String url, float xFrac, float yFrac, float wFrac, float alpha, int layer) {
        if (!OverlayClient.isLikelyDirectImageURL(url)) {
            return;
        }
        final OverlayEntry ov = new OverlayEntry();
        ov.url = url;
        ov.xFrac = OverlayClient.clampRange(xFrac, 0.0f, 1.0f);
        ov.yFrac = OverlayClient.clampRange(yFrac, 0.0f, 1.0f);
        ov.wFrac = OverlayClient.clampRange(wFrac, 0.05f, 1.0f);
        ov.alpha = OverlayClient.clampRange(alpha, 0.0f, 1.0f);
        ov.layer = layer < 0 ? 0 : (layer > 2 ? 2 : layer);
        ov.loading = true;
        ov.lastError = null;
        ov.animated = false;
        ov.frames = null;
        ov.frameDurationsMs = null;
        ov.totalDurationMs = 0;
        ov.animStartTimeMs = 0L;
        OverlayClient.runOnClient(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list;
                List list2 = list = OVERLAYS;
                synchronized (list2) {
                    OVERLAYS.add(ov);
                }
            }
        });
        OverlayClient.startDownload(ov);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAnyLoading() {
        List<OverlayEntry> list;
        List<OverlayEntry> list2 = list = OVERLAYS;
        synchronized (list2) {
            for (OverlayEntry ov : OVERLAYS) {
                if (ov == null || !ov.loading) continue;
                return true;
            }
        }
        return false;
    }

    public static String getLastError() {
        OverlayEntry ov = OverlayClient.getLastOverlay();
        return ov != null ? ov.lastError : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OverlayEntry getLastOverlay() {
        List<OverlayEntry> list;
        List<OverlayEntry> list2 = list = OVERLAYS;
        synchronized (list2) {
            if (OVERLAYS.isEmpty()) {
                return null;
            }
            return OVERLAYS.get(OVERLAYS.size() - 1);
        }
    }

    public static boolean isLikelyDirectImageURL(String u) {
        int h;
        if (u == null) {
            return false;
        }
        String s = u.trim().toLowerCase();
        if (!s.startsWith("http://") && !s.startsWith("https://")) {
            return false;
        }
        int q = s.indexOf(63);
        if (q >= 0) {
            s = s.substring(0, q);
        }
        if ((h = s.indexOf(35)) >= 0) {
            s = s.substring(0, h);
        }
        return s.endsWith(".png") || s.endsWith(".jpg") || s.endsWith(".jpeg") || s.endsWith(".gif");
    }

    private static boolean isGifUrl(String u) {
        int h;
        if (u == null) {
            return false;
        }
        String s = u.trim().toLowerCase();
        int q = s.indexOf(63);
        if (q >= 0) {
            s = s.substring(0, q);
        }
        if ((h = s.indexOf(35)) >= 0) {
            s = s.substring(0, h);
        }
        return s.endsWith(".gif");
    }

    private static void startDownload(final OverlayEntry entry) {
        new Thread("RN-Overlay-Downloader"){

            @Override
            public void run() {
                try {
                    URL u = new URL(entry.url);
                    URLConnection conn = u.openConnection();
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64)");
                    conn.setRequestProperty("Accept", "image/png,image/jpeg,image/jpg,image/gif,image/*;q=0.9,*/*;q=0.8");
                    conn.setRequestProperty("Referer", "https://imgur.com/");
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(15000);
                    ImageIO.setUseCache(false);
                    boolean wantGif = OverlayClient.isGifUrl(entry.url);
                    String contentType = conn.getContentType();
                    if (!wantGif && contentType != null && contentType.toLowerCase().contains("gif")) {
                        wantGif = true;
                    }
                    if (wantGif) {
                        OverlayClient.handleGifDownload(entry, conn);
                    } else {
                        OverlayClient.handleStaticDownload(entry, conn);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    OverlayClient.runOnClient(new Runnable(){

                        @Override
                        public void run() {
                            entry.texture = null;
                            entry.loading = false;
                            entry.lastError = "DownloadError";
                            entry.animated = false;
                        }
                    });
                }
            }
        }.start();
    }

    private static void handleStaticDownload(final OverlayEntry entry, URLConnection conn) throws IOException {
        BufferedImage img;
        try (InputStream in = conn.getInputStream();){
            img = ImageIO.read(in);
        }
        if (img == null) {
            throw new IOException("O servidor n\u00e3o retornou uma imagem.");
        }
        OverlayClient.runOnClient(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourceLocation res;
                    entry.imgW = img.getWidth();
                    entry.imgH = img.getHeight();
                    if (!OverlayClient.isSizeSafe(entry.imgW, entry.imgH)) {
                        entry.texture = null;
                        entry.loading = false;
                        entry.lastError = "ImageTooBig";
                        entry.animated = false;
                        return;
                    }
                    DynamicTexture dyn = new DynamicTexture(img);
                    entry.texture = res = Minecraft.func_71410_x().func_110434_K().func_110578_a("rn_overlay_" + System.nanoTime(), dyn);
                    entry.loading = false;
                    entry.lastError = null;
                    entry.animated = false;
                    System.out.println("[RN Overlays] Overlay est\u00e1tico OK: " + entry.imgW + "x" + entry.imgH + " (" + entry.url + ")");
                }
                catch (Throwable glEx) {
                    entry.texture = null;
                    entry.loading = false;
                    entry.lastError = "GL: " + glEx.getMessage();
                    entry.animated = false;
                    System.out.println("[RN Overlays] Falha GL est\u00e1tico: " + entry.lastError);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleGifDownload(final OverlayEntry entry, URLConnection conn) throws IOException {
        ArrayList<BufferedImage> framesOut = new ArrayList<BufferedImage>();
        ArrayList<Integer> delaysMs = new ArrayList<Integer>();
        try (InputStream in = conn.getInputStream();){
            ImageInputStream stream = ImageIO.createImageInputStream(in);
            if (stream == null) {
                throw new IOException("N\u00e3o foi poss\u00edvel criar ImageInputStream para o GIF.");
            }
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
            if (!readers.hasNext()) {
                throw new IOException("Nenhum ImageReader para GIF dispon\u00edvel.");
            }
            ImageReader reader = readers.next();
            try {
                reader.setInput(stream, false, false);
                int numFrames = reader.getNumImages(true);
                if (numFrames <= 0) {
                    throw new IOException("GIF sem frames.");
                }
                if (numFrames > 100) {
                    throw new IOException("GIF com frames demais (" + numFrames + ").");
                }
                int canvasW = 1;
                int canvasH = 1;
                for (int i = 0; i < numFrames; ++i) {
                    IIOMetadata meta = reader.getImageMetadata(i);
                    String metaFormat = meta.getNativeMetadataFormatName();
                    IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(metaFormat);
                    IIOMetadataNode desc = OverlayClient.getNode(root, "ImageDescriptor");
                    int x = OverlayClient.parseIntSafe(desc.getAttribute("imageLeftPosition"), 0);
                    int y = OverlayClient.parseIntSafe(desc.getAttribute("imageTopPosition"), 0);
                    int w = OverlayClient.parseIntSafe(desc.getAttribute("imageWidth"), 1);
                    int h = OverlayClient.parseIntSafe(desc.getAttribute("imageHeight"), 1);
                    canvasW = Math.max(canvasW, x + w);
                    canvasH = Math.max(canvasH, y + h);
                }
                if (!OverlayClient.isSizeSafe(canvasW, canvasH)) {
                    throw new IOException("GIF muito grande: " + canvasW + "x" + canvasH);
                }
                BufferedImage master = new BufferedImage(canvasW, canvasH, 2);
                BufferedImage masterCopy = null;
                String prevDisposal = "none";
                int prevX = 0;
                int prevY = 0;
                int prevW = canvasW;
                int prevH = canvasH;
                int totalMs = 0;
                for (int i = 0; i < numFrames; ++i) {
                    Graphics2D g;
                    String metaFormat;
                    IIOMetadata meta = reader.getImageMetadata(i);
                    IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(metaFormat = meta.getNativeMetadataFormatName());
                    IIOMetadataNode gce = OverlayClient.getNode(root, "GraphicControlExtension");
                    String disposal = gce != null ? gce.getAttribute("disposalMethod") : "none";
                    int delayMs = 100;
                    if (gce != null) {
                        int delayCs = OverlayClient.parseIntSafe(gce.getAttribute("delayTime"), 10);
                        delayMs = Math.max(20, delayCs * 10);
                    }
                    IIOMetadataNode desc = OverlayClient.getNode(root, "ImageDescriptor");
                    int x = OverlayClient.parseIntSafe(desc.getAttribute("imageLeftPosition"), 0);
                    int y = OverlayClient.parseIntSafe(desc.getAttribute("imageTopPosition"), 0);
                    int w = OverlayClient.parseIntSafe(desc.getAttribute("imageWidth"), canvasW);
                    int h = OverlayClient.parseIntSafe(desc.getAttribute("imageHeight"), canvasH);
                    if (i == 0) {
                        g = master.createGraphics();
                        g.setComposite(AlphaComposite.Clear);
                        g.fillRect(0, 0, canvasW, canvasH);
                        g.dispose();
                    } else if ("restoreToPrevious".equals(prevDisposal) && masterCopy != null) {
                        g = master.createGraphics();
                        g.setComposite(AlphaComposite.Src);
                        g.drawImage(masterCopy, 0, 0, null);
                        g.dispose();
                    } else if ("restoreToBackgroundColor".equals(prevDisposal) || "restoreToBackground".equals(prevDisposal)) {
                        g = master.createGraphics();
                        g.setComposite(AlphaComposite.Clear);
                        g.fillRect(prevX, prevY, prevW, prevH);
                        g.dispose();
                    }
                    masterCopy = "restoreToPrevious".equals(disposal) ? OverlayClient.deepCopy(master) : null;
                    BufferedImage frame = reader.read(i);
                    Graphics2D g2 = master.createGraphics();
                    g2.setComposite(AlphaComposite.SrcOver);
                    g2.drawImage((Image)frame, x, y, null);
                    g2.dispose();
                    BufferedImage outFrame = OverlayClient.deepCopy(master);
                    framesOut.add(outFrame);
                    delaysMs.add(delayMs);
                    totalMs += delayMs;
                    prevDisposal = disposal == null ? "none" : disposal;
                    prevX = x;
                    prevY = y;
                    prevW = w;
                    prevH = h;
                }
                if (framesOut.isEmpty()) {
                    throw new IOException("GIF sem frames v\u00e1lidos.");
                }
                final int fCanvasW = canvasW;
                final int fCanvasH = canvasH;
                final int fTotalMs = totalMs <= 0 ? 100 * framesOut.size() : totalMs;
                final ArrayList<BufferedImage> finalFrames = framesOut;
                final ArrayList<Integer> finalDelays = delaysMs;
                OverlayClient.runOnClient(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            entry.imgW = fCanvasW;
                            entry.imgH = fCanvasH;
                            entry.frames = new ArrayList<ResourceLocation>(finalFrames.size());
                            entry.frameDurationsMs = new int[finalFrames.size()];
                            Minecraft mc = Minecraft.func_71410_x();
                            for (int i = 0; i < finalFrames.size(); ++i) {
                                BufferedImage fi = (BufferedImage)finalFrames.get(i);
                                int delayMs = i < finalDelays.size() ? (Integer)finalDelays.get(i) : 100;
                                int n = delayMs;
                                if (delayMs <= 0) {
                                    delayMs = 100;
                                }
                                DynamicTexture dyn = new DynamicTexture(fi);
                                ResourceLocation res = mc.func_110434_K().func_110578_a("rn_overlay_gif_" + System.nanoTime() + "_" + i, dyn);
                                entry.frames.add(res);
                                entry.frameDurationsMs[i] = delayMs;
                            }
                            if (entry.frames.isEmpty()) {
                                entry.texture = null;
                                entry.loading = false;
                                entry.lastError = "GIFNoFrames";
                                entry.animated = false;
                                return;
                            }
                            entry.texture = entry.frames.get(0);
                            entry.totalDurationMs = fTotalMs;
                            entry.animStartTimeMs = System.currentTimeMillis();
                            entry.loading = false;
                            entry.lastError = null;
                            entry.animated = true;
                            System.out.println("[RN Overlays] GIF animado OK: " + entry.imgW + "x" + entry.imgH + " frames=" + entry.frames.size() + " totalMs=" + entry.totalDurationMs + " url=" + entry.url);
                        }
                        catch (Throwable glEx) {
                            entry.texture = null;
                            entry.loading = false;
                            entry.lastError = "GL-GIF: " + glEx.getMessage();
                            entry.animated = false;
                            System.out.println("[RN Overlays] Falha GL GIF: " + entry.lastError);
                        }
                    }
                });
            }
            finally {
                reader.dispose();
                stream.close();
            }
        }
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        if (rootNode == null) {
            return null;
        }
        for (int i = 0; i < rootNode.getLength(); ++i) {
            IIOMetadataNode node;
            if (!(rootNode.item(i) instanceof IIOMetadataNode) || !nodeName.equalsIgnoreCase((node = (IIOMetadataNode)rootNode.item(i)).getNodeName())) continue;
            return node;
        }
        return null;
    }

    private static int parseIntSafe(String s, int def) {
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Throwable ignored) {
            return def;
        }
    }

    private static BufferedImage deepCopy(BufferedImage src) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D g = dst.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return dst;
    }

    private static boolean isSizeSafe(int w, int h) {
        return w > 0 && h > 0 && w <= 2048 && h <= 2048;
    }

    private static float clampRange(float v, float min, float max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static class OverlayEntry {
        public String url;
        public ResourceLocation texture;
        public int imgW;
        public int imgH;
        public float xFrac;
        public float yFrac;
        public float wFrac;
        public float alpha;
        public int layer;
        public boolean loading;
        public String lastError;
        public boolean animated;
        public List<ResourceLocation> frames;
        public int[] frameDurationsMs;
        public int totalDurationMs;
        public long animStartTimeMs;
    }
}

