/*
 * Decompiled with CFR 0.152.
 */
package com.rnoverlays.license;

import com.rnoverlays.license.LicenseGuard;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;

public final class LicensePluginBridge {
    public static final String CHANNEL_NAME = "rnlicense";
    private static FMLEventChannel channel;
    private static boolean initialized;

    private LicensePluginBridge() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNEL_NAME);
        channel.register((Object)new LicensePluginBridge());
        System.out.println("[RNOverlays] LicensePluginBridge inicializado no canal 'rnlicense'.");
    }

    @SubscribeEvent
    public void onClientCustomPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            if (event == null || event.packet == null) {
                return;
            }
            ByteBuf buf = event.packet.payload();
            if (buf == null || !buf.isReadable()) {
                System.out.println("[RNOverlays] LicensePluginBridge: pacote vazio.");
                return;
            }
            boolean allowed = buf.readBoolean();
            System.out.println("[RNOverlays] LicensePluginBridge: mensagem recebida do servidor, allowed=" + allowed);
            LicenseGuard.onServerLicenseStatus(allowed);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        initialized = false;
    }
}

