/*
 * Decompiled with CFR 0.152.
 */
package br.dev.brunoxkk0.advancedtitles.common;

import br.dev.brunoxkk0.advancedtitles.common.Alignment;
import java.util.Arrays;

public class Title {
    private String[] lines;
    private Alignment alignment;
    private int paddingX;
    private int paddingY;
    private int duration;
    private long start;

    public static TitleBuilder builder() {
        return new TitleBuilder();
    }

    public Title(String[] lines, Alignment alignment, int paddingX, int paddingY, int duration, long start) {
        this.lines = lines;
        this.alignment = alignment;
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        this.duration = duration;
        this.start = start;
    }

    public Title() {
    }

    public String[] getLines() {
        return this.lines;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getStart() {
        return this.start;
    }

    public void setLines(String[] lines) {
        this.lines = lines;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
    }

    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Title)) {
            return false;
        }
        Title other = (Title)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPaddingX() != other.getPaddingX()) {
            return false;
        }
        if (this.getPaddingY() != other.getPaddingY()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLines(), other.getLines())) {
            return false;
        }
        Alignment this$alignment = this.getAlignment();
        Alignment other$alignment = other.getAlignment();
        return !(this$alignment == null ? other$alignment != null : !((Object)((Object)this$alignment)).equals((Object)other$alignment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Title;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPaddingX();
        result = result * 59 + this.getPaddingY();
        result = result * 59 + this.getDuration();
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        result = result * 59 + Arrays.deepHashCode(this.getLines());
        Alignment $alignment = this.getAlignment();
        result = result * 59 + ($alignment == null ? 43 : ((Object)((Object)$alignment)).hashCode());
        return result;
    }

    public String toString() {
        return "Title(lines=" + Arrays.deepToString(this.getLines()) + ", alignment=" + (Object)((Object)this.getAlignment()) + ", paddingX=" + this.getPaddingX() + ", paddingY=" + this.getPaddingY() + ", duration=" + this.getDuration() + ", start=" + this.getStart() + ")";
    }

    public static class TitleBuilder {
        private String[] lines;
        private Alignment alignment;
        private int paddingX;
        private int paddingY;
        private int duration;
        private long start;

        TitleBuilder() {
        }

        public TitleBuilder lines(String[] lines) {
            this.lines = lines;
            return this;
        }

        public TitleBuilder alignment(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public TitleBuilder paddingX(int paddingX) {
            this.paddingX = paddingX;
            return this;
        }

        public TitleBuilder paddingY(int paddingY) {
            this.paddingY = paddingY;
            return this;
        }

        public TitleBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public TitleBuilder start(long start) {
            this.start = start;
            return this;
        }

        public Title build() {
            return new Title(this.lines, this.alignment, this.paddingX, this.paddingY, this.duration, this.start);
        }

        public String toString() {
            return "Title.TitleBuilder(lines=" + Arrays.deepToString(this.lines) + ", alignment=" + (Object)((Object)this.alignment) + ", paddingX=" + this.paddingX + ", paddingY=" + this.paddingY + ", duration=" + this.duration + ", start=" + this.start + ")";
        }
    }
}

