/*
 * Decompiled with CFR 0.152.
 */
package br.dev.brunoxkk0.advancedtitles.network;

import br.dev.brunoxkk0.advancedtitles.common.Alignment;
import br.dev.brunoxkk0.advancedtitles.common.Title;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class AdvancedTitleMessage
implements IMessage {
    private Title title;

    public AdvancedTitleMessage(Title title) {
        this.title = title;
    }

    public AdvancedTitleMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        Title.TitleBuilder builder = Title.builder();
        builder.alignment(Alignment.fromID(buf.readByte()));
        builder.duration(buf.readInt());
        builder.paddingX(buf.readInt());
        builder.paddingY(buf.readInt());
        int left = buf.readableBytes();
        byte[] buffer = new byte[left];
        buf.readBytes(buffer);
        String lines = new String(buffer, StandardCharsets.UTF_8);
        String[] split = lines.split("\n");
        builder.lines(split);
        builder.start(System.currentTimeMillis());
        this.title = builder.build();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.title.getAlignment().getId());
        int duration = this.title.getDuration() == -1 ? 10 : this.title.getDuration();
        buf.writeInt(duration);
        buf.writeInt(this.title.getPaddingX());
        buf.writeInt(this.title.getPaddingY());
        buf.writeBytes(String.join((CharSequence)"\n", this.title.getLines()).getBytes(StandardCharsets.UTF_8));
    }

    public Title getTitle() {
        return this.title;
    }
}

