/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrowHP;

import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.JRMCoreHC;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HudPlayerHealth
extends Gui {
    private static final ResourceLocation BAR_TEXTURE = new ResourceLocation("crowhpbar", "textures/gui/hud_fundo.png");
    private static final ResourceLocation FILLHP_TEXTURE = new ResourceLocation("crowhpbar", "textures/gui/hp_hud_fill.png");
    private static final ResourceLocation FILLKI_TEXTURE = new ResourceLocation("crowhpbar", "textures/gui/ki_fill.png");
    private static final ResourceLocation FILLSTAMINA_TEXTURE = new ResourceLocation("crowhpbar", "textures/gui/stamina_fill.png");

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        int curBody = JRMCoreH.curBody;
        int maxBody = JRMCoreH.maxBody;
        int curStamina = JRMCoreH.curStamina;
        int maxStamina = JRMCoreH.maxStamina;
        int curEnergy = JRMCoreH.curEnergy;
        int maxEnergy = JRMCoreH.maxEnergy;
        byte curRelease = JRMCoreH.curRelease;
        String bp = JRMCoreH.numSepShort((long)JRMCoreHC.BPC_ME);
        int curTP = JRMCoreH.curTP;
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int x = 5;
        int y = 5;
        float hpPercent = (float)curBody / (float)maxBody;
        float staminaPercent = (float)curStamina / (float)maxStamina;
        float kiPercent = (float)curEnergy / (float)maxEnergy;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        Tessellator tess = Tessellator.field_78398_a;
        int fullBarWidth = 346;
        int fullBarHeight = 122;
        mc.func_110434_K().func_110577_a(BAR_TEXTURE);
        this.drawQuad(tess, 0, 0, fullBarWidth, fullBarHeight, 0.0f, 0.0f, 1.0f, 1.0f);
        mc.func_110434_K().func_110577_a(FILLHP_TEXTURE);
        this.drawBar(tess, hpPercent, 96, 307, fullBarHeight);
        mc.func_110434_K().func_110577_a(FILLKI_TEXTURE);
        this.drawBar(tess, kiPercent, 96, 307, fullBarHeight);
        mc.func_110434_K().func_110577_a(FILLSTAMINA_TEXTURE);
        this.drawBar(tess, staminaPercent, 96, 307, fullBarHeight);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        int scale = 2;
        int textX = x + 96 / scale;
        int hpY = y + 23;
        int kiY = y + 38;
        this.drawText(mc, String.format("HP: %d (%.0f%%)", curBody, Float.valueOf(hpPercent * 100.0f)), textX, hpY, 1.0f);
        this.drawText(mc, String.format("CK: %d", curEnergy), textX, kiY, 1.0f);
        this.drawText(mc, String.format("%d%%", curRelease), 23, 50, 1.0f);
        this.drawText(mc, String.format("BP: %s", bp), textX + 10, 12, 1.0f);
        this.drawText(mc, String.format("TP: %d", curTP), 23, 67, 1.0f);
    }

    private void drawText(Minecraft mc, String text, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        mc.field_71466_p.func_78261_a(text, x, y, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void drawBar(Tessellator tess, float percent, int startX, int endX, int height) {
        int fillWidth = endX - startX;
        int displayedWidth = (int)((float)fillWidth * percent);
        float uStart = (float)startX / 346.0f;
        float uEnd = (float)endX / 346.0f;
        float uvWidth = uEnd - uStart;
        float currentEndU = uStart + uvWidth * percent;
        this.drawQuad(tess, startX, 0, startX + displayedWidth, height, uStart, 0.0f, currentEndU, 1.0f);
    }

    private void drawQuad(Tessellator tess, int x1, int y1, int x2, int y2, float u1, float v1, float u2, float v2) {
        tess.func_78382_b();
        tess.func_78374_a((double)x1, (double)y1, 0.0, (double)u1, (double)v1);
        tess.func_78374_a((double)x1, (double)y2, 0.0, (double)u1, (double)v2);
        tess.func_78374_a((double)x2, (double)y2, 0.0, (double)u2, (double)v2);
        tess.func_78374_a((double)x2, (double)y1, 0.0, (double)u2, (double)v1);
        tess.func_78381_a();
    }
}

