/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultkeys.localconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.defaultkeys.localconfig.LocalConfigEntry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class INIConfigHandler {
    private static final Logger logger = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void backup(PrintWriter writer, List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        String category = "";
        boolean isInQuotes = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            block19: while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    int i = 0;
                    while (i < foundProperty.length) {
                        if (!foundProperty[i] && !entries.get((int)i).not) {
                            logger.warn("Failed to backup local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
                        }
                        ++i;
                    }
                    return;
                }
                StringBuilder buffer = new StringBuilder();
                int i = 0;
                while (true) {
                    if (i >= line.length()) continue block19;
                    char c = line.charAt(i);
                    if (isInQuotes) {
                        if (c == '\"') {
                            isInQuotes = false;
                        }
                        buffer.append(c);
                    } else {
                        switch (c) {
                            case ';': {
                                continue block19;
                            }
                            case '\"': {
                                isInQuotes = true;
                                buffer.append(c);
                                break;
                            }
                            case '[': {
                                buffer = new StringBuilder();
                                break;
                            }
                            case ']': {
                                category = buffer.toString();
                                buffer = new StringBuilder();
                                break;
                            }
                            case '=': {
                                String name = buffer.toString().trim();
                                String value = line.substring(i + 1).trim();
                                int j = 0;
                                while (true) {
                                    if (j >= entries.size()) continue block19;
                                    LocalConfigEntry entry = entries.get(j);
                                    if (entry.passesProperty(category, name, "*")) {
                                        foundProperty[j] = true;
                                        if (entry.containsWildcard()) {
                                            for (LocalConfigEntry notEntry : notEntries) {
                                                if (!notEntry.passesProperty(category, name, "*")) continue;
                                                continue block19;
                                            }
                                        }
                                        writer.println(entry.getIdentifier(entry.file, category, "*", name) + "=" + value);
                                        continue block19;
                                    }
                                    ++j;
                                }
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void restore(List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        File backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak");
        try {
            FileUtils.copyFile((File)configFile, (File)backupFile);
        }
        catch (IOException e) {
            logger.error("Could not create backup file {}: {}", new Object[]{backupFile, e});
        }
        try {
            List lines = FileUtils.readLines((File)configFile);
            try (PrintWriter writer = new PrintWriter(configFile);){
                String category = "";
                boolean isInQuotes = false;
                for (String line : lines) {
                    StringBuilder buffer = new StringBuilder();
                    block24: for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (isInQuotes) {
                            if (c == '\"') {
                                isInQuotes = false;
                            }
                            buffer.append(c);
                            continue;
                        }
                        switch (c) {
                            case ';': {
                                break block24;
                            }
                            case '\"': {
                                isInQuotes = true;
                                buffer.append(c);
                                continue block24;
                            }
                            case '[': {
                                buffer = new StringBuilder();
                                continue block24;
                            }
                            case ']': {
                                category = buffer.toString();
                                buffer = new StringBuilder();
                                continue block24;
                            }
                            case '=': {
                                String name = buffer.toString().trim();
                                for (int j = 0; j < entries.size(); ++j) {
                                    LocalConfigEntry entry = entries.get(j);
                                    if (!entry.passesProperty(category, name, "*")) continue;
                                    foundProperty[j] = true;
                                    if (entry.containsWildcard()) {
                                        for (LocalConfigEntry notEntry : notEntries) {
                                            if (!notEntry.passesProperty(category, name, "*")) continue;
                                            break block24;
                                        }
                                    }
                                    line = line.substring(0, i) + "=" + entry.value;
                                    break block24;
                                }
                                break block24;
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                    writer.println(line);
                }
            }
            for (int i = 0; i < foundProperty.length; ++i) {
                if (foundProperty[i] || entries.get((int)i).not) continue;
                logger.warn("Failed to restore local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
            }
        }
        catch (IOException e) {
            logger.error("Failed to restore local values in {}: {}", new Object[]{configFile, e});
            try {
                FileUtils.copyFile((File)backupFile, (File)configFile);
            }
            catch (IOException e2) {
                logger.error("Could not restore config file {} from backup: {}", new Object[]{configFile, e2});
            }
        }
    }
}

