/*
 * Decompiled with CFR 0.152.
 */
package br.dev.brunoxkk0.narutomoves.extensions;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerDataHandler {
    private static final PlayerDataHandler INSTANCE = new PlayerDataHandler();
    private final Map<String, IExtendedPropertyInitializer<?>> REGISTRATIONS = new HashMap();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void registerProperty(String identifier, IExtendedPropertyInitializer<?> initializer) {
        PlayerDataHandler.INSTANCE.REGISTRATIONS.put(identifier, initializer);
    }

    private PlayerDataHandler() {
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing e) {
        if (e.entity.field_70170_p != null && e.entity instanceof EntityPlayer) {
            for (Map.Entry<String, IExtendedPropertyInitializer<?>> entry : this.REGISTRATIONS.entrySet()) {
                if (e.entity.registerExtendedProperties(entry.getKey(), entry.getValue().createNew(e.entity)).equals(entry.getKey())) continue;
                throw new IllegalStateException("Could not register extended player properties, likely due to the properties already being registered by another mod!");
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone e) {
        for (Map.Entry<String, IExtendedPropertyInitializer<?>> entry : this.REGISTRATIONS.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            e.original.getExtendedProperties(entry.getKey()).saveNBTData(tag);
            e.entityPlayer.getExtendedProperties(entry.getKey()).loadNBTData(tag);
        }
    }

    public static interface IExtendedPropertyInitializer<T extends IExtendedEntityProperties> {
        public T createNew(Entity var1);
    }
}

