/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.glyphs;

import io.github.cruciblemc.necrotempus.utils.MathUtils;
import net.minecraft.util.ResourceLocation;

public class CustomGlyphs {
    private final char target;
    private final ResourceLocation resource;
    private final int horizontalPadding;
    private final int verticalPadding;
    private final int width;
    private final int height;
    private int charWidth = -1;
    private FitMode fitMode = FitMode.NONE;

    public int getFinalCharacterWidth() {
        if (this.charWidth >= 0) {
            return this.charWidth;
        }
        if (this.fitMode == FitMode.CONTAINS) {
            return 10;
        }
        if (this.fitMode == FitMode.VERTICALLY) {
            return (int)Math.ceil(MathUtils.calculateWidth(this.width, this.height, 9.0f)) + 1;
        }
        return this.width;
    }

    public CustomGlyphs(char target, ResourceLocation resource, int horizontalPadding, int verticalPadding, int width, int height) {
        this.target = target;
        this.resource = resource;
        this.horizontalPadding = horizontalPadding;
        this.verticalPadding = verticalPadding;
        this.width = width;
        this.height = height;
    }

    public char getTarget() {
        return this.target;
    }

    public ResourceLocation getResource() {
        return this.resource;
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public FitMode getFitMode() {
        return this.fitMode;
    }

    public void setCharWidth(int charWidth) {
        this.charWidth = charWidth;
    }

    public void setFitMode(FitMode fitMode) {
        this.fitMode = fitMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomGlyphs)) {
            return false;
        }
        CustomGlyphs other = (CustomGlyphs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTarget() != other.getTarget()) {
            return false;
        }
        if (this.getHorizontalPadding() != other.getHorizontalPadding()) {
            return false;
        }
        if (this.getVerticalPadding() != other.getVerticalPadding()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getCharWidth() != other.getCharWidth()) {
            return false;
        }
        ResourceLocation this$resource = this.getResource();
        ResourceLocation other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        FitMode this$fitMode = this.getFitMode();
        FitMode other$fitMode = other.getFitMode();
        return !(this$fitMode == null ? other$fitMode != null : !((Object)((Object)this$fitMode)).equals((Object)other$fitMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomGlyphs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTarget();
        result = result * 59 + this.getHorizontalPadding();
        result = result * 59 + this.getVerticalPadding();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getCharWidth();
        ResourceLocation $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        FitMode $fitMode = this.getFitMode();
        result = result * 59 + ($fitMode == null ? 43 : ((Object)((Object)$fitMode)).hashCode());
        return result;
    }

    public String toString() {
        return "CustomGlyphs(target=" + this.getTarget() + ", resource=" + this.getResource() + ", horizontalPadding=" + this.getHorizontalPadding() + ", verticalPadding=" + this.getVerticalPadding() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", charWidth=" + this.getCharWidth() + ", fitMode=" + (Object)((Object)this.getFitMode()) + ")";
    }

    public static enum FitMode {
        NONE,
        VERTICALLY,
        CONTAINS;


        public static FitMode parse(String string) {
            if (string == null) {
                return NONE;
            }
            for (FitMode el : FitMode.values()) {
                if (!el.name().equalsIgnoreCase(string)) continue;
                return el;
            }
            return NONE;
        }
    }
}

