/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.modernfonts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.cruciblemc.necrotempus.NecroTempus;
import io.github.cruciblemc.necrotempus.NecroTempusConfig;
import io.github.cruciblemc.necrotempus.modules.features.modernfonts.ModernFontEntry;
import io.github.cruciblemc.necrotempus.modules.features.modernfonts.ModernFontProcessor;
import io.github.cruciblemc.necrotempus.shadow.it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class ModernFontSupport
implements IResourceManagerReloadListener {
    private static Char2ObjectArrayMap<ModernFontEntry> MODERN_FONT_CHARACTERS = new Char2ObjectArrayMap();

    public static void init() {
        if (!NecroTempusConfig.modernFonts) {
            return;
        }
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new ModernFontSupport());
    }

    public static ModernFontEntry getCandidate(char character) {
        return MODERN_FONT_CHARACTERS.get(character);
    }

    public static boolean hasCandidate(char character) {
        return MODERN_FONT_CHARACTERS.containsKey(character);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        Char2ObjectArrayMap<ModernFontEntry> fontMap = new Char2ObjectArrayMap<ModernFontEntry>();
        Logger logger = NecroTempus.getInstance().getLogger();
        JsonParser jsonParser = new JsonParser();
        for (Object domain : resourceManager.func_135055_a()) {
            if (!(domain instanceof String)) continue;
            String dom = (String)domain;
            try {
                IResource resourceFile = resourceManager.func_110536_a(new ResourceLocation(dom, "glyphs/modern_fonts.json"));
                JsonElement jsonElement = jsonParser.parse((Reader)new InputStreamReader(resourceFile.func_110527_b()));
                JsonArray providers = jsonElement.getAsJsonObject().getAsJsonArray("providers");
                if (providers.size() == 0) {
                    logger.info("Resource domain ({}) has modern_fonts.json file, but this file is empty.", new Object[]{domain});
                    continue;
                }
                int loaded = 0;
                for (JsonElement entry : providers) {
                    JsonObject jsonObject = entry.getAsJsonObject();
                    String resource = jsonObject.get("file").getAsString();
                    JsonArray chars = jsonObject.get("chars").getAsJsonArray();
                    int height = 8;
                    int ascent = 7;
                    if (jsonObject.has("height")) {
                        height = jsonObject.get("height").getAsInt();
                    }
                    if (jsonObject.has("ascent")) {
                        ascent = jsonObject.get("ascent").getAsInt();
                    }
                    int[][] data = new int[chars.size()][];
                    for (int i = 0; i < chars.size(); ++i) {
                        data[i] = chars.get(i).getAsString().codePoints().toArray();
                    }
                    ModernFontProcessor.process(fontMap, resource, data, height, ascent);
                    ++loaded;
                }
                logger.info("Resource domain ({}) has modern_fonts.json file, registered {} elements.", new Object[]{domain, loaded});
            }
            catch (Exception exception) {}
        }
        MODERN_FONT_CHARACTERS = fontMap;
        logger.info("ModernFont have {} unique characters registered.", new Object[]{MODERN_FONT_CHARACTERS.size()});
    }
}

