/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.modern;

import kamkeel.npcdbc.client.modern.ModernGLHelper;
import kamkeel.npcdbc.client.shader.IShaderUniform;
import kamkeel.npcdbc.client.shader.ShaderHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public class ModernModel {
    public int VAO;
    public int VBO;
    public int EBO;
    public int indexCount;

    public ModernModel(int VAO, int VBO, int EBO, int indexCount) {
        this.VAO = VAO;
        this.VBO = VBO;
        this.EBO = EBO;
        this.indexCount = indexCount;
    }

    public void bind() {
        GL30.glBindVertexArray((int)this.VAO);
    }

    public void unbind() {
        GL30.glBindVertexArray((int)0);
    }

    public void render(int shaderProgram, IShaderUniform uniforms) {
        try {
            this.bind();
            ShaderHelper.useShader(shaderProgram, uniforms);
            ShaderHelper.uniformMatrix4x4("modelView", ShaderHelper.getModelView());
            ShaderHelper.uniformMatrix4x4("projection", ShaderHelper.getProjection());
            GL11.glDrawElements((int)4, (int)this.indexCount, (int)5125, (long)0L);
            ShaderHelper.releaseShader();
            this.unbind();
        }
        catch (Exception e) {
            e.printStackTrace();
            ModernGLHelper.drawWorkingQuad();
        }
    }

    public void destroy() {
        GL15.glDeleteBuffers((int)this.EBO);
        GL15.glDeleteBuffers((int)this.VBO);
        GL30.glDeleteVertexArrays((int)this.VAO);
    }
}

