/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.aura;

import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.api.aura.IAuraDisplay;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.aura.AuraDisplay;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.scripted.NpcAPI;

public class Aura
implements IAura {
    public int id = -1;
    public String name = "";
    public String menuName = "\u00a7aNEW";
    public int secondaryAuraID = -1;
    public AuraDisplay display = new AuraDisplay(this);

    public Aura() {
    }

    public Aura(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("menuName", this.menuName);
        compound.func_74768_a("secondaryAuraID", this.secondaryAuraID);
        this.display.writeToNBT(compound);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("ID")) {
            this.id = compound.func_74762_e("ID");
        } else if (AnimationController.Instance != null) {
            this.id = FormController.Instance.getUnusedId();
        }
        this.name = compound.func_74779_i("name");
        this.menuName = compound.func_74779_i("menuName");
        if (!compound.func_74764_b("secondaryAuraID")) {
            compound.func_74768_a("secondaryAuraID", -1);
        }
        this.secondaryAuraID = compound.func_74762_e("secondaryAuraID");
        this.display.readFromNBT(compound);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMenuName() {
        return this.menuName;
    }

    @Override
    public void setMenuName(String name) {
        if (name.contains("&")) {
            name = name.replace("&", "\u00a7");
        }
        this.menuName = name;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int newID) {
        this.id = newID;
    }

    @Override
    public void assignToPlayer(IPlayer player) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo((EntityPlayer)player.getMCEntity());
        formData.addAura(this);
        formData.updateClient();
    }

    @Override
    public void assignToPlayer(String playerName) {
        this.assignToPlayer(NpcAPI.Instance().getPlayer(playerName));
    }

    @Override
    public void removeFromPlayer(IPlayer player) {
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo((EntityPlayer)player.getMCEntity());
        formData.removeAura(this);
        if (formData.selectedAura == this.id) {
            formData.selectedAura = -1;
        }
        formData.updateClient();
    }

    @Override
    public void removeFromPlayer(String playerName) {
        this.removeFromPlayer(NpcAPI.Instance().getPlayer(playerName));
    }

    @Override
    public IAuraDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getSecondaryAuraID() {
        return this.secondaryAuraID;
    }

    public Aura getSecondaryAur() {
        if (AuraController.Instance.has(this.secondaryAuraID)) {
            return (Aura)AuraController.Instance.get(this.secondaryAuraID);
        }
        return null;
    }

    @Override
    public IAura getSecondaryAura() {
        if (AuraController.Instance.has(this.secondaryAuraID)) {
            return AuraController.Instance.get(this.id);
        }
        return null;
    }

    @Override
    public void setSecondaryAura(int id) {
        Aura secondaryAura = (Aura)AuraController.Instance.get(id);
        this.secondaryAuraID = secondaryAura != null && secondaryAura.secondaryAuraID != this.id ? id : -1;
    }

    @Override
    public void setSecondaryAura(IAura aura) {
        int id = aura == null ? -1 : aura.getID();
        this.setSecondaryAura(id);
    }

    public boolean hasSecondaryAura() {
        return AuraController.Instance.has(this.secondaryAuraID);
    }

    @Override
    public IAura clone() {
        Aura aura = new Aura();
        aura.readFromNBT(this.writeToNBT());
        aura.id = AuraController.Instance.getUnusedId();
        return aura;
    }

    @Override
    public IAura save() {
        return AuraController.Instance.saveAura(this);
    }
}

