/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kamkeel.npcdbc.data.form.Form;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.controllers.data.MagicEntry;

public class FormMagicData {
    private static final String TAG_FORM_MAGIC = "formMagicData";
    private final Map<Integer, MagicEntry> magics = new HashMap<Integer, MagicEntry>();
    private final Form parent;
    public boolean overridePlayerMagic = true;

    public FormMagicData(Form parent) {
        this.parent = parent;
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound list = new NBTTagCompound();
        for (Map.Entry<Integer, MagicEntry> e : this.magics.entrySet()) {
            list.func_74782_a(String.valueOf(e.getKey()), (NBTBase)e.getValue().writeToNBT());
        }
        tag.func_74782_a("Data", (NBTBase)list);
        tag.func_74757_a("Override", this.overridePlayerMagic);
        compound.func_74782_a(TAG_FORM_MAGIC, (NBTBase)tag);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.magics.clear();
        if (!compound.func_74764_b(TAG_FORM_MAGIC)) {
            return;
        }
        NBTTagCompound tag = compound.func_74775_l(TAG_FORM_MAGIC);
        this.overridePlayerMagic = tag.func_74767_n("Override");
        NBTTagCompound data = tag.func_74775_l("Data");
        Set keys = data.func_150296_c();
        for (String k : keys) {
            try {
                int id = Integer.parseInt(k);
                MagicEntry entry = new MagicEntry();
                entry.readToNBT(data.func_74775_l(k));
                this.magics.put(id, entry);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void addMagic(int id, float damage, float split) {
        MagicEntry entry = new MagicEntry();
        entry.damage = damage;
        entry.split = split;
        this.magics.put(id, entry);
    }

    public void removeMagic(int id) {
        this.magics.remove(id);
    }

    public boolean hasMagic(int id) {
        return this.magics.containsKey(id);
    }

    public float getMagicDamage(int id) {
        MagicEntry e = this.magics.get(id);
        return e == null ? 0.0f : e.damage;
    }

    public float getMagicSplit(int id) {
        MagicEntry e = this.magics.get(id);
        return e == null ? 0.0f : e.split;
    }

    public Map<Integer, MagicEntry> getAll() {
        return this.magics;
    }

    public boolean isEmpty() {
        return this.magics.isEmpty();
    }

    public void clear() {
        this.magics.clear();
    }

    public boolean isOverridePlayerMagic() {
        return this.overridePlayerMagic;
    }

    public void setOverridePlayerMagic(boolean overridePlayerMagic) {
        this.overridePlayerMagic = overridePlayerMagic;
    }
}

