/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.items.capsules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kamkeel.npcdbc.config.ConfigCapsules;
import kamkeel.npcdbc.constants.enums.EnumKiCapsules;
import kamkeel.npcdbc.controllers.CapsuleController;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.scripted.DBCEventHooks;
import kamkeel.npcdbc.scripted.DBCPlayerEvent;
import kamkeel.npcdbc.util.PlayerDataUtil;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;

public class ItemKiCapsule
extends Item {
    protected IIcon[] icons;

    public ItemKiCapsule() {
        this.func_77625_d(ConfigCapsules.KiCapsuleMaxStack);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a((CreativeTabs)CustomItems.tabMisc);
    }

    public String func_77667_c(ItemStack stack) {
        int metadata = stack.func_77960_j();
        EnumKiCapsules kicapsules = EnumKiCapsules.values()[metadata];
        return "item.npcdbc:" + kicapsules.getName().toLowerCase() + "_kicapsule";
    }

    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[EnumKiCapsules.count()];
        String prefix = "npcdbc:kicapsules/";
        for (EnumKiCapsules kiCapsule : EnumKiCapsules.values()) {
            this.icons[kiCapsule.getMeta()] = reg.func_94245_a(prefix + kiCapsule.getName().toLowerCase());
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta >= 0 && meta < EnumKiCapsules.count()) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public EnumRarity func_77613_e(ItemStack item) {
        if (item.func_77960_j() == 0 || item.func_77960_j() == 1) {
            return EnumRarity.uncommon;
        }
        if (item.func_77960_j() == 2 || item.func_77960_j() == 3) {
            return EnumRarity.rare;
        }
        return EnumRarity.epic;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumKiCapsules kiCapsules : EnumKiCapsules.values()) {
            list.add(new ItemStack(item, 1, kiCapsules.getMeta()));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        if (world.field_72995_K) {
            return itemStack;
        }
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= EnumKiCapsules.count()) {
            meta = 0;
        }
        EnumKiCapsules kiCapsules = EnumKiCapsules.values()[meta];
        UUID playerUUID = Utility.getUUID((Entity)player);
        long remainingTime = CapsuleController.canUseKiCapsule(playerUUID, meta);
        if (remainingTime > 0L) {
            player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7fCapsule is on cooldown for " + remainingTime + " seconds"));
            return itemStack;
        }
        if (DBCEventHooks.onCapsuleUsedEvent(new DBCPlayerEvent.CapsuleUsedEvent(PlayerDataUtil.getIPlayer(player), 2, meta))) {
            return itemStack;
        }
        int kiRestored = kiCapsules.getStrength();
        DBCData.get((EntityPlayer)player).stats.restoreKiPercent(kiRestored);
        itemStack.func_77979_a(1);
        if (itemStack.field_77994_a <= 0) {
            player.func_71028_bD();
        }
        CapsuleController.setKiCapsule(playerUUID, meta);
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= EnumKiCapsules.count()) {
            meta = 0;
        }
        HashMap<Integer, Integer> kiStrength = CapsuleController.Instance.capsuleStrength.get(2);
        HashMap<Integer, Integer> kiCooldown = CapsuleController.Instance.capsuleCooldowns.get(2);
        par3List.add(StatCollector.func_74837_a((String)"capsule.restore", (Object[])new Object[]{kiStrength.get(meta) + "%", StatCollector.func_74838_a((String)"capsule.ki")}));
        par3List.add(StatCollector.func_74837_a((String)"capsule.cooldown", (Object[])new Object[]{kiCooldown.get(meta)}));
    }
}

