/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.config.ConfigDBCClient;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcdbc.util.Utility;
import kamkeel.npcs.util.ByteBufUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public final class SendChat
extends AbstractPacket {
    public static final String packetName = "NPC|SendChat";
    private int dataCount;
    private Object[] data;
    private boolean info;

    public SendChat() {
    }

    public SendChat(Object ... data) {
        this.dataCount = data.length;
        this.data = data;
    }

    public SendChat(boolean info, Object ... data) {
        this.info = info;
        this.dataCount = data.length;
        this.data = data;
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.SendChat;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeBoolean(this.info);
        out.writeInt(this.dataCount);
        for (Object ob : this.data) {
            if (!(ob instanceof String)) {
                throw new IllegalArgumentException("SendChat only accepts strings.");
            }
            ByteBufUtils.writeUTF8String((ByteBuf)out, (String)((String)ob));
        }
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        boolean info = in.readBoolean();
        if (info && ConfigDBCClient.HideInfoMessage) {
            return;
        }
        int stringAmount = in.readInt();
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < stringAmount; ++i) {
            message.append(StatCollector.func_74838_a((String)ByteBufUtils.readUTF8String((ByteBuf)in)));
        }
        Utility.sendMessage((Entity)player, message.toString());
    }
}

