/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kamkeel.npcdbc.client.sound.ClientSound;
import kamkeel.npcdbc.data.SoundSource;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class Utility {
    public static HashMap<String, String> darkCodes = new HashMap();

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public static boolean isServer(Entity entity) {
        return entity != null && Utility.isServer(entity.field_70170_p);
    }

    public static boolean isServer(World worldObj) {
        return worldObj != null && !worldObj.field_72995_K;
    }

    public static void sendMessage(Entity entity, String message) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    public static String getEntityID(Entity p) {
        if (p instanceof EntityPlayer) {
            return Utility.getUUID(p).toString() + ",true";
        }
        if (p != null) {
            return p.func_145782_y() + ",false";
        }
        return "";
    }

    public static Entity getEntityFromID(World w, String id) {
        if (id != null && !id.isEmpty()) {
            try {
                if (Boolean.parseBoolean(id.split(",")[1])) {
                    return Utility.getFromUUID(UUID.fromString(id.split(",")[0]), w);
                }
                return w.func_73045_a(Integer.parseInt(id.split(",")[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static World getWorld(int dimensionID) {
        if (Utility.isServer()) {
            return DimensionManager.getWorld((int)dimensionID);
        }
        return Utility.getClientWorld();
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static UUID getUUID(Entity entity) {
        return entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_146103_bH().getId() : entity.func_110124_au();
    }

    public static Entity getFromUUID(UUID id, World w) {
        List allEntity = w.field_72996_f;
        for (Entity entity : allEntity) {
            if (!(entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_146103_bH().getId().equals(id) : entity.func_110124_au().equals(id))) continue;
            return entity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static Entity getFromNameClient(String name) {
        return Utility.getFromName(name, (World)Minecraft.func_71410_x().field_71441_e);
    }

    public static Entity getFromName(String name, World w) {
        List allEntity = w.field_72996_f;
        for (Entity entity : allEntity) {
            if (!entity.func_70005_c_().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public static void printStackTrace() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            System.out.println(ste);
        }
    }

    public static boolean stackTraceContains(String text) {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!ste.toString().toLowerCase().contains(text.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static double percent(double n, double perc) {
        return n / 100.0 * perc;
    }

    public static float percent(int n, float perc) {
        return (float)(n / 100) * perc;
    }

    public static boolean percentBetween(double n, double maxN, double minPerc, double maxPerc) {
        return n >= Utility.percent(maxN, minPerc) && n < Utility.percent(maxN, maxPerc);
    }

    public static String removeBoldColorCode(String s) {
        for (int i = 0; i < s.length() - 2; ++i) {
            if (s.charAt(i) != '\u00a7' || s.charAt(i + 1) != 'l') continue;
            return s.substring(0, i) + s.substring(i + 2);
        }
        return s;
    }

    public static String removeColorCodes(String s) {
        StringBuilder sb = new StringBuilder();
        boolean skipNext = false;
        for (int i = 0; i < s.length(); ++i) {
            char code;
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (s.charAt(i) == '\u00a7' && i + 1 < s.length() && (Character.isDigit(code = s.charAt(i + 1)) || "abcdefklmnor".indexOf(code) != -1)) {
                skipNext = true;
                continue;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String getDarkColorCode(String s) {
        if (darkCodes.isEmpty()) {
            darkCodes.put("\u00a7a", "\u00a72");
            darkCodes.put("\u00a7b", "\u00a79");
            darkCodes.put("\u00a7c", "\u00a7c");
            darkCodes.put("\u00a7e", "\u00a76");
            darkCodes.put("\u00a77", "\u00a78");
            darkCodes.put("\u00a7d", "\u00a75");
            darkCodes.put("\u00a7f", "\u00a70");
        }
        if (darkCodes.containsKey(s)) {
            return darkCodes.get(s);
        }
        return s;
    }

    public static Field getPrivateField(Class<?> c, String name) {
        try {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                if (!f.getName().equals(name)) continue;
                f.setAccessible(true);
                return f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getPFValue(Class<?> c, String name, Object instance) {
        try {
            Field f = Utility.getPrivateField(c, name);
            Utility.removeFinalModif(f);
            return f.get(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void removeFinalModif(Field f) {
        try {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setPrivateField(Class<?> c, String name, boolean isFinal, Object instance, Object newValUtilitye) {
        if (instance == null) {
            return;
        }
        try {
            Field f = Utility.getPrivateField(c, name);
            if (isFinal) {
                Utility.removeFinalModif(f);
            }
            f.set(instance, newValUtilitye);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(String directory, Entity entity, boolean all) {
        new ClientSound(new SoundSource(directory, entity)).play(all);
    }
}

