/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.gconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.cruciblemc.omniconfig.api.OmniconfigAPI;
import io.github.cruciblemc.omniconfig.api.annotation.AnnotationConfig;
import io.github.cruciblemc.omniconfig.api.annotation.ConfigLoadCallback;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigBoolean;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigClassSet;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigDouble;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigEnum;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigFloat;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigInt;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigString;
import io.github.cruciblemc.omniconfig.api.annotation.properties.ConfigStringCollection;
import io.github.cruciblemc.omniconfig.api.builders.IBooleanPropertyBuilder;
import io.github.cruciblemc.omniconfig.api.builders.IDoublePropertyBuilder;
import io.github.cruciblemc.omniconfig.api.builders.IFloatPropertyBuilder;
import io.github.cruciblemc.omniconfig.api.builders.IIntegerPropertyBuilder;
import io.github.cruciblemc.omniconfig.api.builders.IOmniconfigBuilder;
import io.github.cruciblemc.omniconfig.api.builders.IStringListPropertyBuilder;
import io.github.cruciblemc.omniconfig.api.builders.IStringPropertyBuilder;
import io.github.cruciblemc.omniconfig.api.core.IOmniconfig;
import io.github.cruciblemc.omniconfig.api.lib.ClassSet;
import io.github.cruciblemc.omniconfig.api.lib.Version;
import io.github.cruciblemc.omniconfig.core.properties.EnumParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationConfigReader {
    private static final String PACKAGE_DEFAULT = "default";
    private final Class<?> configClass;
    private final Map<Field, Annotation> annotatedFields = new HashMap<Field, Annotation>();
    private final Map<Method, ConfigLoadCallback.Stage> loadingCallbacks = new HashMap<Method, ConfigLoadCallback.Stage>();

    protected AnnotationConfigReader(Class<?> configClass) {
        this.configClass = configClass;
    }

    public IOmniconfig read() {
        AnnotationConfig annotation = this.configClass.getAnnotation(AnnotationConfig.class);
        Objects.requireNonNull(annotation, "Annotaion " + AnnotationConfig.class.getName() + " not found for class " + this.configClass.getName());
        String cfgName = annotation.name();
        if (Strings.isNullOrEmpty((String)cfgName)) {
            cfgName = this.configClass.getSimpleName();
        }
        this.parseAnnotations();
        IOmniconfigBuilder wrapper = OmniconfigAPI.configBuilder(cfgName, new Version(annotation.version()), annotation.sided());
        this.getLoadingCallbacks(ConfigLoadCallback.Stage.BEFORE_INIT).stream().forEach(method -> this.tryInvoke((Method)method, wrapper));
        wrapper.versioningPolicy(annotation.policy());
        wrapper.terminateNonInvokedKeys(annotation.terminateNonInvokedKeys());
        wrapper.loadFile();
        this.getLoadingCallbacks(ConfigLoadCallback.Stage.AFTER_INIT).stream().forEach(method -> this.tryInvoke((Method)method, wrapper));
        this.loadFieldValues(wrapper);
        this.getLoadingCallbacks(ConfigLoadCallback.Stage.BEFORE_FINALIZATION).stream().forEach(method -> this.tryInvoke((Method)method, wrapper));
        if (annotation.reloadable()) {
            wrapper.setReloadable();
        }
        return wrapper.build();
    }

    protected void loadFieldValues(IOmniconfigBuilder wrapper) {
        for (Map.Entry<Field, Annotation> entry : this.annotatedFields.entrySet()) {
            String name;
            Annotation configAnnotation;
            Field field = entry.getKey();
            Annotation annotation = entry.getValue();
            Class<? extends Annotation> type = annotation.annotationType();
            String rawName = field.getName();
            String fieldName = rawName.substring(0, 1).toUpperCase() + rawName.substring(1);
            if (type == ConfigBoolean.class) {
                this.checkType(field, Boolean.TYPE);
                this.checkFinal(field);
                configAnnotation = (ConfigBoolean)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                boolean defaultValue = this.tryGetBoolean(field);
                ((IBooleanPropertyBuilder)((IBooleanPropertyBuilder)((IBooleanPropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getBoolean(name, defaultValue).sync(configAnnotation.sync())).comment(configAnnotation.comment())).uponLoad(value -> this.trySetBoolean(field, value.getValue()))).build();
                continue;
            }
            if (type == ConfigFloat.class) {
                this.checkType(field, Float.TYPE);
                this.checkFinal(field);
                configAnnotation = (ConfigFloat)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                float defaultValue = this.tryGetFloat(field);
                ((IFloatPropertyBuilder)((IFloatPropertyBuilder)((IFloatPropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getFloat(name, defaultValue).sync(configAnnotation.sync())).comment(configAnnotation.comment())).min(configAnnotation.min()).max(configAnnotation.max()).uponLoad(value -> this.trySetFloat(field, value.getValue()))).build();
                continue;
            }
            if (type == ConfigDouble.class) {
                this.checkType(field, Double.TYPE);
                this.checkFinal(field);
                configAnnotation = (ConfigDouble)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                double defaultValue = this.tryGetDouble(field);
                ((IDoublePropertyBuilder)((IDoublePropertyBuilder)((IDoublePropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getDouble(name, defaultValue).sync(configAnnotation.sync())).comment(configAnnotation.comment())).min(configAnnotation.min()).max(configAnnotation.max()).uponLoad(value -> this.trySetDouble(field, value.getValue()))).build();
                continue;
            }
            if (type == ConfigInt.class) {
                this.checkType(field, Integer.TYPE);
                this.checkFinal(field);
                configAnnotation = (ConfigInt)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                int defaultValue = this.tryGetInt(field);
                ((IIntegerPropertyBuilder)((IIntegerPropertyBuilder)((IIntegerPropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getInteger(name, defaultValue).sync(configAnnotation.sync())).comment(configAnnotation.comment())).min(configAnnotation.min()).max(configAnnotation.max()).uponLoad(value -> this.trySetInt(field, value.getValue()))).build();
                continue;
            }
            if (type == ConfigString.class) {
                this.checkType(field, String.class);
                this.checkFinal(field);
                configAnnotation = (ConfigString)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                String defaultValue = this.tryGetString(field);
                ((IStringPropertyBuilder)((IStringPropertyBuilder)((IStringPropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getString(name, defaultValue).sync(configAnnotation.sync())).comment(configAnnotation.comment())).uponLoad(value -> this.trySetString(field, value.getValue()))).build();
                continue;
            }
            if (type == ConfigClassSet.class) {
                this.checkType(field, ClassSet.class);
                configAnnotation = (ConfigClassSet)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                ClassSet classSet = (ClassSet)this.tryGetValue(field);
                Objects.requireNonNull(classSet, field + " value must not be null");
                ((IStringListPropertyBuilder)((IStringListPropertyBuilder)((IStringListPropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getStringList(name, classSet.getRaw().toArray(new String[0])).sync(configAnnotation.sync())).comment(configAnnotation.comment())).uponLoad(value -> {
                    classSet.clear();
                    classSet.addRaw(value.getValue());
                })).build();
                continue;
            }
            if (type == ConfigEnum.class) {
                this.checkType(field, Enum.class);
                this.checkFinal(field);
                configAnnotation = (ConfigEnum)annotation;
                name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
                Enum defaultValue = (Enum)this.tryGetValue(field);
                Objects.requireNonNull(defaultValue, field + " value must not be null");
                this.forceCategories(wrapper, configAnnotation.category()).getEnum(name, defaultValue).sync(configAnnotation.sync()).comment(configAnnotation.comment()).uponLoad(value -> this.trySetValue(field, ((EnumParameter)value).getValue())).build();
                continue;
            }
            if (type != ConfigStringCollection.class) continue;
            this.checkType(field, Collection.class);
            configAnnotation = (ConfigStringCollection)annotation;
            name = configAnnotation.name().isEmpty() ? fieldName : configAnnotation.name();
            Collection collection = (Collection)this.tryGetValue(field);
            Objects.requireNonNull(collection, field + " value must not be null");
            ((IStringListPropertyBuilder)((IStringListPropertyBuilder)((IStringListPropertyBuilder)this.forceCategories(wrapper, configAnnotation.category()).getStringList(name, collection.toArray(new String[0])).sync(configAnnotation.sync())).comment(configAnnotation.comment())).uponLoad(value -> {
                try {
                    collection.clear();
                    for (String string : value.getValue()) {
                        collection.add(string);
                    }
                }
                catch (UnsupportedOperationException ex) {
                    throw new IllegalStateException("List \"" + rawName + "\" annoted with @ConfigStringCollection in class " + this.configClass + " does not support modification operations!", ex);
                }
            })).build();
        }
    }

    protected void parseAnnotations() {
        Class<? extends Annotation> type;
        for (Field field : this.configClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            for (Annotation declaredAnnotation : field.getDeclaredAnnotations()) {
                type = declaredAnnotation.annotationType();
                if (type != ConfigBoolean.class && type != ConfigClassSet.class && type != ConfigEnum.class && type != ConfigFloat.class && type != ConfigInt.class && type != ConfigString.class && type != ConfigStringCollection.class && type != ConfigDouble.class) continue;
                if (!this.annotatedFields.containsKey(field)) {
                    this.annotatedFields.put(field, declaredAnnotation);
                    continue;
                }
                throw new IllegalArgumentException("Field " + field.getName() + " in annotation config " + this.configClass + " has more than one @Config[Value] annotation!");
            }
        }
        for (AccessibleObject accessibleObject : this.configClass.getDeclaredMethods()) {
            if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            ((Method)accessibleObject).setAccessible(true);
            for (Annotation declaredAnnotation : ((Method)accessibleObject).getDeclaredAnnotations()) {
                type = declaredAnnotation.annotationType();
                if (type != ConfigLoadCallback.class) continue;
                if (((Method)accessibleObject).getParameterCount() == 1 && ((Method)accessibleObject).getParameterTypes()[0] == IOmniconfigBuilder.class) {
                    ConfigLoadCallback annotation = (ConfigLoadCallback)declaredAnnotation;
                    this.loadingCallbacks.put((Method)accessibleObject, annotation.value());
                    continue;
                }
                throw new IllegalArgumentException("Method " + ((Method)accessibleObject).getName() + " in annotation config " + this.configClass + " is annotated with @ConfigLoadCallback and thus must accept single IOmniconfigBuilder argument, but does not!");
            }
        }
    }

    private void tryInvoke(Method method, IOmniconfigBuilder builder) {
        try {
            method.invoke(null, builder);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<Method> getLoadingCallbacks(ConfigLoadCallback.Stage stage) {
        return this.loadingCallbacks.entrySet().stream().filter(entry -> entry.getValue() == stage).collect(ArrayList::new, (list, entry) -> list.add(entry.getKey()), ArrayList::addAll);
    }

    private IOmniconfigBuilder forceCategories(IOmniconfigBuilder builder, String categories) {
        builder.resetCategory();
        String[] array = categories.contains("$") ? categories.split("\\$") : new String[]{categories};
        for (String str : array) {
            builder.pushCategory(str);
        }
        return builder;
    }

    private void checkType(@NotNull Field field, @NotNull Class<?> expectedType) {
        Class<?> type = field.getType();
        Preconditions.checkArgument((expectedType == type || expectedType.isAssignableFrom(type) ? 1 : 0) != 0, (Object)(field + " type must be " + expectedType + " ( real type is " + type + ')'));
    }

    private void checkFinal(@NotNull Field field) {
        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @NotNull
    private String getPackageName(@Nullable String className) {
        if (Strings.isNullOrEmpty((String)className)) {
            return PACKAGE_DEFAULT;
        }
        int classDelimeterIndex = className.lastIndexOf(46);
        if (classDelimeterIndex == -1) {
            return PACKAGE_DEFAULT;
        }
        String packageName = className.substring(0, classDelimeterIndex);
        if (Strings.isNullOrEmpty((String)packageName)) {
            return PACKAGE_DEFAULT;
        }
        int packageDelimeterIndex = packageName.lastIndexOf(46);
        if (packageDelimeterIndex == -1) {
            return packageName;
        }
        String simplePackageName = packageName.substring(packageDelimeterIndex + 1);
        return Strings.isNullOrEmpty((String)simplePackageName) ? PACKAGE_DEFAULT : simplePackageName;
    }

    protected void trySetValue(Field field, Object value) {
        try {
            field.set(null, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Object tryGetValue(Field field) {
        try {
            return field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void trySetString(Field field, String String2) {
        try {
            field.set(null, String2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String tryGetString(Field field) {
        try {
            return (String)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void trySetBoolean(Field field, boolean Boolean2) {
        try {
            field.set(null, Boolean2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean tryGetBoolean(Field field) {
        try {
            return field.getBoolean(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void trySetFloat(Field field, float Float2) {
        try {
            field.set(null, Float.valueOf(Float2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected float tryGetFloat(Field field) {
        try {
            return field.getFloat(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    protected void trySetDouble(Field field, double Double2) {
        try {
            field.set(null, Double2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected double tryGetDouble(Field field) {
        try {
            return field.getDouble(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    protected void trySetInt(Field field, int Int) {
        try {
            field.set(null, Int);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int tryGetInt(Field field) {
        try {
            return field.getInt(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

