/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.mc1_7_10.handlers;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.github.cruciblemc.omniconfig.api.OmniconfigAPI;
import io.github.cruciblemc.omniconfig.api.lib.Environment;
import io.github.cruciblemc.omniconfig.core.AbstractPacketDispatcher;
import io.github.cruciblemc.omniconfig.core.Omniconfig;
import io.github.cruciblemc.omniconfig.core.SynchronizationManager;
import io.github.cruciblemc.omniconfig.mc1_7_10.OmniconfigMod;
import io.github.cruciblemc.omniconfig.mc1_7_10.network.PacketSyncOmniconfig;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class OmniPacketDispatcher
extends AbstractPacketDispatcher<ByteBuf, OmniPlayerMP> {
    public static final OmniPacketDispatcher INSTANCE = new OmniPacketDispatcher();

    private OmniPacketDispatcher() {
        SynchronizationManager.setPacketDispatcher(this);
    }

    public OmniBufferIO getBufferIO(ByteBuf buffer) {
        return new OmniBufferIO(buffer);
    }

    public OmniServer getServer() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server != null && server.func_71203_ab() != null ? new OmniServer(server) : null;
    }

    public static class OmniBufferIO
    extends AbstractPacketDispatcher.AbstractBufferIO<ByteBuf> {
        protected OmniBufferIO(ByteBuf buffer) {
            super(buffer);
        }

        @Override
        public void writeString(String string, int charLimit) {
            if (string != null && string.length() > 0 && string.length() <= charLimit) {
                byte[] bytes = string.getBytes(Charsets.UTF_8);
                ((ByteBuf)this.buffer).writeShort(bytes.length);
                ((ByteBuf)this.buffer).writeBytes(bytes);
            } else if (string != null && string.length() >= charLimit) {
                Throwables.propagate((Throwable)new IOException("Encoded string size " + string.length() + " is larger than allowed maximum " + charLimit));
            } else {
                ((ByteBuf)this.buffer).writeShort(-1);
            }
        }

        @Override
        public void writeLong(long value) {
            ((ByteBuf)this.buffer).writeLong(value);
        }

        @Override
        public void writeInt(int value) {
            ((ByteBuf)this.buffer).writeInt(value);
        }

        @Override
        public void writeDouble(double value) {
            ((ByteBuf)this.buffer).writeDouble(value);
        }

        @Override
        public void writeFloat(float value) {
            ((ByteBuf)this.buffer).writeFloat(value);
        }

        @Override
        public String readString(int charLimit) {
            short size = ((ByteBuf)this.buffer).readShort();
            if (size < 0) {
                return "null";
            }
            byte[] strBytes = new byte[size];
            ((ByteBuf)this.buffer).readBytes(strBytes);
            String str = new String(strBytes, Charsets.UTF_8);
            if (str.length() <= charLimit) {
                return str;
            }
            Throwables.propagate((Throwable)new IOException("Received string size " + str.length() + " is larger than allowed maximum " + charLimit));
            return "null";
        }

        @Override
        public long readLong() {
            return ((ByteBuf)this.buffer).readLong();
        }

        @Override
        public int readInt() {
            return ((ByteBuf)this.buffer).readInt();
        }

        @Override
        public double readDouble() {
            return ((ByteBuf)this.buffer).readDouble();
        }

        @Override
        public float readFloat() {
            return ((ByteBuf)this.buffer).readFloat();
        }
    }

    public static class OmniPlayerMP
    extends AbstractPacketDispatcher.AbstractPlayerMP<EntityPlayerMP> {
        public OmniPlayerMP(EntityPlayerMP player) {
            super(player);
        }

        @Override
        public void sendSyncPacket(Omniconfig wrapper) {
            OmniconfigMod.packetPipeline.sendTo((IMessage)new PacketSyncOmniconfig(wrapper), (EntityPlayerMP)this.player);
        }

        @Override
        public boolean areWeRemoteServer() {
            if (OmniconfigAPI.getEnvironment() == Environment.DEDICATED_SERVER) {
                return true;
            }
            return ((EntityPlayerMP)this.player).field_71133_b != null && !((EntityPlayerMP)this.player).func_146103_bH().getName().equals(((EntityPlayerMP)this.player).field_71133_b.func_71214_G());
        }

        @Override
        public String getProfileName() {
            return ((EntityPlayerMP)this.player).func_146103_bH().getName();
        }
    }

    public static class OmniServer
    extends AbstractPacketDispatcher.AbstractServer<MinecraftServer, OmniPlayerMP> {
        public OmniServer(MinecraftServer server) {
            super(server);
        }

        @Override
        public void forEachPlayer(Consumer<OmniPlayerMP> consumer) {
            ((MinecraftServer)this.server).func_71203_ab().field_72404_b.forEach(player -> {
                if (player instanceof EntityPlayerMP) {
                    consumer.accept(new OmniPlayerMP((EntityPlayerMP)player));
                }
            });
        }
    }
}

