/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.command;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.scripted.DBCAPI;
import kamkeel.npcs.command.CommandKamkeelBase;
import kamkeel.npcs.util.ColorUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class OutlineCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "outline";
    }

    public String getDescription() {
        return "Outline operations";
    }

    @CommandKamkeelBase.SubCommand(desc="Sets a player's active outline by name", usage="<player> <outline_name>")
    public void set(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Outline outline = (Outline)DBCAPI.Instance().getOutline(name);
        if (outline == null) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown outline: " + name));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID != outline.id) {
                dbc.setOutline(outline);
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7ais now active to \u00a77'\u00a7b%s\u00a77'", outline.getName(), playerdata.playername));
                if (sender != playerdata.player) {
                    ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Outline \u00a77%s \u00a7ais now active.", outline.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eactive!", playerdata.playername, outline.getName()));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Sets a player's active outline by numerical id", usage="<player> <outline_ID>")
    public void setid(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int id = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Outline outline = (Outline)OutlineController.getInstance().get(id);
        if (outline == null) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown outline ID: " + id));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID != outline.id) {
                dbc.setOutline(outline);
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7ais now active to \u00a77'\u00a7b%s\u00a77'", outline.getName(), playerdata.playername));
                if (sender != playerdata.player) {
                    ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Outline \u00a77%s \u00a7ais now active.", outline.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eactive!", playerdata.playername, outline.getName()));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a player's active outline", usage="<player>")
    public void remove(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID != -1) {
                Outline outline = dbc.getOutline();
                dbc.setOutline(null);
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7cremoved from \u00a77'\u00a7b%s\u00a77'", outline.getName(), playerdata.playername));
                if (sender != playerdata.player) {
                    ColorUtil.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7cOutline \u00a77%s \u00a7cremoved.", outline.getName()));
                }
            } else {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("\u00a7eNo outline active for \u00a77'\u00a7b%s\u00a77'", playerdata.playername));
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Lists player's active outline", usage="<player>")
    public void info(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            ColorUtil.sendError((ICommandSender)sender, (String)("Unknown player: " + playername));
            return;
        }
        for (PlayerData playerdata : data) {
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID == -1) {
                ColorUtil.sendResult((ICommandSender)sender, (String)String.format("No Outline active for \u00a77'\u00a7b%s\u00a77'", playerdata.playername));
                continue;
            }
            Outline outline = (Outline)OutlineController.Instance.get(dbc.outlineID);
            ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s", outline.getName()));
            ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Lists all existing outlines")
    public void infoall(ICommandSender sender, String[] args) throws CommandException {
        ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
        for (Outline outline : OutlineController.getInstance().customOutlines.values()) {
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("%s", outline.getName()));
        }
        ColorUtil.sendResult((ICommandSender)sender, (String)"--------------------");
    }

    @CommandKamkeelBase.SubCommand(desc="Reloads all outlines")
    public void reload(ICommandSender sender, String[] args) {
        OutlineController.Instance.load();
        ColorUtil.sendResult((ICommandSender)sender, (String)"Outlines reloaded!");
    }

    @CommandKamkeelBase.SubCommand(desc="Find outline id number by its name", usage="<outlineName>")
    public void id(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            ColorUtil.sendError((ICommandSender)sender, (String)"Please provide a name for the outline");
            return;
        }
        String outlineName = String.join((CharSequence)" ", args).toLowerCase();
        Collection<Outline> outlines = OutlineController.getInstance().customOutlines.values();
        int count = 0;
        for (Outline outline : outlines) {
            if (!outline.getName().toLowerCase().contains(outlineName)) continue;
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("Outline \u00a7e%d\u00a77 - \u00a7c'%s'", outline.id, outline.getName()));
            ++count;
        }
        if (count == 0) {
            ColorUtil.sendResult((ICommandSender)sender, (String)String.format("No Outline found with name: \u00a7c'%s'", outlineName));
        }
    }
}

