/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.ForgeEventHandler;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemNbtBook;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketItemUpdate;

public class ScriptPlayerEventHandler {
    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        PlayerData data = PlayerData.get(player);
        if (player.field_70173_aa % 10 == 0) {
            EventHooks.onPlayerTick(data.scriptData);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item.func_190926_b() || item.func_77973_b() != CustomItems.scripted_item) continue;
                ItemScriptedWrapper isw = (ItemScriptedWrapper)NpcAPI.Instance().getIItemStack(item);
                EventHooks.onScriptItemUpdate(isw, player);
                if (!isw.updateClient) continue;
                isw.updateClient = false;
                Packets.send((ServerPlayerEntity)player, new PacketItemUpdate(i, isw.getMCNbt()));
            }
        }
        if (data.playerLevel != player.field_71068_ca) {
            EventHooks.onPlayerLevelUp(data.scriptData, data.playerLevel - player.field_71068_ca);
            data.playerLevel = player.field_71068_ca;
        }
        data.timers.update();
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getHand() != Hand.MAIN_HAND || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getWorld(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerAttack(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((IItemScripted)isw, handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getWorld(), event.getPos()));
            eve.setCanceled(event.isCanceled());
            event.setCanceled(EventHooks.onScriptItemAttack(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getHand() != Hand.MAIN_HAND || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (event.getItemStack().func_77973_b() == CustomItems.nbt_book) {
            ((ItemNbtBook)event.getItemStack().func_77973_b()).blockEvent(event);
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        handler.hadInteract = true;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getWorld(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getWorld(), event.getPos()));
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.EntityInteract event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getHand() != Hand.MAIN_HAND || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (event.getItemStack().func_77973_b() == CustomItems.nbt_book) {
            ((ItemNbtBook)event.getItemStack().func_77973_b()).entityEvent(event);
            event.setCanceled(true);
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(event.getTarget()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(event.getTarget()));
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickItem event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getHand() != Hand.MAIN_HAND || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (event.getPlayer().func_184812_l_() && event.getPlayer().func_213453_ef() && event.getItemStack().func_77973_b() == CustomItems.scripted_item) {
            NoppesUtilServer.sendOpenGui(event.getPlayer(), EnumGuiType.ScriptItem, null);
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        if (handler.hadInteract) {
            handler.hadInteract = false;
            return;
        }
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 0, null);
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
        if (event.getItemStack().func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
            ItemScriptedWrapper isw = ItemScripted.GetWrapper(event.getItemStack());
            ItemEvent.InteractEvent eve = new ItemEvent.InteractEvent(isw, handler.getPlayer(), 0, null);
            event.setCanceled(EventHooks.onScriptItemInteract(isw, eve));
        }
    }

    @SubscribeEvent
    public void invoke(ArrowLooseEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        PlayerEvent.RangedLaunchedEvent ev = new PlayerEvent.RangedLaunchedEvent(handler.getPlayer());
        event.setCanceled(EventHooks.onPlayerRanged(handler, ev));
    }

    @SubscribeEvent
    public void invoke(BlockEvent.BreakEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        PlayerEvent.BreakEvent ev = new PlayerEvent.BreakEvent(handler.getPlayer(), NpcAPI.Instance().getIBlock((World)((ServerWorld)event.getWorld()), event.getPos()), event.getExpToDrop());
        event.setCanceled(EventHooks.onPlayerBreak(handler, ev));
        event.setExpToDrop(ev.exp);
    }

    @SubscribeEvent
    public void invoke(ItemTossEvent event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        event.setCanceled(EventHooks.onPlayerToss(handler, event.getEntityItem()));
    }

    @SubscribeEvent
    public void invoke(EntityItemPickupEvent event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        event.setCanceled(EventHooks.onPlayerPickUp(handler, event.getItem()));
    }

    @SubscribeEvent
    public void invoke(PlayerContainerEvent.Open event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        EventHooks.onPlayerContainerOpen(handler, event.getContainer());
    }

    @SubscribeEvent
    public void invoke(PlayerContainerEvent.Close event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        EventHooks.onPlayerContainerClose(handler, event.getContainer());
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        PlayerScriptData handler;
        if (!(event.getEntityLiving().field_70170_p instanceof ServerWorld)) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (event.getEntityLiving() instanceof PlayerEntity) {
            handler = PlayerData.get((PlayerEntity)((PlayerEntity)event.getEntityLiving())).scriptData;
            EventHooks.onPlayerDeath(handler, event.getSource(), source);
        }
        if (source instanceof PlayerEntity) {
            handler = PlayerData.get((PlayerEntity)((PlayerEntity)source)).scriptData;
            EventHooks.onPlayerKills(handler, event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void invoke(LivingHurtEvent event) {
        PlayerEvent pevent;
        PlayerScriptData handler;
        if (!(event.getEntityLiving().field_70170_p instanceof ServerWorld)) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (event.getEntityLiving() instanceof PlayerEntity) {
            handler = PlayerData.get((PlayerEntity)((PlayerEntity)event.getEntityLiving())).scriptData;
            pevent = new PlayerEvent.DamagedEvent(handler.getPlayer(), source, event.getAmount(), event.getSource());
            event.setCanceled(EventHooks.onPlayerDamaged(handler, pevent));
            event.setAmount(pevent.damage);
        }
        if (source instanceof PlayerEntity) {
            handler = PlayerData.get((PlayerEntity)((PlayerEntity)source)).scriptData;
            pevent = new PlayerEvent.DamagedEntityEvent(handler.getPlayer(), (Entity)event.getEntityLiving(), event.getAmount(), event.getSource());
            event.setCanceled(EventHooks.onPlayerDamagedEntity(handler, (PlayerEvent.DamagedEntityEvent)pevent));
            event.setAmount(((PlayerEvent.DamagedEntityEvent)pevent).damage);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void invoke(LivingAttackEvent event) {
        if (!(event.getEntityLiving().field_70170_p instanceof ServerWorld)) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (source instanceof PlayerEntity) {
            PlayerScriptData handler = PlayerData.get((PlayerEntity)((PlayerEntity)source)).scriptData;
            ItemStack item = ((PlayerEntity)source).func_184614_ca();
            IEntity target = NpcAPI.Instance().getIEntity((Entity)event.getEntityLiving());
            IDamageSource damageSource = NpcAPI.Instance().getIDamageSource(event.getSource());
            PlayerEvent.AttackEvent ev = new PlayerEvent.AttackEvent(handler.getPlayer(), target, damageSource);
            event.setCanceled(EventHooks.onPlayerAttack(handler, ev));
            if (item.func_77973_b() == CustomItems.scripted_item && !event.isCanceled()) {
                ItemScriptedWrapper isw = ItemScripted.GetWrapper(item);
                ItemEvent.AttackEvent eve = new ItemEvent.AttackEvent((IItemScripted)isw, handler.getPlayer(), target, damageSource);
                eve.setCanceled(event.isCanceled());
                event.setCanceled(EventHooks.onScriptItemAttack(isw, eve));
            }
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        EventHooks.onPlayerLogin(handler);
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld)) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        EventHooks.onPlayerLogout(handler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void invoke(ServerChatEvent event) {
        if (!(event.getPlayer().field_70170_p instanceof ServerWorld) || event.getPlayer() == EntityNPCInterface.ChatEventPlayer) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((PlayerEntity)event.getPlayer()).scriptData;
        String message = event.getMessage();
        PlayerEvent.ChatEvent ev = new PlayerEvent.ChatEvent(handler.getPlayer(), event.getMessage());
        EventHooks.onPlayerChat(handler, ev);
        event.setCanceled(ev.isCanceled());
        if (!message.equals(ev.message)) {
            TranslationTextComponent chat = new TranslationTextComponent("");
            chat.func_230529_a_(ForgeHooks.newChatWithLinks((String)ev.message));
            event.setComponent((ITextComponent)chat);
        }
    }

    public ScriptPlayerEventHandler registerForgeEvents() {
        block13: {
            ForgeEventHandler.eventNames.clear();
            ForgeEventHandler handler = new ForgeEventHandler();
            try {
                Method m = handler.getClass().getMethod("forgeEntity", Event.class);
                Method register = MinecraftForge.EVENT_BUS.getClass().getDeclaredMethod("register", Class.class, Object.class, Method.class);
                register.setAccessible(true);
                HashSet<Class> classes = new HashSet<Class>();
                Field f = ClassLoader.class.getDeclaredField("classes");
                f.setAccessible(true);
                for (ClassLoader loader = PlayerContainerEvent.Open.class.getClassLoader(); loader != null; loader = loader.getParent()) {
                    for (Class c : new ArrayList((List)f.get(loader))) {
                        if (!Event.class.isAssignableFrom(c)) continue;
                        try {
                            if (c.getDeclaredClasses().length > 0) {
                                classes.addAll(Arrays.asList(c.getDeclaredClasses()));
                                continue;
                            }
                            classes.add(c);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                for (Class c : classes) {
                    String name = c.getName();
                    if (name.startsWith("net.minecraftforge.event.terraingen") || !c.getName().startsWith("net.minecraftforge.event")) continue;
                    try {
                        String eventName;
                        if (GenericEvent.class.isAssignableFrom(c) || EntityEvent.EntityConstructing.class.isAssignableFrom(c) || WorldEvent.PotentialSpawns.class.isAssignableFrom(c) || TickEvent.RenderTickEvent.class.isAssignableFrom(c) || TickEvent.ClientTickEvent.class.isAssignableFrom(c) || NetworkEvent.ClientCustomPayloadEvent.class.isAssignableFrom(c) || ItemTooltipEvent.class.isAssignableFrom(c) || !Event.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers()) || !Modifier.isPublic(c.getModifiers()) || ForgeEventHandler.eventNames.contains(eventName = ForgeEventHandler.getEventName(c))) continue;
                        register.invoke((Object)MinecraftForge.EVENT_BUS, c, handler, m);
                        ForgeEventHandler.eventNames.add(eventName);
                    }
                    catch (Throwable t) {
                        LogWriter.except(t);
                    }
                }
                if (!PixelmonHelper.Enabled) break block13;
                try {
                    for (Class c : classes) {
                        if (!c.getName().startsWith("com.pixelmonmod.pixelmon.api.events") || !Event.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers()) || !Modifier.isPublic(c.getModifiers())) continue;
                        ForgeEventHandler.eventNames.add(ForgeEventHandler.getEventName(c));
                        register.invoke((Object)PixelmonHelper.EVENT_BUS, c, handler, m);
                    }
                }
                catch (Throwable e) {
                    LogWriter.except(e);
                }
            }
            catch (Throwable e) {
                LogWriter.except(e);
            }
        }
        return this;
    }
}

