/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockScripted
extends BlockInterface {
    public static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.001f, (double)0.001f, (double)0.001f, (double)0.998f, (double)0.998f, (double)0.998f));

    public BlockScripted() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 10.0f));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileScripted();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader level, BlockPos pos, ISelectionContext context) {
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        if (tile != null && tile.isPassible) {
            return VoxelShapes.func_197880_a();
        }
        return AABB;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter)) {
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
            return ActionResultType.SUCCESS;
        }
        Vector3d vec = ray.func_216347_e();
        float x = (float)(vec.field_72450_a - (double)pos.func_177958_n());
        float y = (float)(vec.field_72448_b - (double)pos.func_177956_o());
        float z = (float)(vec.field_72449_c - (double)pos.func_177952_p());
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        return EventHooks.onScriptBlockInteract(tile, player, ray.func_216354_b().func_176745_a(), x, y, z) ? ActionResultType.FAIL : ActionResultType.SUCCESS;
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack item) {
        if (!level.field_72995_K && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
        }
    }

    public void func_196262_a(BlockState state, World level, BlockPos pos, Entity entityIn) {
        if (level.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176224_k(World level, BlockPos pos) {
        if (level.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        EventHooks.onScriptBlockRainFill(tile);
    }

    public void func_180658_a(World level, BlockPos pos, Entity entity, float fallDistance) {
        if (level.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile, entity, fallDistance);
        super.func_180658_a(level, pos, entity, fallDistance);
    }

    public void func_196270_a(BlockState state, World level, BlockPos pos, PlayerEntity player) {
        if (level.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        EventHooks.onScriptBlockClicked(tile, player);
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.field_72995_K) {
            TileScripted tile = (TileScripted)level.func_175625_s(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_196243_a(state, level, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World level, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileScripted tile;
        if (!level.field_72995_K && EventHooks.onScriptBlockHarvest(tile = (TileScripted)level.func_175625_s(pos), player)) {
            return false;
        }
        return super.removedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return Collections.emptyList();
    }

    public void onBlockExploded(BlockState state, World level, BlockPos pos, Explosion explosion) {
        TileScripted tile;
        if (!level.field_72995_K && EventHooks.onScriptBlockExploded(tile = (TileScripted)level.func_175625_s(pos))) {
            return;
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block neighborBlock, BlockPos pos2, boolean isMoving) {
        if (level.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        EventHooks.onScriptBlockNeighborChanged(tile, pos2);
        int power = 0;
        for (Direction enumfacing : Direction.values()) {
            int p = level.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
            if (p <= power) continue;
            power = p;
        }
        if (tile.prevPower != power && tile.powering <= 0) {
            tile.newPower = power;
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return this.func_176211_b(state, worldIn, pos, side);
    }

    public int func_176211_b(BlockState state, IBlockReader level, BlockPos pos, Direction side) {
        return ((TileScripted)level.func_175625_s((BlockPos)pos)).activePowering;
    }

    public boolean isLadder(BlockState state, IWorldReader level, BlockPos pos, LivingEntity entity) {
        return ((TileScripted)level.func_175625_s((BlockPos)pos)).isLadder;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader level, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader level, BlockPos pos) {
        TileScripted tile = (TileScripted)level.func_175625_s(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public boolean func_196266_a(BlockState state, IBlockReader level, BlockPos pos, PathType type) {
        return ((TileScripted)level.func_175625_s((BlockPos)pos)).isPassible;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader level, BlockPos pos, Entity entity) {
        return super.canEntityDestroy(state, level, pos, entity);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader level, BlockPos pos) {
        float f = ((TileScripted)level.func_175625_s((BlockPos)pos)).blockHardness;
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)level, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public float getExplosionResistance(BlockState state, IBlockReader level, BlockPos pos, Explosion explosion) {
        return ((TileScripted)level.func_175625_s((BlockPos)pos)).blockResistance;
    }
}

