/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.VanillaPack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import noppes.npcs.CustomNpcs;
import noppes.npcs.mixin.SimpleReloadableResourceManagerMixin;
import org.apache.commons.lang3.StringUtils;

public class AssetsBrowser {
    public boolean isRoot;
    private int depth;
    private String folder;
    public HashSet<String> folders = new HashSet();
    public HashSet<String> files = new HashSet();
    private String[] extensions;

    public AssetsBrowser(String folder, String[] extensions) {
        this.extensions = extensions;
        this.setFolder(folder);
    }

    public void setFolder(String folder) {
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        this.isRoot = folder.length() <= 1;
        this.folder = "/assets" + folder;
        this.depth = StringUtils.countMatches((CharSequence)this.folder, (CharSequence)"/");
        this.getFiles();
    }

    public AssetsBrowser(String[] extensions) {
        this.extensions = extensions;
    }

    private void getFiles() {
        this.folders.clear();
        this.files.clear();
        SimpleReloadableResourceManagerMixin simplemanager = (SimpleReloadableResourceManagerMixin)Minecraft.func_71410_x().func_195551_G();
        Map<String, FallbackResourceManager> map = simplemanager.getPacks();
        for (String name : map.keySet()) {
            FallbackResourceManager manager = map.get(name);
            List list = manager.field_199023_a;
            for (IResourcePack pack : list) {
                this.processResourcePack(pack);
            }
        }
        for (ModFileInfo mod : ModList.get().getModFiles()) {
            File file = mod.getFile().getFilePath().toFile();
            if (!file.exists()) continue;
            this.progressFile(file);
        }
        ResourcePackList repos = Minecraft.func_71410_x().func_195548_H();
        repos.func_198983_a();
        Collection list = repos.func_198978_b();
        for (ResourcePackInfo entry : list) {
            this.processResourcePack(entry.func_195796_e());
        }
        URL url = VanillaPack.class.getResource("/assets/.mcassetsroot");
        if (url != null) {
            File f = this.decodeFile(url.getFile());
            if (f.isDirectory()) {
                this.checkFolder(new File(f, "assets"), url.getFile().length());
            } else {
                this.progressFile(f);
            }
        }
        this.checkFolder(new File(CustomNpcs.Dir, "assets"), CustomNpcs.Dir.getAbsolutePath().length());
    }

    private File decodeFile(String url) {
        int i;
        if (url.startsWith("file:")) {
            url = url.substring(5);
        }
        if ((i = (url = url.replace('/', File.separatorChar)).indexOf(33)) > 0) {
            url = url.substring(0, i);
        }
        try {
            url = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new File(url);
    }

    private void processResourcePack(IResourcePack pack) {
        if (pack instanceof LegacyResourcePackWrapper) {
            pack = (IResourcePack)ObfuscationReflectionHelper.getPrivateValue(LegacyResourcePackWrapper.class, (Object)((LegacyResourcePackWrapper)pack), (String)"field_211854_b");
        }
        if (pack instanceof ResourcePack) {
            ResourcePack p = (ResourcePack)pack;
            File file = p.field_195771_a;
            if (file != null) {
                if (file.isDirectory()) {
                    this.checkFolder(new File(file, "assets"), file.getAbsolutePath().length());
                } else {
                    this.progressFile(file);
                }
            }
        }
    }

    private void progressFile(File file) {
        try {
            if (!file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipentry = entries.nextElement();
                    String entryName = zipentry.getName();
                    this.checkFile(entryName);
                }
                zip.close();
            } else if (file.isDirectory()) {
                int length = file.getAbsolutePath().length();
                this.checkFolder(file, length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkFolder(File file, int length) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            String name = f.getAbsolutePath().substring(length);
            if (!(name = name.replace("\\", "/")).startsWith("/")) {
                name = "/" + name;
            }
            if (f.isDirectory() && (this.folder.startsWith(name) || name.startsWith(this.folder))) {
                this.checkFile(name + "/");
                this.checkFolder(f, length);
                continue;
            }
            this.checkFile(name);
        }
    }

    private void checkFile(String name) {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!name.startsWith(this.folder)) {
            return;
        }
        String[] split = name.split("/");
        int count = split.length;
        if (count == this.depth + 1) {
            if (this.validExtension(name)) {
                this.files.add(split[this.depth]);
            }
        } else if (this.depth + 1 < count) {
            this.folders.add(split[this.depth]);
        }
    }

    private boolean validExtension(String entryName) {
        int index = entryName.lastIndexOf(".");
        if (index < 0) {
            return false;
        }
        String extension = entryName.substring(index + 1);
        for (String ex : this.extensions) {
            if (!ex.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public String getAsset(String asset) {
        String[] split = this.folder.split("/");
        if (split.length < 3) {
            return null;
        }
        String texture = split[2] + ":";
        texture = texture + this.folder.substring(texture.length() + 8) + asset;
        return texture;
    }

    public static String getRoot(String asset) {
        String location;
        String mod = "minecraft";
        int index = asset.indexOf(":");
        if (index > 0) {
            mod = asset.substring(0, index);
            asset = asset.substring(index + 1);
        }
        if (asset.startsWith("/")) {
            asset = asset.substring(1);
        }
        if ((index = (location = "/" + mod + "/" + asset).lastIndexOf("/")) > 0) {
            location = location.substring(0, index);
        }
        return location;
    }
}

