/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketSchematicsTileBuild;
import noppes.npcs.packets.server.SPacketSchematicsTileGet;
import noppes.npcs.packets.server.SPacketSchematicsTileSave;
import noppes.npcs.packets.server.SPacketSchematicsTileSet;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.schematics.SchematicWrapper;

public class GuiBlockBuilder
extends GuiNPCInterface
implements IGuiData,
ICustomScrollListener,
IScrollData,
BooleanConsumer {
    private BlockPos pos;
    private TileBuilder tile;
    private GuiCustomScroll scroll;
    private ISchematic selected = null;

    public GuiBlockBuilder(BlockPos pos) {
        this.pos = pos;
        this.setBackground("menubg.png");
        this.imageWidth = 256;
        this.imageHeight = 216;
        this.tile = (TileBuilder)this.player.field_70170_p.func_175625_s(pos);
        Packets.sendServer(new SPacketSchematicsTileGet(pos));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.func_231149_a_(125, 208);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        if (this.selected != null) {
            int y = this.guiTop + 4;
            int size = this.selected.getWidth() * this.selected.getHeight() * this.selected.getLength();
            this.addButton(new GuiNpcButtonYesNo((IGuiInterface)this, 3, this.guiLeft + 200, y, TileBuilder.DrawPos != null && this.tile.func_174877_v().equals((Object)TileBuilder.DrawPos)));
            this.addLabel(new GuiNpcLabel(3, "schematic.preview", this.guiLeft + 130, y + 5));
            this.addLabel(new GuiNpcLabel(0, I18n.func_135052_a((String)"schematic.width", (Object[])new Object[0]) + ": " + this.selected.getWidth(), this.guiLeft + 130, y += 21));
            this.addLabel(new GuiNpcLabel(1, I18n.func_135052_a((String)"schematic.length", (Object[])new Object[0]) + ": " + this.selected.getLength(), this.guiLeft + 130, y += 11));
            this.addLabel(new GuiNpcLabel(2, I18n.func_135052_a((String)"schematic.height", (Object[])new Object[0]) + ": " + this.selected.getHeight(), this.guiLeft + 130, y += 11));
            this.addButton(new GuiNpcButtonYesNo((IGuiInterface)this, 4, this.guiLeft + 200, y += 14, this.tile.enabled));
            this.addLabel(new GuiNpcLabel(4, I18n.func_135052_a((String)"gui.enabled", (Object[])new Object[0]), this.guiLeft + 130, y + 5));
            this.addButton(new GuiNpcButtonYesNo((IGuiInterface)this, 7, this.guiLeft + 200, y += 22, this.tile.finished));
            this.addLabel(new GuiNpcLabel(7, I18n.func_135052_a((String)"gui.finished", (Object[])new Object[0]), this.guiLeft + 130, y + 5));
            this.addButton(new GuiNpcButtonYesNo((IGuiInterface)this, 8, this.guiLeft + 200, y += 22, this.tile.started));
            this.addLabel(new GuiNpcLabel(8, I18n.func_135052_a((String)"gui.started", (Object[])new Object[0]), this.guiLeft + 130, y + 5));
            this.addTextField(new GuiNpcTextField(9, (Screen)this, this.guiLeft + 200, y += 22, 50, 20, this.tile.yOffest + ""));
            this.addLabel(new GuiNpcLabel(9, I18n.func_135052_a((String)"gui.yoffset", (Object[])new Object[0]), this.guiLeft + 130, y + 5));
            this.getTextField((int)9).numbersOnly = true;
            this.getTextField(9).setMinMaxDefault(-10, 10, 0);
            this.addButton(new GuiNpcButton((IGuiInterface)this, 5, this.guiLeft + 200, y += 22, 50, 20, new String[]{"0", "90", "180", "270"}, this.tile.rotation));
            this.addLabel(new GuiNpcLabel(5, I18n.func_135052_a((String)"movement.rotation", (Object[])new Object[0]), this.guiLeft + 130, y + 5));
            this.addButton(new GuiNpcButton(this, 6, this.guiLeft + 130, y += 22, 120, 20, "availability.options"));
            this.addButton(new GuiNpcButton(this, 10, this.guiLeft + 130, y += 22, 120, 20, "schematic.instantBuild"));
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        if (guibutton.id == 3) {
            GuiNpcButtonYesNo button = (GuiNpcButtonYesNo)guibutton;
            if (button.getBoolean()) {
                TileBuilder.SetDrawPos(this.pos);
                this.tile.setDrawSchematic(new SchematicWrapper(this.selected));
            } else {
                TileBuilder.SetDrawPos(null);
                this.tile.setDrawSchematic(null);
            }
        }
        if (guibutton.id == 4) {
            this.tile.enabled = ((GuiNpcButtonYesNo)guibutton).getBoolean();
        }
        if (guibutton.id == 5) {
            this.tile.rotation = guibutton.getValue();
            TileBuilder.Compiled = false;
        }
        if (guibutton.id == 6) {
            this.setSubGui(new SubGuiNpcAvailability(this.tile.availability));
        }
        if (guibutton.id == 7) {
            this.tile.finished = ((GuiNpcButtonYesNo)guibutton).getBoolean();
            Packets.sendServer(new SPacketSchematicsTileSet(this.pos, this.scroll.getSelected()));
        }
        if (guibutton.id == 8) {
            this.tile.started = ((GuiNpcButtonYesNo)guibutton).getBoolean();
        }
        if (guibutton.id == 10) {
            this.save();
            ConfirmScreen guiyesno = new ConfirmScreen((BooleanConsumer)this, StringTextComponent.field_240750_d_, (ITextComponent)new TranslationTextComponent("schematic.instantBuildText"));
            this.setScreen((Screen)guiyesno);
        }
    }

    @Override
    public void save() {
        if (this.getTextField(9) != null) {
            this.tile.yOffest = this.getTextField(9).getInteger();
        }
        Packets.sendServer(new SPacketSchematicsTileSave(this.pos, this.tile.writePartNBT(new CompoundNBT())));
    }

    @Override
    public void setGuiData(final CompoundNBT compound) {
        if (compound.func_74764_b("Width")) {
            final ArrayList<BlockState> states = new ArrayList<BlockState>();
            ListNBT list = compound.func_150295_c("Data", 10);
            for (int i = 0; i < list.size(); ++i) {
                states.add(NBTUtil.func_190008_d((CompoundNBT)list.func_150305_b(i)));
            }
            this.selected = new ISchematic(){

                @Override
                public short getWidth() {
                    return compound.func_74765_d("Width");
                }

                @Override
                public int getBlockEntitySize() {
                    return 0;
                }

                @Override
                public CompoundNBT getBlockEntity(int i) {
                    return null;
                }

                @Override
                public String getName() {
                    return compound.func_74779_i("SchematicName");
                }

                @Override
                public short getLength() {
                    return compound.func_74765_d("Length");
                }

                @Override
                public short getHeight() {
                    return compound.func_74765_d("Height");
                }

                @Override
                public BlockState getBlockState(int i) {
                    return (BlockState)states.get(i);
                }

                @Override
                public BlockState getBlockState(int x, int y, int z) {
                    return this.getBlockState((y * this.getLength() + z) * this.getWidth() + x);
                }

                @Override
                public CompoundNBT getNBT() {
                    return null;
                }
            };
            if (TileBuilder.DrawPos != null && TileBuilder.DrawPos.equals((Object)this.tile.func_174877_v())) {
                SchematicWrapper wrapper = new SchematicWrapper(this.selected);
                wrapper.rotation = this.tile.rotation;
                this.tile.setDrawSchematic(wrapper);
            }
            this.scroll.setSelected(this.selected.getName());
            this.scroll.scrollTo(this.selected.getName());
        } else {
            this.tile.readPartNBT(compound);
        }
        this.func_231160_c_();
    }

    public void accept(boolean flag) {
        if (flag) {
            Packets.sendServer(new SPacketSchematicsTileBuild(this.pos));
            this.close();
            this.selected = null;
        } else {
            NoppesUtil.openGUI((PlayerEntity)this.player, this);
        }
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        if (this.selected != null) {
            this.getButton(3).setDisplay(0);
        }
        TileBuilder.SetDrawPos(null);
        this.tile.setDrawSchematic(null);
        Packets.sendServer(new SPacketSchematicsTileSet(this.pos, scroll.getSelected()));
    }

    @Override
    public void setData(Vector<String> list, Map<String, Integer> data) {
        this.scroll.setList(list);
        if (this.selected != null) {
            this.scroll.setSelected(this.selected.getName());
        }
        this.func_231160_c_();
    }

    @Override
    public void setSelected(String selected) {
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

