/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import noppes.npcs.NBTTags;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.constants.EnumMenuType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketMenuGet;
import noppes.npcs.packets.server.SPacketMenuSave;

public class GuiNpcPather
extends GuiNPCInterface
implements IGuiData {
    private GuiCustomScroll scroll;
    private HashMap<String, Integer> data = new HashMap();
    private DataAI ai;

    public GuiNpcPather(EntityNPCInterface npc) {
        this.drawDefaultBackground = false;
        this.imageWidth = 176;
        this.field_230704_d_ = "Npc Pather";
        this.setBackground("smallbg.png");
        this.ai = npc.ais;
        Packets.sendServer(new SPacketMenuGet(EnumMenuType.MOVING_PATH));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.scroll = new GuiCustomScroll(this, 0);
        this.scroll.func_231149_a_(160, 164);
        ArrayList<String> list = new ArrayList<String>();
        for (int[] arr : this.ai.getMovingPath()) {
            list.add("x:" + arr[0] + " y:" + arr[1] + " z:" + arr[2]);
        }
        this.scroll.setUnsortedList(list);
        this.scroll.guiLeft = this.guiLeft + 7;
        this.scroll.guiTop = this.guiTop + 12;
        this.addScroll(this.scroll);
        this.addButton(new GuiNpcButton(this, 0, this.guiLeft + 6, this.guiTop + 178, 52, 20, "gui.down"));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 62, this.guiTop + 178, 52, 20, "gui.up"));
        this.addButton(new GuiNpcButton(this, 2, this.guiLeft + 118, this.guiTop + 178, 52, 20, "selectWorld.deleteButton"));
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        int[] b;
        int[] a;
        int selected;
        List<int[]> list;
        if (!this.scroll.hasSelected()) {
            return;
        }
        int id = guibutton.id;
        if (id == 0) {
            list = this.ai.getMovingPath();
            selected = this.scroll.getSelectedIndex();
            if (list.size() <= selected + 1) {
                return;
            }
            a = list.get(selected);
            b = list.get(selected + 1);
            list.set(selected, b);
            list.set(selected + 1, a);
            this.ai.setMovingPath(list);
            this.func_231160_c_();
            this.scroll.setSelectedIndex(selected + 1);
        }
        if (id == 1) {
            if (this.scroll.getSelectedIndex() - 1 < 0) {
                return;
            }
            list = this.ai.getMovingPath();
            selected = this.scroll.getSelectedIndex();
            a = list.get(selected);
            b = list.get(selected - 1);
            list.set(selected, b);
            list.set(selected - 1, a);
            this.ai.setMovingPath(list);
            this.func_231160_c_();
            this.scroll.setSelectedIndex(selected - 1);
        }
        if (id == 2) {
            list = this.ai.getMovingPath();
            if (list.size() <= 1) {
                return;
            }
            list.remove(this.scroll.getSelectedIndex());
            this.ai.setMovingPath(list);
            this.func_231160_c_();
        }
    }

    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        this.scroll.func_231044_a_(i, j, k);
        return super.func_231044_a_(i, j, k);
    }

    @Override
    public void save() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("MovingPathNew", (INBT)NBTTags.nbtIntegerArraySet(this.ai.getMovingPath()));
        Packets.sendServer(new SPacketMenuSave(EnumMenuType.MOVING_PATH, compound));
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        this.ai.readToNBT(compound);
        this.func_231160_c_();
    }
}

