/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.controllers.data.SpawnData;

public class SubGuiNpcBiomes
extends SubGuiInterface {
    private SpawnData data;
    private GuiCustomScroll scroll1;
    private GuiCustomScroll scroll2;

    public SubGuiNpcBiomes(SpawnData data) {
        this.data = data;
        this.setBackground("menubg.png");
        this.imageWidth = 346;
        this.imageHeight = 216;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.scroll1 == null) {
            this.scroll1 = new GuiCustomScroll(this, 0);
            this.scroll1.func_231149_a_(140, 180);
        }
        this.scroll1.guiLeft = this.guiLeft + 4;
        this.scroll1.guiTop = this.guiTop + 14;
        this.addScroll(this.scroll1);
        this.addLabel(new GuiNpcLabel(1, "spawning.availableBiomes", this.guiLeft + 4, this.guiTop + 4));
        if (this.scroll2 == null) {
            this.scroll2 = new GuiCustomScroll(this, 1);
            this.scroll2.func_231149_a_(140, 180);
        }
        this.scroll2.guiLeft = this.guiLeft + 200;
        this.scroll2.guiTop = this.guiTop + 14;
        this.addScroll(this.scroll2);
        this.addLabel(new GuiNpcLabel(2, "spawning.spawningBiomes", this.guiLeft + 200, this.guiTop + 4));
        ArrayList<String> biomes = new ArrayList<String>();
        for (Biome base : ForgeRegistries.BIOMES) {
            if (base == null || base.getRegistryName() == null || this.data.biomes.contains(base.getRegistryName().toString())) continue;
            biomes.add(base.getRegistryName().toString());
        }
        this.scroll1.setList(biomes);
        this.scroll2.setList(this.data.biomes.stream().map(Object::toString).collect(Collectors.toList()));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 145, this.guiTop + 40, 55, 20, ">"));
        this.addButton(new GuiNpcButton(this, 2, this.guiLeft + 145, this.guiTop + 62, 55, 20, "<"));
        this.addButton(new GuiNpcButton(this, 3, this.guiLeft + 145, this.guiTop + 90, 55, 20, ">>"));
        this.addButton(new GuiNpcButton(this, 4, this.guiLeft + 145, this.guiTop + 112, 55, 20, "<<"));
        this.addButton(new GuiNpcButton(this, 66, this.guiLeft + 260, this.guiTop + 194, 60, 20, "gui.done"));
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        GuiNpcButton button = guibutton;
        if (button.id == 1 && this.scroll1.hasSelected()) {
            this.data.biomes.add(new ResourceLocation(this.scroll1.getSelected()));
            this.scroll1.clearSelection();
            this.scroll2.clearSelection();
            this.func_231160_c_();
        }
        if (button.id == 2 && this.scroll2.hasSelected()) {
            this.data.biomes.remove(this.scroll2.getSelected());
            this.scroll2.clearSelection();
            this.func_231160_c_();
        }
        if (button.id == 3) {
            this.data.biomes.clear();
            for (Biome base : ForgeRegistries.BIOMES) {
                if (base == null) continue;
                this.data.biomes.add(base.getRegistryName());
            }
            this.scroll1.clearSelection();
            this.scroll2.clearSelection();
            this.func_231160_c_();
        }
        if (button.id == 4) {
            this.data.biomes.clear();
            this.scroll1.clearSelection();
            this.scroll2.clearSelection();
            this.func_231160_c_();
        }
        if (button.id == 66) {
            this.close();
        }
    }
}

