/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.DataMelee;

public class SubGuiNpcMeleeProperties
extends SubGuiInterface
implements ITextfieldListener {
    private DataMelee stats;
    private static final String[] potionNames;

    public SubGuiNpcMeleeProperties(DataMelee stats) {
        this.stats = stats;
        this.setBackground("menubg.png");
        this.imageWidth = 256;
        this.imageHeight = 216;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addLabel(new GuiNpcLabel(1, "stats.meleestrength", this.guiLeft + 5, this.guiTop + 15));
        this.addTextField(new GuiNpcTextField(1, (Screen)this, this.guiLeft + 85, this.guiTop + 10, 50, 18, this.stats.getStrength() + ""));
        this.getTextField((int)1).numbersOnly = true;
        this.getTextField(1).setMinMaxDefault(0, Integer.MAX_VALUE, 5);
        this.addLabel(new GuiNpcLabel(2, "stats.meleerange", this.guiLeft + 5, this.guiTop + 45));
        this.addTextField(new GuiNpcTextField(2, (Screen)this, this.guiLeft + 85, this.guiTop + 40, 50, 18, this.stats.getRange() + ""));
        this.getTextField((int)2).numbersOnly = true;
        this.getTextField(2).setMinMaxDefault(1, 30, 2);
        this.addLabel(new GuiNpcLabel(3, "stats.meleespeed", this.guiLeft + 5, this.guiTop + 75));
        this.addTextField(new GuiNpcTextField(3, (Screen)this, this.guiLeft + 85, this.guiTop + 70, 50, 18, this.stats.getDelay() + ""));
        this.getTextField((int)3).numbersOnly = true;
        this.getTextField(3).setMinMaxDefault(1, 1000, 20);
        this.addLabel(new GuiNpcLabel(4, "enchantment.minecraft.knockback", this.guiLeft + 5, this.guiTop + 105));
        this.addTextField(new GuiNpcTextField(4, (Screen)this, this.guiLeft + 85, this.guiTop + 100, 50, 18, this.stats.getKnockback() + ""));
        this.getTextField((int)4).numbersOnly = true;
        this.getTextField(4).setMinMaxDefault(0, 4, 0);
        this.addLabel(new GuiNpcLabel(5, "stats.meleeeffect", this.guiLeft + 5, this.guiTop + 135));
        int effect = this.stats.getEffectType();
        if (effect == 666) {
            effect = potionNames.length - 1;
        }
        this.addButton(new GuiButtonBiDirectional((IGuiInterface)this, 5, this.guiLeft + 85, this.guiTop + 130, 100, 20, potionNames, effect));
        if (this.stats.getEffectType() != 0) {
            this.addLabel(new GuiNpcLabel(6, "gui.time", this.guiLeft + 5, this.guiTop + 165));
            this.addTextField(new GuiNpcTextField(6, (Screen)this, this.guiLeft + 85, this.guiTop + 160, 50, 18, this.stats.getEffectTime() + ""));
            this.getTextField((int)6).numbersOnly = true;
            this.getTextField(6).setMinMaxDefault(1, 99999, 5);
            if (this.stats.getEffectType() != 666) {
                this.addLabel(new GuiNpcLabel(7, "stats.amplify", this.guiLeft + 5, this.guiTop + 195));
                this.addButton(new GuiButtonBiDirectional((IGuiInterface)this, 7, this.guiLeft + 85, this.guiTop + 190, 52, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, this.stats.getEffectStrength()));
            }
        }
        this.addButton(new GuiNpcButton(this, 66, this.guiLeft + 164, this.guiTop + 192, 90, 20, "gui.done"));
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        if (textfield.id == 1) {
            this.stats.setStrength(textfield.getInteger());
        } else if (textfield.id == 2) {
            this.stats.setRange(textfield.getInteger());
        } else if (textfield.id == 3) {
            this.stats.setDelay(textfield.getInteger());
        } else if (textfield.id == 4) {
            this.stats.setKnockback(textfield.getInteger());
        } else if (textfield.id == 6) {
            this.stats.setEffect(this.stats.getEffectType(), this.stats.getEffectStrength(), textfield.getInteger());
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton button) {
        if (button.id == 5) {
            int effect = button.getValue();
            if (effect == potionNames.length - 1) {
                effect = 666;
            }
            this.stats.setEffect(effect, this.stats.getEffectStrength(), this.stats.getEffectTime());
            this.func_231160_c_();
        }
        if (button.id == 7) {
            this.stats.setEffect(this.stats.getEffectType(), button.getValue(), this.stats.getEffectTime());
        }
        if (button.id == 66) {
            this.close();
        }
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("gui.none");
        for (int i = 1; i < 33; ++i) {
            list.add(PotionEffectType.getMCType(i).func_76393_a());
        }
        list.add("block.minecraft.fire");
        potionNames = list.toArray(new String[list.size()]);
    }
}

