/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import com.google.common.collect.Lists;
import java.util.HashMap;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.global.GuiDialogEdit;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketDialogCategoryRemove;
import noppes.npcs.packets.server.SPacketDialogCategorySave;
import noppes.npcs.packets.server.SPacketDialogRemove;
import noppes.npcs.packets.server.SPacketDialogSave;

public class GuiNPCManageDialogs
extends GuiNPCInterface2
implements ISubGuiListener,
ICustomScrollListener {
    private HashMap<String, DialogCategory> categoryData = new HashMap();
    private HashMap<String, Dialog> dialogData = new HashMap();
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollDialogs;
    public static Screen Instance;
    private DialogCategory selectedCategory;
    private Dialog selectedDialog;

    public GuiNPCManageDialogs(EntityNPCInterface npc) {
        super(npc);
        Instance = this;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addLabel(new GuiNpcLabel(0, "gui.categories", this.guiLeft + 8, this.guiTop + 4));
        this.addLabel(new GuiNpcLabel(1, "dialog.dialogs", this.guiLeft + 175, this.guiTop + 4));
        this.addLabel(new GuiNpcLabel(3, "dialog.dialogs", this.guiLeft + 356, this.guiTop + 8));
        this.addButton(new GuiNpcButton((IGuiInterface)this, 13, this.guiLeft + 356, this.guiTop + 18, 58, 20, "selectServer.edit", this.selectedDialog != null));
        this.addButton(new GuiNpcButton((IGuiInterface)this, 12, this.guiLeft + 356, this.guiTop + 41, 58, 20, "gui.remove", this.selectedDialog != null));
        this.addButton(new GuiNpcButton((IGuiInterface)this, 11, this.guiLeft + 356, this.guiTop + 64, 58, 20, "gui.add", this.selectedCategory != null));
        this.addLabel(new GuiNpcLabel(2, "gui.categories", this.guiLeft + 356, this.guiTop + 110));
        this.addButton(new GuiNpcButton((IGuiInterface)this, 3, this.guiLeft + 356, this.guiTop + 120, 58, 20, "selectServer.edit", this.selectedCategory != null));
        this.addButton(new GuiNpcButton((IGuiInterface)this, 2, this.guiLeft + 356, this.guiTop + 143, 58, 20, "gui.remove", this.selectedCategory != null));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 356, this.guiTop + 166, 58, 20, "gui.add"));
        HashMap<String, DialogCategory> categoryData = new HashMap<String, DialogCategory>();
        HashMap<String, Dialog> dialogData = new HashMap<String, Dialog>();
        for (DialogCategory category : DialogController.instance.categories.values()) {
            categoryData.put(category.title, category);
        }
        this.categoryData = categoryData;
        if (this.selectedCategory != null) {
            for (Dialog dialog : this.selectedCategory.dialogs.values()) {
                dialogData.put(dialog.title, dialog);
            }
        }
        this.dialogData = dialogData;
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.func_231149_a_(170, 200);
        }
        this.scrollCategories.setList(Lists.newArrayList(categoryData.keySet()));
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollCategories);
        if (this.scrollDialogs == null) {
            this.scrollDialogs = new GuiCustomScroll(this, 1);
            this.scrollDialogs.func_231149_a_(170, 200);
        }
        this.scrollDialogs.setList(Lists.newArrayList(dialogData.keySet()));
        this.scrollDialogs.guiLeft = this.guiLeft + 175;
        this.scrollDialogs.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollDialogs);
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        ConfirmScreen guiyesno;
        GuiNpcButton button = guibutton;
        if (button.id == 1) {
            this.setSubGui(new SubGuiEditText(1, I18n.func_135052_a((String)"gui.new", (Object[])new Object[0])));
        }
        if (button.id == 2) {
            guiyesno = new ConfirmScreen(bo -> {
                if (bo) {
                    Packets.sendServer(new SPacketDialogCategoryRemove(this.selectedCategory.id));
                }
                NoppesUtil.openGUI((PlayerEntity)this.player, this);
            }, (ITextComponent)new TranslationTextComponent(this.selectedCategory.title), (ITextComponent)new TranslationTextComponent("gui.deleteMessage"));
            this.setScreen((Screen)guiyesno);
        }
        if (button.id == 3) {
            this.setSubGui(new SubGuiEditText(3, this.selectedCategory.title));
        }
        if (button.id == 11) {
            this.setSubGui(new SubGuiEditText(11, I18n.func_135052_a((String)"gui.new", (Object[])new Object[0])));
        }
        if (button.id == 12) {
            guiyesno = new ConfirmScreen(bo -> {
                if (bo) {
                    Packets.sendServer(new SPacketDialogRemove(this.selectedDialog.id));
                }
                NoppesUtil.openGUI((PlayerEntity)this.player, this);
            }, (ITextComponent)new TranslationTextComponent(this.selectedDialog.title), (ITextComponent)new TranslationTextComponent("gui.deleteMessage"));
            this.setScreen((Screen)guiyesno);
        }
        if (button.id == 13) {
            this.setSubGui(new GuiDialogEdit(this.selectedDialog));
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiEditText && ((SubGuiEditText)subgui).cancelled) {
            return;
        }
        if (subgui.id == 1) {
            DialogCategory category = new DialogCategory();
            category.title = ((SubGuiEditText)subgui).text;
            while (DialogController.instance.containsCategoryName(category)) {
                category.title = category.title + "_";
            }
            Packets.sendServer(new SPacketDialogCategorySave(category.writeNBT(new CompoundNBT())));
        }
        if (subgui.id == 3) {
            this.selectedCategory.title = ((SubGuiEditText)subgui).text;
            while (DialogController.instance.containsCategoryName(this.selectedCategory)) {
                this.selectedCategory.title = this.selectedCategory.title + "_";
            }
            Packets.sendServer(new SPacketDialogCategorySave(this.selectedCategory.writeNBT(new CompoundNBT())));
        }
        if (subgui.id == 11) {
            Dialog dialog = new Dialog(this.selectedCategory);
            dialog.title = ((SubGuiEditText)subgui).text;
            while (DialogController.instance.containsDialogName(this.selectedCategory, dialog)) {
                dialog.title = dialog.title + "_";
            }
            Packets.sendServer(new SPacketDialogSave(this.selectedCategory.id, dialog.save(new CompoundNBT())));
        }
        if (subgui instanceof GuiDialogEdit) {
            this.func_231160_c_();
        }
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll guiCustomScroll) {
        if (guiCustomScroll.id == 0) {
            this.selectedCategory = this.categoryData.get(this.scrollCategories.getSelected());
            this.selectedDialog = null;
            this.scrollDialogs.clearSelection();
        }
        if (guiCustomScroll.id == 1) {
            this.selectedDialog = this.dialogData.get(this.scrollDialogs.getSelected());
        }
        this.func_231160_c_();
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
        if (this.selectedDialog != null && scroll.id == 1) {
            this.setSubGui(new GuiDialogEdit(this.selectedDialog));
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
    }
}

