/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketFollowerExtend;
import noppes.npcs.packets.server.SPacketFollowerState;
import noppes.npcs.packets.server.SPacketNpcRoleGet;
import noppes.npcs.roles.RoleFollower;

public class GuiNpcFollower
extends GuiContainerNPCInterface<ContainerNPCFollower>
implements IGuiData {
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/follower.png");
    private RoleFollower role;

    public GuiNpcFollower(ContainerNPCFollower container, PlayerInventory inv, ITextComponent titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.role = (RoleFollower)this.npc.role;
        Packets.sendServer(new SPacketNpcRoleGet());
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.addButton(new GuiNpcButton((IGuiInterface)this, 4, this.guiLeft + 100, this.guiTop + 110, 50, 20, new String[]{I18n.func_135052_a((String)"follower.waiting", (Object[])new Object[0]), I18n.func_135052_a((String)"follower.following", (Object[])new Object[0])}, this.role.isFollowing ? 1 : 0));
        if (!this.role.infiniteDays) {
            this.addButton(new GuiNpcButton(this, 5, this.guiLeft + 8, this.guiTop + 30, 50, 20, I18n.func_135052_a((String)"follower.hire", (Object[])new Object[0])));
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        int id = guibutton.id;
        if (id == 4) {
            Packets.sendServer(new SPacketFollowerState());
        }
        if (id == 5) {
            Packets.sendServer(new SPacketFollowerExtend());
        }
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"follower.health", (Object[])new Object[0]) + ": " + this.npc.func_110143_aJ() + "/" + this.npc.func_110138_aP(), 62.0f, 70.0f, CustomNpcResourceListener.DefaultTextColor);
        if (!this.role.infiniteDays) {
            if (this.role.getDays() <= 1) {
                this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"follower.daysleft", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"follower.lastday", (Object[])new Object[0]), 62.0f, 94.0f, CustomNpcResourceListener.DefaultTextColor);
            } else {
                this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"follower.daysleft", (Object[])new Object[0]) + ": " + (this.role.getDays() - 1), 62.0f, 94.0f, CustomNpcResourceListener.DefaultTextColor);
            }
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.resource);
        int l = this.guiLeft;
        int i1 = this.guiTop;
        this.func_238474_b_(matrixStack, l, i1, 0, 0, this.field_146999_f, this.field_147000_g);
        int index = 0;
        if (!this.role.infiniteDays) {
            for (int slot = 0; slot < this.role.inventory.items.size(); ++slot) {
                ItemStack itemstack = (ItemStack)this.role.inventory.items.get(slot);
                if (NoppesUtilServer.IsItemStackNull(itemstack)) continue;
                int days = 1;
                if (this.role.rates.containsKey(slot)) {
                    days = this.role.rates.get(slot);
                }
                int yOffset = index * 20;
                int i = this.guiLeft + 68;
                int j = this.guiTop + yOffset + 4;
                RenderSystem.enableRescaleNormal();
                this.field_230707_j_.func_180450_b(itemstack, x + 11, y);
                this.field_230707_j_.func_175030_a(this.field_230712_o_, itemstack, x + 11, y);
                RenderSystem.disableRescaleNormal();
                String daysS = days + " " + (days == 1 ? I18n.func_135052_a((String)"follower.day", (Object[])new Object[0]) : I18n.func_135052_a((String)"follower.days", (Object[])new Object[0]));
                this.field_230712_o_.func_238421_b_(matrixStack, " = " + daysS, (float)(i + 27), (float)(j + 4), CustomNpcResourceListener.DefaultTextColor);
                if (this.func_195359_a(i - this.guiLeft + 11, j - this.guiTop, 16, 16, this.mouseX, this.mouseY)) {
                    this.func_230457_a_(matrixStack, itemstack, this.mouseX, this.mouseY);
                }
                ++index;
            }
        }
        this.drawNpc(33, 131);
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        this.npc.role.load(compound);
        this.func_231160_c_();
    }
}

