/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.companion;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCompanionOpenInv;
import noppes.npcs.packets.server.SPacketCompanionTalentExp;
import noppes.npcs.roles.RoleCompanion;

public class GuiNpcCompanionTalents
extends GuiNPCInterface {
    private RoleCompanion role;
    private Map<Integer, GuiTalent> talents = new HashMap<Integer, GuiTalent>();
    private GuiNpcButton selected;
    private long lastPressedTime = 0L;
    private long startPressedTime = 0L;

    public GuiNpcCompanionTalents(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.role;
        this.setBackground("companion_empty.png");
        this.imageWidth = 171;
        this.imageHeight = 166;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.talents = new HashMap<Integer, GuiTalent>();
        int y = this.guiTop + 12;
        this.addLabel(new GuiNpcLabel(0, NoppesStringUtils.translate("quest.exp", ": "), this.guiLeft + 4, this.guiTop + 10));
        GuiNpcCompanionStats.addTopMenu(this.role, this, 2);
        int i = 0;
        for (EnumCompanionTalent e : this.role.talents.keySet()) {
            this.addTalent(i++, e);
        }
    }

    private void addTalent(int i, EnumCompanionTalent talent) {
        int y = this.guiTop + 28 + i / 2 * 26;
        int x = this.guiLeft + 4 + i % 2 * 84;
        GuiTalent gui = new GuiTalent(this.role, talent, x, y);
        gui.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.talents.put(i, gui);
        if (this.role.getTalentLevel(talent) < 5) {
            this.addButton(new GuiNpcButton(this, i + 10, x + 26, y, 14, 14, "+"));
            y += 8;
        }
        this.addLabel(new GuiNpcLabel(i, this.role.talents.get((Object)talent) + "/" + this.role.getNextLevel(talent), x + 26, y + 8));
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        int id = guibutton.id;
        if (id == 1) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.Companion);
        }
        if (id == 3) {
            Packets.sendServer(new SPacketCompanionOpenInv());
        }
        if (id >= 10) {
            this.selected = guibutton;
            this.lastPressedTime = this.startPressedTime = this.field_230706_i_.field_71441_e.func_72820_D();
            this.addExperience(1);
        }
    }

    private void addExperience(int exp) {
        EnumCompanionTalent talent = this.talents.get(this.selected.id - 10).talent;
        if (!this.role.canAddExp(-exp) && this.role.currentExp <= 0) {
            return;
        }
        if (exp > this.role.currentExp) {
            exp = this.role.currentExp;
        }
        Packets.sendServer(new SPacketCompanionTalentExp(talent, exp));
        this.role.talents.put(talent, this.role.talents.get((Object)talent) + exp);
        this.role.addExp(-exp);
        this.getLabel((int)(this.selected.id - 10)).label = new StringTextComponent(this.role.talents.get((Object)talent) + "/" + this.role.getNextLevel(talent));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.selected != null && this.field_230706_i_.field_71441_e.func_72820_D() - this.startPressedTime > 4L && this.lastPressedTime < this.field_230706_i_.field_71441_e.func_72820_D() && this.field_230706_i_.field_71441_e.func_72820_D() % 4L == 0L) {
            if (this.selected.func_231044_a_(mouseX, mouseY, 0)) {
                this.lastPressedTime = this.field_230706_i_.field_71441_e.func_72820_D();
                if (this.lastPressedTime - this.startPressedTime < 20L) {
                    this.addExperience(1);
                } else if (this.lastPressedTime - this.startPressedTime < 40L) {
                    this.addExperience(2);
                } else if (this.lastPressedTime - this.startPressedTime < 60L) {
                    this.addExperience(4);
                } else if (this.lastPressedTime - this.startPressedTime < 90L) {
                    this.addExperience(8);
                } else if (this.lastPressedTime - this.startPressedTime < 140L) {
                    this.addExperience(14);
                } else {
                    this.addExperience(28);
                }
            } else {
                this.lastPressedTime = 0L;
                this.selected = null;
            }
        }
        this.field_230706_i_.func_110434_K().func_110577_a(field_230665_h_);
        this.func_238474_b_(matrixStack, this.guiLeft + 4, this.guiTop + 20, 10, 64, 162, 5);
        if (this.role.currentExp > 0) {
            float v = 1.0f * (float)this.role.currentExp / (float)this.role.getMaxExp();
            if (v > 1.0f) {
                v = 1.0f;
            }
            this.func_238474_b_(matrixStack, this.guiLeft + 4, this.guiTop + 20, 10, 69, (int)(v * 162.0f), 5);
        }
        String s = this.role.currentExp + "\\" + this.role.getMaxExp();
        this.field_230706_i_.field_71466_p.func_238421_b_(matrixStack, s, (float)(this.guiLeft + this.imageWidth / 2 - this.field_230706_i_.field_71466_p.func_78256_a(s) / 2), (float)(this.guiTop + 10), CustomNpcResourceListener.DefaultTextColor);
        for (GuiTalent talent : this.talents.values()) {
            talent.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void save() {
    }

    public static class GuiTalent
    extends Screen {
        private EnumCompanionTalent talent;
        private int x;
        private int y;
        private RoleCompanion role;
        private static final ResourceLocation resource = new ResourceLocation("customnpcs:textures/gui/talent.png");

        public GuiTalent(RoleCompanion role, EnumCompanionTalent talent, int x, int y) {
            super(null);
            this.talent = talent;
            this.x = x;
            this.y = y;
            this.role = role;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft mc = Minecraft.func_71410_x();
            this.field_230706_i_.func_110434_K().func_110577_a(resource);
            ItemStack item = this.talent.item;
            if (item.func_77973_b() == null) {
                item = new ItemStack((IItemProvider)Blocks.field_150346_d);
            }
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            boolean hover = this.x < mouseX && this.x + 24 > mouseX && this.y < mouseY && this.y + 24 > mouseY;
            this.func_238474_b_(matrixStack, this.x, this.y, 0, hover ? 24 : 0, 24, 24);
            this.func_230926_e_(100);
            this.field_230707_j_.field_77023_b = 100.0f;
            RenderSystem.enableLighting();
            RenderSystem.enableRescaleNormal();
            this.field_230707_j_.func_180450_b(item, this.x + 4, this.y + 4);
            this.field_230707_j_.func_175030_a(mc.field_71466_p, item, this.x + 4, this.y + 4);
            RenderSystem.disableLighting();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)200.0f);
            GuiTalent.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)(this.role.getTalentLevel(this.talent) + ""), (int)(this.x + 20), (int)(this.y + 16), (int)0xFFFFFF);
            this.field_230707_j_.field_77023_b = 0.0f;
            this.func_230926_e_(0);
            RenderSystem.popMatrix();
        }
    }
}

