/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.select;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.screen.NpcGuiHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.shared.AssetsFinder;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiTextureSelection
extends SubGuiInterface
implements ICustomScrollListener {
    private String up = "..<" + I18n.func_135052_a((String)"gui.up", (Object[])new Object[0]) + ">..";
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollQuests;
    private String location = "";
    private String selectedDomain;
    public ResourceLocation selectedResource;
    private static final HashMap<String, List<ResourceLocation>> domains = new HashMap();
    private static final HashMap<String, ResourceLocation> textures = new HashMap();

    public GuiTextureSelection(EntityNPCInterface npc, String texture) {
        this.npc = npc;
        this.drawDefaultBackground = false;
        this.field_230704_d_ = "";
        this.setBackground("menubg.png");
        this.imageWidth = 366;
        this.imageHeight = 226;
        if (domains.isEmpty()) {
            List<ResourceLocation> resources = AssetsFinder.find("assets", ".png");
            for (ResourceLocation loc : resources) {
                domains.computeIfAbsent(loc.func_110624_b(), k -> new ArrayList()).add(loc);
            }
        }
        if (texture != null && !texture.isEmpty() && !texture.startsWith("http")) {
            this.selectedResource = new ResourceLocation(texture);
            this.selectedDomain = this.selectedResource.func_110624_b();
            if (!domains.containsKey(this.selectedDomain)) {
                this.selectedDomain = null;
            }
            int i = this.selectedResource.func_110623_a().lastIndexOf(47);
            this.location = this.selectedResource.func_110623_a().substring(0, i + 1);
        }
    }

    public static void clear() {
        domains.clear();
        textures.clear();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230704_d_ = this.selectedDomain != null ? this.selectedDomain + ":" + this.location : "";
        this.addButton(new GuiNpcButton(this, 2, this.guiLeft + 264, this.guiTop + 170, 90, 20, "gui.done"));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 264, this.guiTop + 190, 90, 20, "gui.cancel"));
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.func_231149_a_(120, 200);
        }
        if (this.selectedDomain == null) {
            this.scrollCategories.setList(Lists.newArrayList(domains.keySet()));
            if (this.selectedDomain != null) {
                this.scrollCategories.setSelected(this.selectedDomain);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.up);
            List<ResourceLocation> data = domains.get(this.selectedDomain);
            for (ResourceLocation td : data) {
                String path;
                int i;
                String fullPath = td.func_110623_a();
                if (fullPath.indexOf(47) >= 0) {
                    fullPath = fullPath.substring(0, fullPath.lastIndexOf(47) + 1);
                }
                if (!this.location.isEmpty() && (!fullPath.startsWith(this.location) || fullPath.equals(this.location)) || (i = (path = fullPath.substring(this.location.length())).indexOf(47)) < 0 || (path = path.substring(0, i)).isEmpty() || list.contains(path)) continue;
                list.add(path);
            }
            this.scrollCategories.setList(list);
        }
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollCategories);
        if (this.scrollQuests == null) {
            this.scrollQuests = new GuiCustomScroll(this, 1);
            this.scrollQuests.func_231149_a_(130, 200);
        }
        if (this.selectedDomain != null) {
            textures.clear();
            List<ResourceLocation> data = domains.get(this.selectedDomain);
            ArrayList<String> list = new ArrayList<String>();
            String loc = this.location;
            if (this.scrollCategories.hasSelected() && !this.scrollCategories.getSelected().equals(this.up)) {
                loc = loc + this.scrollCategories.getSelected() + '/';
            }
            for (ResourceLocation td : data) {
                String name = td.func_110623_a();
                String path = td.func_110623_a();
                if (name.indexOf(47) >= 0) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                    path = path.substring(0, path.lastIndexOf(47) + 1);
                }
                if (!path.equals(loc) || list.contains(name)) continue;
                list.add(name);
                textures.put(name, td);
            }
            this.scrollQuests.setList(list);
        }
        if (this.selectedResource != null) {
            this.scrollQuests.setSelected(this.selectedResource.func_110623_a());
        }
        this.scrollQuests.guiLeft = this.guiLeft + 125;
        this.scrollQuests.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollQuests);
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        if (guibutton.id == 2) {
            this.npc.display.setSkinTexture(this.selectedResource.toString());
        }
        this.npc.textureLocation = null;
        this.close();
        NpcGuiHelper.initGui(this.parent);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.npc.textureLocation = this.selectedResource;
        this.drawNpc((LivingEntity)this.npc, this.guiLeft + 276, this.guiTop + 140, 2.0f, 0);
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        if (scroll == this.scrollQuests) {
            if (scroll.id == 1) {
                this.selectedResource = textures.get(scroll.getSelected());
            }
        } else {
            this.func_231160_c_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
        if (scroll == this.scrollCategories) {
            if (this.selectedDomain == null) {
                this.selectedDomain = selection;
            } else if (selection.equals(this.up)) {
                int i = this.location.lastIndexOf(47, this.location.length() - 2);
                if (i < 0) {
                    if (this.location.isEmpty()) {
                        this.selectedDomain = null;
                    }
                    this.location = "";
                } else {
                    this.location = this.location.substring(0, i + 1);
                }
            } else {
                this.location = this.location + selection + '/';
            }
            this.scrollCategories.clearSelection();
            this.scrollQuests.clearSelection();
            this.func_231160_c_();
        } else {
            this.npc.display.setSkinTexture(this.selectedResource.toString());
            this.close();
            NpcGuiHelper.initGui(this.parent);
        }
    }
}

