/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.mixin.MouseHelperMixin;
import noppes.npcs.util.NaturalOrderComparator;

public class GuiCustomScroll
extends Screen {
    public static final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/misc.png");
    protected List<String> list;
    private int listSize = 0;
    public int id;
    public int guiLeft = 0;
    public int guiTop = 0;
    private int selected = -1;
    private List<Integer> selectedList;
    private int hover;
    private int listHeight;
    private int scrollY;
    private int maxScrollY;
    private int scrollHeight;
    private boolean isScrolling;
    public boolean multipleSelection = false;
    public ICustomScrollListener listener;
    private boolean isSorted = true;
    public boolean visible = true;
    private boolean selectable = true;
    private boolean mouseInList = false;
    private int lastClickedItem = -1;
    private long lastClickedTime = 0L;
    private GuiNpcTextField textField;
    private boolean hasSearch = true;
    private String searchStr = "";
    private String[] searchWords = new String[0];

    public GuiCustomScroll(Screen parent, int id) {
        super(null);
        this.field_230708_k_ = 176;
        this.field_230709_l_ = 159;
        this.hover = -1;
        this.selectedList = new ArrayList<Integer>();
        this.listHeight = 0;
        this.scrollY = 0;
        this.scrollHeight = 0;
        this.isScrolling = false;
        if (parent instanceof ICustomScrollListener) {
            this.listener = (ICustomScrollListener)parent;
        }
        this.list = new ArrayList<String>();
        this.id = id;
        this.textField = new GuiNpcTextField(0, null, 0, 0, 176, 20, "");
    }

    public GuiCustomScroll(Screen parent, int id, boolean multipleSelection) {
        this(parent, id);
        this.multipleSelection = multipleSelection;
    }

    public void func_231149_a_(int x, int y) {
        this.textField.func_230991_b_(x);
        this.field_230709_l_ = y - this.textFieldHeight();
        this.field_230708_k_ = x;
        this.listHeight = 14 * this.listSize;
        this.scrollHeight = this.listHeight > 0 ? (int)((double)(this.field_230709_l_ - 8) / (double)this.listHeight * (double)(this.field_230709_l_ - 8)) : Integer.MAX_VALUE;
        this.maxScrollY = this.listHeight - (this.field_230709_l_ - 8) - 1;
        if (this.maxScrollY > 0 && this.scrollY > this.maxScrollY || this.maxScrollY <= 0 && this.scrollY > this.scrollHeight) {
            this.scrollY = 0;
        }
    }

    public void disabledSearch() {
        this.hasSearch = false;
    }

    private int textFieldHeight() {
        return this.hasSearch ? 22 : 0;
    }

    private void reset() {
        this.listSize = this.searchWords.length == 0 ? this.list.size() : (int)this.list.stream().filter(this::isSearched).count();
        this.func_231149_a_(this.field_230708_k_, this.field_230709_l_ + this.textFieldHeight());
    }

    private boolean isSearched(String s) {
        s = I18n.func_135052_a((String)s, (Object[])new Object[0]);
        for (String k : this.searchWords) {
            if (s.toLowerCase().contains(k.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public int getWidth() {
        return this.field_230708_k_;
    }

    public int getHeight() {
        return this.field_230709_l_ + this.textFieldHeight();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        if (this.hasSearch) {
            this.textField.field_230690_l_ = this.guiLeft;
            this.textField.field_230691_m_ = this.guiTop;
            this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.guiTop += this.textFieldHeight();
        this.mouseInList = this.isMouseOver(mouseX, mouseY);
        this.func_238468_a_(matrixStack, this.guiLeft, this.guiTop, this.field_230708_k_ + this.guiLeft, this.field_230709_l_ + this.guiTop, -1072689136, -804253680);
        this.field_230706_i_.func_110434_K().func_110577_a(resource);
        if (this.scrollHeight < this.field_230709_l_ - 8) {
            this.drawScrollBar(matrixStack);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.guiLeft, (double)this.guiTop, 0.0);
        if (this.selectable) {
            this.hover = this.getMouseOver(mouseX, mouseY);
        }
        this.drawItems(matrixStack);
        matrixStack.func_227865_b_();
        if (this.scrollHeight < this.field_230709_l_ - 8) {
            mouseX -= this.guiLeft;
            mouseY -= this.guiTop;
            if (((MouseHelperMixin)this.field_230706_i_.field_71417_B).getActiveButton() == 0) {
                if (mouseX >= this.field_230708_k_ - 10 && mouseX < this.field_230708_k_ - 2 && mouseY >= 4 && mouseY < this.field_230709_l_) {
                    this.isScrolling = true;
                }
            } else {
                this.isScrolling = false;
            }
            if (this.isScrolling) {
                this.scrollY = (mouseY - 8) * this.listHeight / (this.field_230709_l_ - 8) - this.scrollHeight;
                if (this.scrollY < 0) {
                    this.scrollY = 0;
                }
                if (this.scrollY > this.maxScrollY) {
                    this.scrollY = this.maxScrollY;
                }
            }
        }
        this.guiTop -= this.textFieldHeight();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double mouseScrolled) {
        if (mouseScrolled != 0.0 && this.mouseInList) {
            this.scrollY += mouseScrolled > 0.0 ? -14 : 14;
            if (this.scrollY > this.maxScrollY) {
                this.scrollY = this.maxScrollY;
            }
            if (this.scrollY < 0) {
                this.scrollY = 0;
            }
            return true;
        }
        return false;
    }

    public boolean mouseInOption(int i, int j, int k) {
        int xOffset = this.scrollHeight < this.field_230709_l_ - 8 ? 10 : 0;
        int l = 4;
        int i1 = 14 * k + 4 - this.scrollY;
        return i >= l - 1 && i < this.field_230708_k_ - 2 - xOffset && j >= i1 - 1 && j < i1 + 8;
    }

    protected void drawItems(MatrixStack matrixStack) {
        int displayIndex = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.isSearched(this.list.get(i))) continue;
            int j = 4;
            int k = 14 * displayIndex + 4 - this.scrollY;
            if (k >= 4 && k + 12 < this.field_230709_l_) {
                int xOffset = this.scrollHeight < this.field_230709_l_ - 8 ? 0 : 10;
                String displayString = I18n.func_135052_a((String)this.list.get(i), (Object[])new Object[0]);
                String text = "";
                float maxWidth = (float)(this.field_230708_k_ + xOffset - 8) * 0.8f;
                if ((float)this.field_230712_o_.func_78256_a(displayString) > maxWidth) {
                    for (int h = 0; h < displayString.length(); ++h) {
                        char c = displayString.charAt(h);
                        if ((float)this.field_230712_o_.func_78256_a(text = text + c) > maxWidth) break;
                    }
                    if (displayString.length() > text.length()) {
                        text = text + "...";
                    }
                } else {
                    text = displayString;
                }
                if (this.multipleSelection && this.selectedList.contains(i) || !this.multipleSelection && this.selected == i) {
                    this.func_238473_b_(matrixStack, j - 2, k - 4, k + 10, -1);
                    this.func_238473_b_(matrixStack, j + this.field_230708_k_ - 18 + xOffset, k - 4, k + 10, -1);
                    this.func_238465_a_(matrixStack, j - 2, j + this.field_230708_k_ - 18 + xOffset, k - 3, -1);
                    this.func_238465_a_(matrixStack, j - 2, j + this.field_230708_k_ - 18 + xOffset, k + 10, -1);
                    this.field_230712_o_.func_238421_b_(matrixStack, text, (float)j, (float)k, 0xFFFFFF);
                } else if (i == this.hover) {
                    this.field_230712_o_.func_238421_b_(matrixStack, text, (float)j, (float)k, 65280);
                } else {
                    this.field_230712_o_.func_238421_b_(matrixStack, text, (float)j, (float)k, 0xFFFFFF);
                }
            }
            ++displayIndex;
        }
    }

    public String getSelected() {
        if (this.selected < 0 || this.selected >= this.list.size()) {
            return null;
        }
        return this.list.get(this.selected);
    }

    private int getMouseOver(int i, int j) {
        if ((i -= this.guiLeft) >= 4 && i < this.field_230708_k_ - 4 && (j -= this.guiTop) >= 4 && j < this.field_230709_l_) {
            int displayIndex = 0;
            for (int j1 = 0; j1 < this.list.size(); ++j1) {
                if (!this.isSearched(this.list.get(j1))) continue;
                if (!this.mouseInOption(i, j, displayIndex)) {
                    ++displayIndex;
                    continue;
                }
                return j1;
            }
        }
        return -1;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (this.hasSearch) {
            boolean bo = this.textField.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
            if (!this.searchStr.equals(this.textField.func_146179_b())) {
                this.searchStr = this.textField.func_146179_b().trim();
                this.searchWords = this.searchStr.split(" ");
                this.reset();
            }
            return bo;
        }
        return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        if (this.hasSearch) {
            boolean bo = this.textField.func_231042_a_(p_231042_1_, p_231042_2_);
            if (!this.searchStr.equals(this.textField.func_146179_b())) {
                this.searchStr = this.textField.func_146179_b().trim();
                this.searchWords = this.searchStr.split(" ");
                this.reset();
            }
            return bo;
        }
        return super.func_231042_a_(p_231042_1_, p_231042_2_);
    }

    public boolean func_231044_a_(double i, double j, int k) {
        if (this.hasSearch) {
            this.textField.func_231044_a_(i, j, k);
        }
        if (k != 0 || this.hover < 0) {
            return false;
        }
        if (this.multipleSelection) {
            if (this.selectedList.contains(this.hover)) {
                this.selectedList.remove((Object)this.hover);
            } else {
                this.selectedList.add(this.hover);
            }
        } else {
            this.selected = this.hover;
            this.hover = -1;
        }
        if (this.listener != null) {
            long time = System.currentTimeMillis();
            this.listener.scrollClicked(i, j, k, this);
            if (this.selected >= 0 && this.selected == this.lastClickedItem && time - this.lastClickedTime < 500L) {
                this.listener.scrollDoubleClicked(this.getSelected(), this);
            }
            this.lastClickedTime = time;
            this.lastClickedItem = this.selected;
        }
        return true;
    }

    private void drawScrollBar(MatrixStack matrixStack) {
        int j;
        int i = this.guiLeft + this.field_230708_k_ - 9;
        int k = j = this.guiTop + (int)((double)this.scrollY / (double)this.listHeight * (double)(this.field_230709_l_ - 8)) + 4;
        this.func_238474_b_(matrixStack, i, k, this.field_230708_k_, 9, 5, 1);
        ++k;
        while (k < j + this.scrollHeight - 1) {
            this.func_238474_b_(matrixStack, i, k, this.field_230708_k_, 10, 5, 1);
            ++k;
        }
        this.func_238474_b_(matrixStack, i, k, this.field_230708_k_, 11, 5, 1);
    }

    public boolean hasSelected() {
        return this.selected >= 0;
    }

    public void setList(List<String> list) {
        if (this.isSameList(list)) {
            return;
        }
        this.isSorted = true;
        this.scrollY = 0;
        Collections.sort(list, new NaturalOrderComparator());
        this.list = list;
        this.reset();
    }

    public void setUnsortedList(List<String> list) {
        if (this.isSameList(list)) {
            return;
        }
        this.isSorted = false;
        this.scrollY = 0;
        this.list = list;
        this.reset();
    }

    private boolean isSameList(List<String> list) {
        if (this.list.size() != list.size()) {
            return false;
        }
        for (String s : this.list) {
            if (list.contains(s)) continue;
            return false;
        }
        return true;
    }

    public void replace(String old, String name) {
        String select = this.getSelected();
        this.list.remove(old);
        this.list.add(name);
        if (this.isSorted) {
            Collections.sort(this.list, new NaturalOrderComparator());
        }
        if (old.equals(select)) {
            select = name;
        }
        this.setSelected(select);
        this.reset();
    }

    public void setSelected(String name) {
        this.selected = this.list.indexOf(name);
    }

    public void clear() {
        this.list = new ArrayList<String>();
        this.selected = -1;
        this.scrollY = 0;
        this.searchStr = "";
        this.searchWords = new String[0];
        this.textField.func_146180_a("");
        this.reset();
    }

    public void clearSelection() {
        this.list = new ArrayList<String>();
        this.selected = -1;
    }

    public List<String> getList() {
        return this.list;
    }

    public List<String> getSelectedList() {
        return IntStream.range(0, this.list.size()).filter(i -> this.selectedList.contains(i)).mapToObj(i -> this.list.get(i)).collect(Collectors.toList());
    }

    public void setSelectedList(Collection<String> selectedList) {
        this.selectedList = selectedList.stream().map(t -> this.list.indexOf(t)).collect(Collectors.toList());
    }

    public GuiCustomScroll setUnselectable() {
        this.selectable = false;
        return this;
    }

    public void scrollTo(String name) {
        int i = this.list.indexOf(name);
        if (i < 0 || this.scrollHeight >= this.field_230709_l_ - 8) {
            return;
        }
        int pos = (int)(1.0f * (float)i / (float)this.list.size() * (float)this.listHeight);
        if (pos > this.maxScrollY) {
            pos = this.maxScrollY;
        }
        this.scrollY = pos;
    }

    public boolean isMouseOver(int x, int y) {
        return x >= this.guiLeft && x <= this.guiLeft + this.field_230708_k_ && y >= this.guiTop && y <= this.guiTop + this.field_230709_l_;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void setSelectedIndex(int i) {
        this.selected = i < 0 ? -1 : i;
    }
}

